/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openmods.Log;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncMapProvider;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncChannelHolder;
import openmods.utils.ByteUtils;

public abstract class SyncMap<H extends ISyncMapProvider> {
    private static final int MAX_OBJECT_NUM = 16;
    protected final H handler;
    private Set<Integer> knownUsers = Sets.newHashSet();
    private ISyncableObject[] objects = new ISyncableObject[16];
    private Map<String, ISyncableObject> nameMap = Maps.newHashMap();
    private Map<ISyncableObject, Integer> objectToId = Maps.newIdentityHashMap();
    private Set<ISyncListener> syncListeners = Sets.newIdentityHashSet();
    private Set<ISyncListener> updateListeners = Sets.newIdentityHashSet();
    private int index = 0;

    protected SyncMap(H handler) {
        this.handler = handler;
    }

    public void put(String name, ISyncableObject value) {
        Preconditions.checkState((this.index < 16 ? 1 : 0) != 0, (String)"Can't add more than %s objects", (Object[])new Object[]{16});
        int objId = this.index++;
        this.objects[objId] = value;
        this.nameMap.put(name, value);
        Integer prev = this.objectToId.put(value, objId);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Object %s registered twice, under ids %s and %s", (Object[])new Object[]{value, prev, objId});
    }

    public ISyncableObject get(String name) {
        ISyncableObject result = this.nameMap.get(name);
        if (result == null) {
            throw new NoSuchElementException(name);
        }
        return result;
    }

    public ISyncableObject get(int objectId) {
        try {
            return this.objects[objectId];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException(Integer.toString(objectId));
        }
    }

    public int getId(ISyncableObject object) {
        Integer result = this.objectToId.get(object);
        if (result == null) {
            throw new NoSuchElementException(String.valueOf(object));
        }
        return result;
    }

    public int size() {
        return this.index;
    }

    public void readFromStream(DataInputStream dis) throws IOException {
        Set changes = Sets.newIdentityHashSet();
        int currentBit = 0;
        for (int mask = dis.readShort(); mask != 0; mask >>= 1) {
            ISyncableObject object;
            if ((mask & 1) != 0 && (object = this.objects[currentBit]) != null) {
                object.readFromStream(dis);
                changes.add(object);
            }
            ++currentBit;
        }
        if (!changes.isEmpty()) {
            SyncMap.notifySyncListeners(this.updateListeners, Collections.unmodifiableSet(changes));
        }
    }

    private void writeToStream(DataOutputStream dos, boolean fullPacket) throws IOException {
        ISyncableObject object;
        int i;
        int mask = 0;
        for (i = 0; i < this.index; ++i) {
            object = this.objects[i];
            if (object == null || !fullPacket && !object.isDirty()) continue;
            mask = ByteUtils.on(mask, i);
        }
        dos.writeShort(mask);
        for (i = 0; i < this.index; ++i) {
            object = this.objects[i];
            if (object == null || !fullPacket && !object.isDirty()) continue;
            object.writeToStream(dos, fullPacket);
        }
    }

    protected abstract HandlerType getHandlerType();

    protected abstract Set<EntityPlayerMP> getPlayersWatching();

    protected abstract World getWorld();

    protected abstract boolean isInvalid();

    public void sync() {
        ByteBuf deltaPayload;
        Preconditions.checkState((!this.getWorld().field_72995_K ? 1 : 0) != 0, (Object)"This method can only be used server side");
        if (this.isInvalid()) {
            return;
        }
        Set<ISyncableObject> changes = this.listChanges();
        boolean hasChanges = !changes.isEmpty();
        ArrayList fullPacketTargets = Lists.newArrayList();
        ArrayList deltaPacketTargets = Lists.newArrayList();
        Set<EntityPlayerMP> players = this.getPlayersWatching();
        for (EntityPlayerMP player : players) {
            if (this.knownUsers.contains(player.func_145782_y())) {
                if (!hasChanges) continue;
                deltaPacketTargets.add(player);
                continue;
            }
            this.knownUsers.add(player.func_145782_y());
            fullPacketTargets.add(player);
        }
        try {
            if (!deltaPacketTargets.isEmpty()) {
                deltaPayload = this.createPayload(false);
                SyncChannelHolder.INSTANCE.sendPayloadToPlayers(deltaPayload, deltaPacketTargets);
            }
        }
        catch (IOException e) {
            Log.warn(e, "IOError during delta sync", new Object[0]);
        }
        try {
            if (!fullPacketTargets.isEmpty()) {
                deltaPayload = this.createPayload(true);
                SyncChannelHolder.INSTANCE.sendPayloadToPlayers(deltaPayload, fullPacketTargets);
            }
        }
        catch (IOException e) {
            Log.warn(e, "IOError during full sync", new Object[0]);
        }
        if (hasChanges) {
            SyncMap.unmarkChanges(changes);
            SyncMap.notifySyncListeners(this.syncListeners, Collections.unmodifiableSet(changes));
        }
    }

    private Set<ISyncableObject> listChanges() {
        Set changes = Sets.newIdentityHashSet();
        for (int i = 0; i < this.index; ++i) {
            ISyncableObject obj = this.objects[i];
            if (obj == null || !obj.isDirty()) continue;
            changes.add(obj);
        }
        return changes;
    }

    private static void unmarkChanges(Set<ISyncableObject> changes) {
        for (ISyncableObject obj : changes) {
            obj.markClean();
        }
    }

    public ByteBuf createPayload(boolean fullPacket) throws IOException {
        ByteBuf output = Unpooled.buffer();
        HandlerType type = this.getHandlerType();
        ByteBufUtils.writeVarInt((ByteBuf)output, (int)type.ordinal(), (int)5);
        DataOutputStream dataOutput = new DataOutputStream((OutputStream)new ByteBufOutputStream(output));
        type.writeHandlerInfo((ISyncMapProvider)this.handler, dataOutput);
        this.writeToStream(dataOutput, fullPacket);
        return output.copy();
    }

    public static ISyncMapProvider findSyncMap(World world, DataInput input) throws IOException {
        int handlerTypeId = ByteUtils.readVLI(input);
        Preconditions.checkPositionIndex((int)handlerTypeId, (int)HandlerType.TYPES.length, (String)"handler type");
        HandlerType handlerType = HandlerType.TYPES[handlerTypeId];
        ISyncMapProvider handler = handlerType.findHandler(world, input);
        return handler;
    }

    public void writeToNBT(NBTTagCompound tag) {
        for (Map.Entry<String, ISyncableObject> entry : this.nameMap.entrySet()) {
            String name = entry.getKey();
            try {
                entry.getValue().writeToNBT(tag, name);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to read value of field %s", name), e);
            }
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (Map.Entry<String, ISyncableObject> entry : this.nameMap.entrySet()) {
            String name = entry.getKey();
            try {
                ISyncableObject obj = entry.getValue();
                obj.readFromNBT(tag, name);
                obj.markClean();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to read value of field %s", name), e);
            }
        }
    }

    private static void notifySyncListeners(Collection<ISyncListener> listeners, Set<ISyncableObject> allChanges) {
        for (ISyncListener listener : listeners) {
            listener.onSync(allChanges);
        }
    }

    public void addSyncListener(ISyncListener listener) {
        this.syncListeners.add(listener);
    }

    public void addUpdateListener(ISyncListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateListener(ISyncListener dispatcher) {
        this.updateListeners.remove(dispatcher);
    }

    public static enum HandlerType {
        TILE_ENTITY{

            @Override
            public ISyncMapProvider findHandler(World world, DataInput input) throws IOException {
                TileEntity tile;
                int x = input.readInt();
                int y = input.readInt();
                int z = input.readInt();
                if (world != null && world.func_72899_e(x, y, z) && (tile = world.func_147438_o(x, y, z)) instanceof ISyncMapProvider) {
                    return (ISyncMapProvider)tile;
                }
                Log.warn("Invalid handler info: can't find ISyncHandler TE @ (%d,%d,%d)", x, y, z);
                return null;
            }

            @Override
            public void writeHandlerInfo(ISyncMapProvider handler, DataOutput output) throws IOException {
                try {
                    TileEntity te = (TileEntity)handler;
                    output.writeInt(te.field_145851_c);
                    output.writeInt(te.field_145848_d);
                    output.writeInt(te.field_145849_e);
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("Invalid usage of handler type", e);
                }
            }
        }
        ,
        ENTITY{

            @Override
            public ISyncMapProvider findHandler(World world, DataInput input) throws IOException {
                int entityId = input.readInt();
                Entity entity = world.func_73045_a(entityId);
                if (entity instanceof ISyncMapProvider) {
                    return (ISyncMapProvider)entity;
                }
                Log.warn("Invalid handler info: can't find ISyncHandler entity id %d", entityId);
                return null;
            }

            @Override
            public void writeHandlerInfo(ISyncMapProvider handler, DataOutput output) throws IOException {
                try {
                    Entity e = (Entity)handler;
                    output.writeInt(e.func_145782_y());
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("Invalid usage of handler type", e);
                }
            }
        };

        private static final HandlerType[] TYPES;

        public abstract ISyncMapProvider findHandler(World var1, DataInput var2) throws IOException;

        public abstract void writeHandlerInfo(ISyncMapProvider var1, DataOutput var2) throws IOException;

        static {
            TYPES = HandlerType.values();
        }
    }
}

