/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.TreeMultimap;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import openmods.structured.Command;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureElement;

public abstract class StructuredData<C extends IStructureContainer<E>, E extends IStructureElement> {
    protected byte version;
    protected int elementCounter;
    protected int containerCounter;
    protected final SortedMap<Integer, E> elements = Maps.newTreeMap();
    protected final SortedMap<Integer, C> containers = Maps.newTreeMap();
    protected final TreeMultimap<Integer, Integer> containerToElement = TreeMultimap.create();

    public void reset() {
        this.elements.clear();
        this.containers.clear();
        this.containerToElement.clear();
    }

    protected SortedSet<Integer> removeContainer(int containerId) {
        Preconditions.checkArgument((boolean)this.containerToElement.containsKey((Object)containerId), (String)"Container %s doesn't exists", (Object[])new Object[]{containerId});
        SortedSet removedElements = this.containerToElement.removeAll((Object)containerId);
        for (Integer id : removedElements) {
            this.elements.remove(id);
        }
        this.containers.remove(containerId);
        return removedElements;
    }

    protected int addContainer(int containerId, C container, int firstElementId) {
        List newElements = container.createElements();
        Preconditions.checkArgument((!newElements.isEmpty() ? 1 : 0) != 0, (String)"New container %s has no elements", (Object[])new Object[]{container});
        for (IStructureElement element : newElements) {
            int elementId = firstElementId++;
            this.elements.put(elementId, element);
            this.containerToElement.put((Object)containerId, (Object)elementId);
            container.onElementAdded((IStructureElement)element, elementId);
        }
        this.containers.put(containerId, container);
        return firstElementId;
    }

    protected void updateVersion(Iterable<Command> commands) {
        for (Command c : commands) {
            this.version = (byte)(this.version + c.versionChange());
        }
    }
}

