/*
 * Decompiled with CFR 0.152.
 */
package openmods.context;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import openmods.Log;
import openmods.asm.MethodMatcher;
import openmods.context.ContextManager;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ContextClassTransformer
extends ClassVisitor {
    private static final Type CONTEXT_MANAGER = Type.getType(ContextManager.class);
    private final List<MethodMatcher> methods;

    private static boolean isMethodExit(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                return true;
            }
        }
        return false;
    }

    private boolean shouldWrap(String name, String desc) {
        for (MethodMatcher matcher : this.methods) {
            if (!matcher.match(name, desc)) continue;
            return true;
        }
        return false;
    }

    public ContextClassTransformer(ClassVisitor cv, Collection<MethodMatcher> matchers) {
        super(327680, cv);
        this.methods = ImmutableList.copyOf(matchers);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.shouldWrap(name, desc)) {
            Log.info("Adding context wrapper to %s %s", name, desc);
            return new WrappingMethodVisitor(mv);
        }
        return mv;
    }

    private static class WrappingMethodVisitor
    extends MethodVisitor {
        public WrappingMethodVisitor(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitCode() {
            super.visitCode();
            super.visitMethodInsn(184, CONTEXT_MANAGER.getInternalName(), "push", "()V");
        }

        public void visitInsn(int opcode) {
            if (ContextClassTransformer.isMethodExit(opcode)) {
                super.visitMethodInsn(184, CONTEXT_MANAGER.getInternalName(), "pop", "()V");
            }
            super.visitInsn(opcode);
        }
    }
}

