/*
 * Decompiled with CFR 0.152.
 */
package openmods.config.properties;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.eventhandler.Event;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import openmods.Log;
import openmods.config.properties.ConfigProperty;
import openmods.config.properties.ConfigurationChange;
import openmods.config.properties.OnLineModifiable;
import openmods.utils.io.IStringSerializable;
import openmods.utils.io.StringConversionException;
import openmods.utils.io.TypeRW;
import org.apache.commons.lang3.StringUtils;

public abstract class ConfigPropertyMeta {
    public final String name;
    public final String category;
    public final String comment;
    public final Property.Type type;
    protected final Field field;
    private final boolean onLine;
    private final Object defaultValue;
    private final String[] defaultText;
    protected final IStringSerializable<?> converter;
    protected final Property wrappedProperty;
    public static final Map<Class<?>, Property.Type> CONFIG_TYPES = ImmutableMap.builder().put(Integer.class, (Object)Property.Type.INTEGER).put(Integer.TYPE, (Object)Property.Type.INTEGER).put(Boolean.class, (Object)Property.Type.BOOLEAN).put(Boolean.TYPE, (Object)Property.Type.BOOLEAN).put(Byte.class, (Object)Property.Type.INTEGER).put(Byte.TYPE, (Object)Property.Type.INTEGER).put(Double.class, (Object)Property.Type.DOUBLE).put(Double.TYPE, (Object)Property.Type.DOUBLE).put(Float.class, (Object)Property.Type.DOUBLE).put(Float.TYPE, (Object)Property.Type.DOUBLE).put(Long.class, (Object)Property.Type.INTEGER).put(Long.TYPE, (Object)Property.Type.INTEGER).put(Short.class, (Object)Property.Type.INTEGER).put(Short.TYPE, (Object)Property.Type.INTEGER).put(String.class, (Object)Property.Type.STRING).build();

    protected ConfigPropertyMeta(Configuration config, Field field, ConfigProperty annotation) {
        this.comment = annotation.comment();
        this.category = annotation.category();
        OnLineModifiable mod = field.getAnnotation(OnLineModifiable.class);
        this.onLine = mod != null;
        String name = annotation.name();
        String category = annotation.category();
        if (Strings.isNullOrEmpty((String)name)) {
            name = field.getName();
        }
        if (Strings.isNullOrEmpty((String)category)) {
            category = null;
        }
        this.name = name;
        this.field = field;
        this.defaultValue = this.getFieldValue();
        Preconditions.checkNotNull((Object)this.defaultValue, (String)"Config field %s has no default value", (Object[])new Object[]{name});
        this.defaultText = this.convertToStringArray(this.defaultValue);
        Class<? extends Object> fieldType = this.getFieldType();
        this.type = CONFIG_TYPES.get(fieldType);
        Preconditions.checkNotNull((Object)this.type, (String)"Config field %s has no property type mapping", (Object[])new Object[]{name});
        this.converter = TypeRW.TYPES.get(fieldType);
        Preconditions.checkNotNull(this.converter, (String)"Config field %s has no known conversion from string", (Object[])new Object[]{name});
        this.wrappedProperty = this.getProperty(config, this.type, this.defaultValue);
    }

    void updateValueFromConfig(boolean force) {
        if (!(force || this.wrappedProperty.wasRead() || this.wrappedProperty.isList())) {
            return;
        }
        Property.Type actualType = this.wrappedProperty.getType();
        Preconditions.checkState((this.type == actualType ? 1 : 0) != 0, (String)"Invalid config property type '%s', expected '%s'", (Object[])new Object[]{actualType, this.type});
        Object[] currentValue = this.getPropertyValue();
        try {
            Object converted = this.convertValue((String[])currentValue);
            this.setFieldValue(converted);
        }
        catch (StringConversionException e) {
            Log.warn(e, "Invalid config property value %s, using default value", Arrays.toString(currentValue));
        }
    }

    protected void setFieldValue(Object value) {
        try {
            this.field.set(null, value);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected Object getFieldValue() {
        try {
            return this.field.get(null);
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
    }

    protected abstract Class<? extends Object> getFieldType();

    protected abstract Property getProperty(Configuration var1, Property.Type var2, Object var3);

    public abstract String[] getPropertyValue();

    protected abstract void setPropertyValue(String ... var1);

    protected abstract Object convertValue(String ... var1);

    public abstract boolean acceptsMultipleValues();

    public abstract String valueDescription();

    protected abstract String[] convertToStringArray(Object var1);

    public Result tryChangeValue(String ... proposedValues) {
        ConfigurationChange.Pre evt = new ConfigurationChange.Pre(this.name, this.category, proposedValues);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return Result.CANCELLED;
        }
        Object converted = this.convertValue(evt.proposedValues);
        if (this.onLine) {
            this.setFieldValue(converted);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ConfigurationChange.Post(this.name, this.category));
        this.setPropertyValue(evt.proposedValues);
        return this.onLine ? Result.ONLINE : Result.OFFLINE;
    }

    public String[] getDefaultValues() {
        return (String[])this.defaultText.clone();
    }

    public static ConfigPropertyMeta createMetaForField(Configuration config, Field field) {
        ConfigProperty annotation = field.getAnnotation(ConfigProperty.class);
        if (annotation == null) {
            return null;
        }
        Class<?> fieldType = field.getType();
        return fieldType.isArray() ? new MultipleValues(config, field, annotation) : new SingleValue(config, field, annotation);
    }

    private static class MultipleValues
    extends ConfigPropertyMeta {
        protected MultipleValues(Configuration config, Field field, ConfigProperty annotation) {
            super(config, field, annotation);
        }

        @Override
        protected Class<? extends Object> getFieldType() {
            return this.field.getType().getComponentType();
        }

        @Override
        protected Property getProperty(Configuration configFile, Property.Type expectedType, Object defaultValue) {
            String[] defaultStrings = this.convertToStringArray(defaultValue);
            return configFile.get(this.category, this.name, defaultStrings, this.comment, expectedType);
        }

        @Override
        protected Object convertValue(String ... values) {
            Object result = Array.newInstance(this.field.getType().getComponentType(), values.length);
            CharMatcher matcher = CharMatcher.is((char)'\"');
            for (int i = 0; i < values.length; ++i) {
                String value = matcher.trimFrom((CharSequence)StringUtils.strip((String)values[i]));
                Object converted = this.converter.readFromString(value);
                Array.set(result, i, converted);
            }
            return result;
        }

        @Override
        public String[] getPropertyValue() {
            return this.wrappedProperty.getStringList();
        }

        @Override
        protected void setPropertyValue(String ... values) {
            this.wrappedProperty.set(values);
        }

        @Override
        public boolean acceptsMultipleValues() {
            return true;
        }

        @Override
        public String valueDescription() {
            return Arrays.toString(this.wrappedProperty.getStringList());
        }

        @Override
        protected String[] convertToStringArray(Object value) {
            Preconditions.checkArgument((boolean)value.getClass().isArray(), (String)"Type %s is not an array", (Object[])new Object[]{value.getClass()});
            int length = Array.getLength(value);
            String[] result = new String[length];
            for (int i = 0; i < length; ++i) {
                result[i] = String.format("\"%s\"", Array.get(value, i).toString());
            }
            return result;
        }
    }

    private static class SingleValue
    extends ConfigPropertyMeta {
        protected SingleValue(Configuration config, Field field, ConfigProperty annotation) {
            super(config, field, annotation);
        }

        @Override
        protected Class<? extends Object> getFieldType() {
            return this.field.getType();
        }

        @Override
        protected Property getProperty(Configuration configFile, Property.Type expectedType, Object defaultValue) {
            String defaultString = defaultValue.toString();
            return configFile.get(this.category, this.name, defaultString, this.comment, expectedType);
        }

        @Override
        protected Object convertValue(String ... values) {
            Preconditions.checkArgument((values.length == 1 ? 1 : 0) != 0, (Object)"This parameter has only one value");
            String value = values[0];
            return this.converter.readFromString(value);
        }

        @Override
        public String[] getPropertyValue() {
            return new String[]{this.wrappedProperty.getString()};
        }

        @Override
        protected void setPropertyValue(String ... values) {
            Preconditions.checkArgument((values.length == 1 ? 1 : 0) != 0, (Object)"This parameter has only one value");
            this.wrappedProperty.set(values[0]);
        }

        @Override
        public boolean acceptsMultipleValues() {
            return false;
        }

        @Override
        public String valueDescription() {
            return this.wrappedProperty.getString();
        }

        @Override
        protected String[] convertToStringArray(Object value) {
            return new String[]{value.toString()};
        }
    }

    public static enum Result {
        CANCELLED,
        ONLINE,
        OFFLINE;

    }
}

