/*
 * Decompiled with CFR 0.152.
 */
package murlen.util.fscript;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

final class LineLoader {
    ArrayList lines;
    private String contLine;
    private char[] emptyLine = new char[0];
    int curLine = 0;
    String forError;

    LineLoader() {
        this.lines = new ArrayList(200);
    }

    final void load(Reader is) throws IOException {
        BufferedReader in = new BufferedReader(is);
        String s = in.readLine();
        while (s != null) {
            this.addLine(s);
            s = in.readLine();
        }
        in.close();
        this.curLine = 0;
    }

    final void reset() {
        this.lines = new ArrayList(200);
        this.curLine = 0;
    }

    final void addLine(String s) {
        if (!s.trim().equals("")) {
            if (s.endsWith("...") && !this.hasComment(s)) {
                this.contLine = this.contLine != null ? this.contLine + s.substring(0, s.length() - 3) : s.substring(0, s.length() - 3);
            } else {
                this.contLine = this.contLine != null ? this.contLine + s : s;
                char[] line = this.contLine.toCharArray();
                LineLoader.checkLine(line);
                this.lines.add(line);
                this.contLine = null;
            }
        } else {
            this.lines.add(this.emptyLine);
        }
    }

    private boolean hasComment(String s) {
        while (!s.equals("")) {
            int hash = s.indexOf(35);
            if (hash == -1) {
                return false;
            }
            int quote = s.indexOf(34);
            if (quote == -1 || hash < quote) {
                return true;
            }
            boolean cont = true;
            while (cont) {
                if ((quote = (s = s.substring(quote + 1)).indexOf(34)) != 0 && s.charAt(quote - 1) == '\\') continue;
                cont = false;
            }
            s = s.substring(quote + 1);
        }
        return false;
    }

    final void setCurLine(int n) {
        if (n > this.lines.size()) {
            n = this.lines.size() - 1;
        } else if (n < 0) {
            n = 0;
        }
        this.curLine = n;
    }

    final int getCurLine() {
        return this.curLine;
    }

    final int lineCount() {
        return this.lines.size();
    }

    final char[] getLine() {
        return (char[])this.lines.get(this.curLine);
    }

    final String getLineAsString() {
        if (this.curLine == -1) {
            return this.forError;
        }
        return new String((char[])this.lines.get(this.curLine));
    }

    final char[] getLine(int n) {
        if (n < 0 || n >= this.lines.size()) {
            return this.emptyLine;
        }
        return (char[])this.lines.get(n);
    }

    final String getLineAsString(int n) {
        if (n < 0 || n >= this.lines.size()) {
            return "";
        }
        return new String((char[])this.lines.get(n));
    }

    static void checkLine(char[] chars) {
        boolean inQuotes = false;
        int brCount = 0;
        if (chars != null) {
            for (int n = 0; n < chars.length; ++n) {
                if (chars[n] == '#' && !inQuotes) {
                    n = chars.length;
                    continue;
                }
                if (inQuotes) {
                    if (chars[n] != '\"' || n < 1 || chars[n - 1] == '\\') continue;
                    inQuotes = false;
                    continue;
                }
                if (chars[n] == '(') {
                    ++brCount;
                    continue;
                }
                if (chars[n] == ')') {
                    --brCount;
                    continue;
                }
                if (chars[n] != '\"' || n < 1 || chars[n - 1] == '\\') continue;
                inQuotes = true;
            }
            if (inQuotes) {
                throw new RuntimeException("Mismatched quotes\n" + new String(chars));
            }
            if (brCount != 0) {
                throw new RuntimeException("Mismatched brackets\n" + new String(chars));
            }
        }
    }
}

