/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.zettaindustries.mods.battery;

import cofh.api.energy.IEnergyStorage;
import net.minecraft.nbt.NBTTagCompound;

public class AdvancedStorage
implements IEnergyStorage {
    protected long energy;
    protected long capacity;
    protected int maxReceive;
    protected int maxExtract;

    public AdvancedStorage(long capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer);
    }

    public AdvancedStorage(long capacity, int maxReceive, int maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public void merge(AdvancedStorage other) {
        if (other.energy > this.energy) {
            this.energy = other.energy;
            this.capacity = other.capacity;
        }
    }

    public AdvancedStorage readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74763_f("Energy");
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74772_a("Energy", this.energy);
        return nbt;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
    }

    public void setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public void setEnergyStored(long energy) {
        this.energy = energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0L) {
            this.energy = 0L;
        }
    }

    public void modifyEnergyStored(int energy) {
        this.energy += (long)energy;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        } else if (this.energy < 0L) {
            this.energy = 0L;
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = (int)Math.min(this.capacity - this.energy, (long)Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += (long)energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = (int)Math.min(this.energy, (long)Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= (long)energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.energy <= Integer.MAX_VALUE ? (int)this.energy : Integer.MAX_VALUE;
    }

    public int getMaxEnergyStored() {
        return this.capacity <= Integer.MAX_VALUE ? (int)this.capacity : Integer.MAX_VALUE;
    }

    public long getRealEnergyStored() {
        return this.energy;
    }

    public long getRealMaxEnergyStored() {
        return this.capacity;
    }
}

