/*
 * Decompiled with CFR 0.152.
 */
package openmodularturrets.util;

import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.UsernameCache;
import openmodularturrets.handler.ConfigHandler;
import openmodularturrets.tileentity.turretbase.TrustedPlayer;
import openmodularturrets.tileentity.turretbase.TurretBase;

public class PlayerUtil {
    public static UUID getPlayerUUID(String username) {
        for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
            if (!((String)entry.getValue()).equalsIgnoreCase(username)) continue;
            return (UUID)entry.getKey();
        }
        return null;
    }

    public static UUID getPlayerUIDUnstable(String possibleUUID) {
        UUID uuid;
        if (possibleUUID == null || possibleUUID.isEmpty()) {
            return null;
        }
        try {
            uuid = UUID.fromString(possibleUUID);
        }
        catch (IllegalArgumentException e) {
            uuid = PlayerUtil.getPlayerUUID(possibleUUID);
        }
        return uuid;
    }

    public static String getPlayerNameFromUUID(String possibleUUID) {
        if (possibleUUID == null || possibleUUID.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
            if (!((UUID)entry.getKey()).toString().equals(possibleUUID)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    public static TrustedPlayer getTrustedPlayer(EntityPlayer player, TurretBase base) {
        if (base.getTrustedPlayer(player.func_110124_au()) != null || ConfigHandler.offlineModeSupport && base.getTrustedPlayer(player.getDisplayName()) != null) {
            return base.getTrustedPlayer(player.func_110124_au()) == null ? base.getTrustedPlayer(player.getDisplayName()) : base.getTrustedPlayer(player.func_110124_au());
        }
        return null;
    }

    public static void setBaseOwner(EntityPlayer player, TurretBase base) {
        if (!ConfigHandler.offlineModeSupport) {
            base.setOwner(player.func_110124_au().toString());
        }
    }

    public static boolean isPlayerOwner(EntityPlayer player, TurretBase base) {
        return base.getOwner().equals(player.func_110124_au().toString()) || ConfigHandler.offlineModeSupport && base.getOwnerName().equals(player.getDisplayName());
    }

    public static boolean isPlayerNameValid(String name) {
        for (Map.Entry entry : UsernameCache.getMap().entrySet()) {
            if (!((String)entry.getValue()).equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

