/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModRegistry;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Interfaces.Registry.Dependency;
import net.minecraftforge.fluids.FluidRegistry;

public enum PowerTypes implements Dependency
{
    RF("cofh.api.energy.IEnergyHandler", "cofh.api.energy.IEnergyContainerItem"),
    EU("ic2.api.energy.tile.IEnergyTile", "ic2.api.item.IElectricItem"),
    ROTARYCRAFT("Reika.RotaryCraft.API.Power.ShaftMachine"),
    PNEUMATIC("pneumaticCraft.api.tileentity.IPneumaticMachine"),
    HYDRAULIC(new String[0]),
    STEAM(FluidRegistry.getFluid((String)"steam") != null);

    private final boolean exists;

    private PowerTypes(boolean f) {
        this.exists = f;
        DragonAPICore.log("Power type " + this + " loaded: " + f);
    }

    private PowerTypes(String ... cl) {
        this(cl != null && cl.length > 0 && PowerTypes.checkAllClasses(cl));
    }

    private static boolean checkAllClasses(String ... cl) {
        for (int i = 0; i < cl.length; ++i) {
            String s = cl[i];
            try {
                Class<?> c = Class.forName(s);
                continue;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isLoaded() {
        return this.exists;
    }

    @Override
    public String getDisplayName() {
        return this.name();
    }
}

