/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.CropHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class HarvestCraftHandler
extends CropHandlerBase {
    private static final Random rand = new Random();
    private static final int RIPE = 7;
    private static final HarvestCraftHandler instance = new HarvestCraftHandler();
    private final Class cropClass;

    private HarvestCraftHandler() {
        Class<?> c = null;
        if (this.hasMod()) {
            try {
                c = Class.forName("com.pam.harvestcraft.BlockPamCrop");
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.cropClass = c;
    }

    @Override
    public boolean isCrop(Block id, int meta) {
        return id.getClass() == this.cropClass;
    }

    @Override
    public boolean isSeedItem(ItemStack is) {
        return false;
    }

    @Override
    public boolean isRipeCrop(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.isCrop(world.func_147439_a(x, y, z), meta) && meta >= 7;
    }

    public static HarvestCraftHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.cropClass != null;
    }

    @Override
    public ModList getMod() {
        return ModList.HARVESTCRAFT;
    }

    @Override
    public int getHarvestedMeta(World world, int x, int y, int z) {
        return 0;
    }

    @Override
    public ArrayList<ItemStack> getAdditionalDrops(World world, int x, int y, int z, Block id, int meta, int fortune) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        return li;
    }

    @Override
    public void editTileDataForHarvest(World world, int x, int y, int z) {
    }

    @Override
    public void makeRipe(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, 7, 3);
        world.func_147479_m(x, y, z);
        world.func_147471_g(x, y, z);
    }

    @Override
    public ArrayList<ItemStack> getDropsOverride(World world, int x, int y, int z, Block id, int meta, int fortune) {
        return null;
    }

    @Override
    public int getGrowthState(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public boolean neverDropsSecondSeed() {
        return false;
    }
}

