/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.CropHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FluxedCrystalHandler
extends CropHandlerBase {
    public final Item seed;
    public final Item universalSeed;
    public final Item roughShard;
    public final Item smoothShard;
    public final Block crop;
    private final int configChance;
    private Method doDrop;
    private static final FluxedCrystalHandler instance = new FluxedCrystalHandler();

    private FluxedCrystalHandler() {
        Block idcrop = null;
        Item univ = null;
        Item seed = null;
        Item rough = null;
        Item smooth = null;
        int chance = -1;
        if (this.hasMod()) {
            try {
                Class c = this.getMod().getBlockClass();
                Field f = c.getField("crystal");
                idcrop = (Block)f.get(null);
                Class c2 = this.getMod().getItemClass();
                f = c2.getField("universalSeed");
                univ = (Item)f.get(null);
                f = c2.getField("seed");
                seed = (Item)f.get(null);
                f = c2.getField("shardRough");
                rough = (Item)f.get(null);
                f = c2.getField("shardSmooth");
                smooth = (Item)f.get(null);
                this.doDrop = idcrop.getClass().getMethod("dropCropDrops", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.noMod();
        }
        this.crop = idcrop;
        this.seed = seed;
        this.universalSeed = univ;
        this.roughShard = rough;
        this.smoothShard = smooth;
        this.configChance = chance >= 0 ? chance : 0;
    }

    @Override
    public boolean isCrop(Block id, int meta) {
        return id == this.crop;
    }

    @Override
    public boolean isSeedItem(ItemStack is) {
        return is.func_77973_b() == this.seed;
    }

    @Override
    public boolean isRipeCrop(World world, int x, int y, int z) {
        int meta;
        Block b = world.func_147439_a(x, y, z);
        return this.isCrop(b, meta = world.func_72805_g(x, y, z)) && meta == 7;
    }

    @Override
    public void makeRipe(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, 7, 3);
    }

    public static FluxedCrystalHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.seed != null && this.crop != null && this.universalSeed != null && this.roughShard != null && this.smoothShard != null;
    }

    @Override
    public ModList getMod() {
        return ModList.FLUXEDCRYSTALS;
    }

    @Override
    public int getHarvestedMeta(World world, int x, int y, int z) {
        return 0;
    }

    @Override
    public ArrayList<ItemStack> getAdditionalDrops(World world, int x, int y, int z, Block id, int meta, int fortune) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        return li;
    }

    @Override
    public ArrayList<ItemStack> getDropsOverride(World world, int x, int y, int z, Block id, int meta, int fortune) {
        this.triggerDropCode(world, x, y, z, id, meta, fortune);
        return new ArrayList<ItemStack>();
    }

    private void triggerDropCode(World world, int x, int y, int z, Block id, int meta, int fortune) {
        boolean secondSeed = this.rand.nextInt(100) <= this.configChance;
        try {
            this.doDrop.invoke((Object)id, world, x, y, z, fortune, secondSeed);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public int getGrowthState(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public boolean neverDropsSecondSeed() {
        return this.configChance == 0;
    }
}

