/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Bees;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.NestedMap;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleLeafEffect;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IChromosomeType;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraftforge.common.util.EnumHelper;

public class TreeAlleleRegistry {
    private static final NestedMap<Class, String, TreeGene> geneMap = new NestedMap();
    private static final EnumMap<EnumTreeChromosome, Class<? extends TreeGene>> classTypes = new EnumMap(EnumTreeChromosome.class);

    public static Class<? extends TreeGene> getEnumType(EnumTreeChromosome ebc) {
        return classTypes.get(ebc);
    }

    public static TreeGene getEnum(EnumTreeChromosome ebc, String name) {
        return Enum.valueOf(TreeAlleleRegistry.getEnumType(ebc), name.toUpperCase(Locale.ENGLISH));
    }

    private static void register(TreeGene g, String n) {
        geneMap.put(g.getClass(), n, g);
    }

    public static TreeGene getEnum(IAllele allele, Class<? extends TreeGene> type) {
        return geneMap.get(type, allele.getUID());
    }

    static {
        classTypes.put(EnumTreeChromosome.HEIGHT, Heights.class);
        classTypes.put(EnumTreeChromosome.FERTILITY, Fertility.class);
        classTypes.put(EnumTreeChromosome.SAPPINESS, Sappiness.class);
        classTypes.put(EnumTreeChromosome.YIELD, Yield.class);
        classTypes.put(EnumTreeChromosome.FRUITS, Fruit.class);
        classTypes.put(EnumTreeChromosome.GIRTH, Girth.class);
        classTypes.put(EnumTreeChromosome.MATURATION, Maturation.class);
        classTypes.put(EnumTreeChromosome.TERRITORY, Territory.class);
        classTypes.put(EnumTreeChromosome.GROWTH, Growth.class);
        classTypes.put(EnumTreeChromosome.EFFECT, Effect.class);
    }

    public static enum Effect implements TreeGene
    {
        NONE("effectNone");

        public final String tag;

        private Effect(String s) {
            this("forestry", s);
        }

        private Effect(String pre, String s) {
            this.tag = pre + "." + s;
            TreeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleLeafEffect getAllele() {
            return (IAlleleLeafEffect)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        @Override
        public TreeGene oneBetter() {
            return null;
        }
    }

    public static enum Growth implements TreeGene
    {
        LIGHTLEVEL("lightlevel"),
        ACACIA("acacia"),
        TROPICAL("tropical");

        public final String tag;

        private Growth(String s) {
            this("forestry", s);
        }

        private Growth(String pre, String s) {
            this.tag = pre + "." + s;
            TreeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleGrowth getAllele() {
            return (IAlleleGrowth)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        @Override
        public TreeGene oneBetter() {
            return null;
        }
    }

    public static enum Territory implements TreeGene
    {
        DEFAULT("Default"),
        LARGE("Large"),
        LARGER("Larger"),
        LARGEST("Largest");

        public final String tag;

        private Territory(String s) {
            this("forestry", s);
        }

        private Territory(String pre, String s) {
            this.tag = pre + "." + "territory" + s;
            TreeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleArea getAllele() {
            return (IAlleleArea)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public Coordinate getRange() {
            int[] val = this.getAllele().getValue();
            return new Coordinate(val[0], val[1], val[2]);
        }

        public static Territory createNew(String id, int rangeXZ, int rangeY, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleArea allele = AlleleManager.alleleFactory.createArea("dragonapi", "territory", id, rangeXZ, rangeY, rangeXZ, dominant, new IChromosomeType[]{EnumTreeChromosome.TERRITORY});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumTreeChromosome.TERRITORY});
            return (Territory)EnumHelper.addEnum(Territory.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public TreeGene oneBetter() {
            return this == LARGEST ? null : Territory.values()[this.ordinal() + 1];
        }
    }

    public static enum Maturation implements TreeGene
    {
        SLOWEST("Slowest"),
        SLOWER("Slower"),
        SLOW("Slow"),
        AVERAGE("Average"),
        FAST("Fast"),
        FASTER("Faster"),
        FASTEST("Fastest"),
        MAXIMUM("Maximum");

        public final String tag;

        private Maturation(String s) {
            this("forestry", s);
        }

        private Maturation(String pre, String s) {
            this.tag = pre + "." + "flowering" + s;
            TreeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleInteger getAllele() {
            return (IAlleleInteger)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Maturation createNew(String id, int value, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleInteger allele = AlleleManager.alleleFactory.createInteger("dragonapi", "maturation", id, value, dominant, new IChromosomeType[]{EnumTreeChromosome.MATURATION});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumTreeChromosome.MATURATION});
            return (Maturation)EnumHelper.addEnum(Maturation.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public TreeGene oneBetter() {
            return this == MAXIMUM ? null : Maturation.values()[this.ordinal() + 1];
        }
    }

    public static enum Girth implements TreeGene
    {
        SLOWEST("Slowest"),
        SLOWER("Slower"),
        SLOW("Slow"),
        AVERAGE("Average"),
        FAST("Fast"),
        FASTER("Faster"),
        FASTEST("Fastest"),
        MAXIMUM("Maximum");

        public final String tag;

        private Girth(String s) {
            this("forestry", s);
        }

        private Girth(String pre, String s) {
            this.tag = pre + "." + "flowering" + s;
            TreeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleInteger getAllele() {
            return (IAlleleInteger)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Girth createNew(String id, int value, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleInteger allele = AlleleManager.alleleFactory.createInteger("dragonapi", "girth", id, value, dominant, new IChromosomeType[]{EnumTreeChromosome.GIRTH});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumTreeChromosome.GIRTH});
            return (Girth)EnumHelper.addEnum(Girth.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public TreeGene oneBetter() {
            return this == MAXIMUM ? null : Girth.values()[this.ordinal() + 1];
        }
    }

    public static enum Fruit implements TreeGene
    {

        public final String tag;

        private Fruit(String s) {
            this("forestry", s);
        }

        private Fruit(String pre, String s) {
            this.tag = pre + "." + "fruits" + s;
            TreeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleFruit getAllele() {
            return (IAlleleFruit)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        @Override
        public TreeGene oneBetter() {
            return null;
        }
    }

    public static enum Yield implements TreeGene
    {
        LOWEST("Lowest"),
        LOWER("Lower"),
        LOW("Low"),
        HIGH("High"),
        HIGHER("Higher"),
        HIGHEST("Highest");

        public final String tag;

        private Yield(String s) {
            this("forestry", s);
        }

        private Yield(String pre, String s) {
            this.tag = pre + "." + "yield" + s;
            TreeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleFloat getAllele() {
            return (IAlleleFloat)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Yield createNew(String id, int drones, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleFloat allele = AlleleManager.alleleFactory.createFloat("dragonapi", "yield", id, (float)drones, dominant, new IChromosomeType[]{EnumTreeChromosome.YIELD});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumTreeChromosome.YIELD});
            return (Yield)EnumHelper.addEnum(Yield.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public TreeGene oneBetter() {
            return this == HIGHEST ? null : Yield.values()[this.ordinal() + 1];
        }
    }

    public static enum Sappiness implements TreeGene
    {
        LOWEST("Lowest"),
        LOWER("Lower"),
        LOW("Low"),
        HIGH("High"),
        HIGHER("Higher"),
        HIGHEST("Highest");

        public final String tag;

        private Sappiness(String s) {
            this("forestry", s);
        }

        private Sappiness(String pre, String s) {
            this.tag = pre + "." + "sappiness" + s;
            TreeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleFloat getAllele() {
            return (IAlleleFloat)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Sappiness createNew(String id, int drones, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleFloat allele = AlleleManager.alleleFactory.createFloat("dragonapi", "sappiness", id, (float)drones, dominant, new IChromosomeType[]{EnumTreeChromosome.SAPPINESS});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumTreeChromosome.SAPPINESS});
            return (Sappiness)EnumHelper.addEnum(Sappiness.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public TreeGene oneBetter() {
            return this == HIGHEST ? null : Sappiness.values()[this.ordinal() + 1];
        }
    }

    public static enum Fertility implements TreeGene
    {
        LOWEST("Lowest"),
        LOWER("Lower"),
        LOW("Low"),
        HIGH("High"),
        HIGHER("Higher"),
        HIGHEST("Highest");

        public final String tag;

        private Fertility(String s) {
            this("forestry", s);
        }

        private Fertility(String pre, String s) {
            this.tag = pre + "." + "fertility" + s;
            TreeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleFloat getAllele() {
            return (IAlleleFloat)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Fertility createNew(String id, float speed, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleFloat allele = AlleleManager.alleleFactory.createFloat("dragonapi", "fertility", id, speed, dominant, new IChromosomeType[]{EnumTreeChromosome.FERTILITY});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumTreeChromosome.FERTILITY});
            return (Fertility)EnumHelper.addEnum(Fertility.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public TreeGene oneBetter() {
            return this == HIGHEST ? null : Fertility.values()[this.ordinal() + 1];
        }
    }

    public static enum Heights implements TreeGene
    {
        SMALLEST("Smallest"),
        SMALLER("Smaller"),
        SMALL("Small"),
        AVERAGE("Average"),
        LARGE("Large"),
        LARGER("Larger"),
        LARGEST("Largest");

        public final String tag;

        private Heights(String s) {
            this("forestry", s);
        }

        private Heights(String pre, String s) {
            this.tag = pre + "." + "height" + s;
            TreeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleFloat getAllele() {
            return (IAlleleFloat)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Heights createNew(String id, float speed, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleFloat allele = AlleleManager.alleleFactory.createFloat("dragonapi", "height", id, speed, dominant, new IChromosomeType[]{EnumTreeChromosome.HEIGHT});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumTreeChromosome.HEIGHT});
            return (Heights)EnumHelper.addEnum(Heights.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public TreeGene oneBetter() {
            return this == LARGEST ? null : Heights.values()[this.ordinal() + 1];
        }
    }

    public static interface TreeGene {
        public TreeGene oneBetter();

        public IAllele getAllele();
    }
}

