/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Bees;

import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.NestedMap;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosomeType;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraftforge.common.util.EnumHelper;

public class BeeAlleleRegistry {
    private static final NestedMap<Class, String, BeeGene> geneMap = new NestedMap();
    private static final EnumMap<EnumBeeChromosome, Class<? extends BeeGene>> classTypes = new EnumMap(EnumBeeChromosome.class);

    public static Class<? extends BeeGene> getEnumType(EnumBeeChromosome ebc) {
        return classTypes.get(ebc);
    }

    public static BeeGene getEnum(EnumBeeChromosome ebc, String name) {
        return Enum.valueOf(BeeAlleleRegistry.getEnumType(ebc), name.toUpperCase(Locale.ENGLISH));
    }

    private static void register(BeeGene g, String n) {
        geneMap.put(g.getClass(), n, g);
    }

    public static BeeGene getEnum(IAllele allele, Class<? extends BeeGene> type) {
        return geneMap.get(type, allele.getUID());
    }

    static {
        classTypes.put(EnumBeeChromosome.SPEED, Speeds.class);
        classTypes.put(EnumBeeChromosome.LIFESPAN, Life.class);
        classTypes.put(EnumBeeChromosome.FERTILITY, Fertility.class);
        classTypes.put(EnumBeeChromosome.FLOWERING, Flowering.class);
        classTypes.put(EnumBeeChromosome.FLOWER_PROVIDER, Flower.class);
        classTypes.put(EnumBeeChromosome.TERRITORY, Territory.class);
        classTypes.put(EnumBeeChromosome.EFFECT, Effect.class);
    }

    public static enum Effect implements BeeGene
    {
        NONE("effectNone"),
        AGRESSION("effectAggressive"),
        HEROIC("effectHeroic"),
        REGEN("effectBeatific"),
        MIASMIC("effectMiasmic"),
        MISANTHROPE("effectMisanthrope"),
        ICY("effectGlacial"),
        RADIATION("effectRadioactive"),
        CREEPER("effectCreeper"),
        FIRE("effectIgnition"),
        EXPLORE("effectExploration"),
        EASTER("effectFestiveEaster"),
        SNOW("effectSnowing"),
        NAUSEA("effectDrunkard"),
        REANIMATE("effectReanimation"),
        RESURRECT("effectResurrection"),
        REPULSION("effectRepulsion");

        public final String tag;

        private Effect(String s) {
            this("forestry", s);
        }

        private Effect(String pre, String s) {
            this.tag = pre + "." + s;
            BeeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleBeeEffect getAllele() {
            return (IAlleleBeeEffect)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        @Override
        public BeeGene oneBetter() {
            return null;
        }
    }

    public static enum Tolerance implements BeeGene
    {
        UP("Up"),
        DOWN("Down"),
        BOTH("Both"),
        NONE("None");

        public final String tag;

        private Tolerance(String s) {
            this("forestry", s);
        }

        private Tolerance(String pre, String s) {
            this.tag = pre + "." + "tolerance" + s;
            BeeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleTolerance getAllele() {
            return (IAlleleTolerance)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        @Override
        public BeeGene oneBetter() {
            return null;
        }
    }

    public static enum Life implements BeeGene
    {
        SHORTEST("Shortest"),
        SHORTER("Shorter"),
        SHORT("Short"),
        SHORTENED("Shortened"),
        NORMAL("Normal"),
        ELONGATED("Elongated"),
        LONG("Long"),
        LONGER("Longer"),
        LONGEST("Longest");

        public final String tag;

        private Life(String s) {
            this("forestry", s);
        }

        private Life(String pre, String s) {
            this.tag = pre + "." + "lifespan" + s;
            BeeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleInteger getAllele() {
            return (IAlleleInteger)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Life createNew(String id, int life, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleInteger allele = AlleleManager.alleleFactory.createInteger("dragonapi", "lifespan", id, life, dominant, new IChromosomeType[]{EnumBeeChromosome.LIFESPAN});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumBeeChromosome.LIFESPAN});
            return (Life)EnumHelper.addEnum(Life.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public BeeGene oneBetter() {
            return null;
        }
    }

    public static enum Territory implements BeeGene
    {
        DEFAULT("Default"),
        LARGE("Large"),
        LARGER("Larger"),
        LARGEST("Largest");

        public final String tag;

        private Territory(String s) {
            this("forestry", s);
        }

        private Territory(String pre, String s) {
            this.tag = pre + "." + "territory" + s;
            BeeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleArea getAllele() {
            return (IAlleleArea)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public Coordinate getRange() {
            int[] val = this.getAllele().getValue();
            return new Coordinate(val[0], val[1], val[2]);
        }

        public static Territory createNew(String id, int rangeXZ, int rangeY, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleArea allele = AlleleManager.alleleFactory.createArea("dragonapi", "territory", id, rangeXZ, rangeY, rangeXZ, dominant, new IChromosomeType[]{EnumBeeChromosome.TERRITORY});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumBeeChromosome.TERRITORY});
            return (Territory)EnumHelper.addEnum(Territory.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public BeeGene oneBetter() {
            return this == LARGEST ? null : Territory.values()[this.ordinal() + 1];
        }
    }

    public static enum Flowering implements BeeGene
    {
        SLOWEST("Slowest"),
        SLOWER("Slower"),
        SLOW("Slow"),
        AVERAGE("Average"),
        FAST("Fast"),
        FASTER("Faster"),
        FASTEST("Fastest"),
        MAXIMUM("Maximum");

        public final String tag;

        private Flowering(String s) {
            this("forestry", s);
        }

        private Flowering(String pre, String s) {
            this.tag = pre + "." + "flowering" + s;
            BeeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleInteger getAllele() {
            return (IAlleleInteger)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Flowering createNew(String id, int value, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleInteger allele = AlleleManager.alleleFactory.createInteger("dragonapi", "flowering", id, value, dominant, new IChromosomeType[]{EnumBeeChromosome.FLOWERING});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumBeeChromosome.FLOWERING});
            return (Flowering)EnumHelper.addEnum(Flowering.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public BeeGene oneBetter() {
            return this == MAXIMUM ? null : Flowering.values()[this.ordinal() + 1];
        }
    }

    public static enum Flower implements BeeGene
    {
        VANILLA("Vanilla"),
        NETHER("Nether"),
        CACTUS("Cacti"),
        MUSHROOM("Mushrooms"),
        ENDER("End"),
        JUNGLE("Jungle"),
        SNOW("Snow"),
        WHEAT("Wheat"),
        GOURD("Gourd");

        public final String tag;

        private Flower(String s) {
            this("forestry", s);
        }

        private Flower(String pre, String s) {
            this.tag = pre + "." + "flowers" + s;
            BeeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleFlowers getAllele() {
            return (IAlleleFlowers)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        @Override
        public BeeGene oneBetter() {
            return null;
        }
    }

    public static enum Fertility implements BeeGene
    {
        LOW("Low"),
        NORMAL("Normal"),
        HIGH("High"),
        MAXIMUM("Maximum");

        public final String tag;

        private Fertility(String s) {
            this("forestry", s);
        }

        private Fertility(String pre, String s) {
            this.tag = pre + "." + "fertility" + s;
            BeeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleInteger getAllele() {
            return (IAlleleInteger)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Fertility createNew(String id, int drones, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleInteger allele = AlleleManager.alleleFactory.createInteger("dragonapi", "fertility", id, drones, dominant, new IChromosomeType[]{EnumBeeChromosome.FERTILITY});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumBeeChromosome.FERTILITY});
            return (Fertility)EnumHelper.addEnum(Fertility.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public BeeGene oneBetter() {
            return this == MAXIMUM ? null : Fertility.values()[this.ordinal() + 1];
        }
    }

    public static enum Speeds implements BeeGene
    {
        SLOWEST("Slowest"),
        SLOWER("Slower"),
        SLOW("Slow"),
        NORMAL("Norm"),
        FAST("Fast"),
        FASTER("Faster"),
        FASTEST("Fastest");

        public final String tag;

        private Speeds(String s) {
            this("forestry", s);
        }

        private Speeds(String pre, String s) {
            this.tag = pre + "." + "speed" + s;
            BeeAlleleRegistry.register(this, this.tag);
        }

        public IAlleleFloat getAllele() {
            return (IAlleleFloat)AlleleManager.alleleRegistry.getAllele(this.tag);
        }

        public static Speeds createNew(String id, float speed, boolean dominant) {
            id = ReikaStringParser.capFirstChar(id);
            IAlleleFloat allele = AlleleManager.alleleFactory.createFloat("dragonapi", "speed", id, speed, dominant, new IChromosomeType[]{EnumBeeChromosome.SPEED});
            AlleleManager.alleleRegistry.registerAllele((IAllele)allele, new IChromosomeType[]{EnumBeeChromosome.SPEED});
            return (Speeds)EnumHelper.addEnum(Speeds.class, (String)id.toUpperCase(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{"dragonapi", id});
        }

        @Override
        public BeeGene oneBetter() {
            return this == FASTEST ? null : Speeds.values()[this.ordinal() + 1];
        }
    }

    public static interface BeeGene {
        public BeeGene oneBetter();

        public IAllele getAllele();
    }
}

