/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Event.GetPlayerLookEvent;
import Reika.DragonAPI.Instantiable.Event.PlayerHasItemEvent;
import Reika.DragonAPI.Instantiable.Event.RemovePlayerItemEvent;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.ServersideAttributeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S20PacketEntityProperties;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;

public final class ReikaPlayerAPI
extends DragonAPICore {
    private static final HashMap<String, FakePlayer> fakePlayers = new HashMap();
    private static final HashMap<String, UUID> uuidMap = new HashMap();

    public static void transferInventoryToChest(EntityPlayer ep, ItemStack[] inv) {
        int num = ReikaInventoryHelper.getTotalUniqueStacks(ep.field_71071_by.field_70462_a);
        if (num >= inv.length) {
            return;
        }
    }

    public static void clearHotbar(EntityPlayer ep) {
        for (int i = 0; i < 9; ++i) {
            ep.field_71071_by.field_70462_a[i] = null;
        }
    }

    public static void clearInventory(EntityPlayer ep) {
        for (int i = 0; i < ep.field_71071_by.field_70462_a.length; ++i) {
            ep.field_71071_by.field_70462_a[i] = null;
        }
    }

    public static void cleanInventory(EntityPlayer ep, boolean hotbar) {
    }

    public static MovingObjectPosition getLookedAtBlock(EntityPlayer ep, double reach, boolean liq) {
        Vec3 vec = Vec3.func_72443_a((double)ep.field_70165_t, (double)(ep.field_70163_u + 1.62 - (double)ep.field_70129_M), (double)ep.field_70161_v);
        Vec3 vec2 = ep.func_70676_i(1.0f);
        Vec3 vec3 = vec.func_72441_c(vec2.field_72450_a * reach, vec2.field_72448_b * reach, vec2.field_72449_c * reach);
        MovingObjectPosition hit = ep.field_70170_p.func_72901_a(vec, vec3, liq);
        GetPlayerLookEvent evt = new GetPlayerLookEvent(ep, hit, vec, vec3);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        hit = evt.newLook;
        if (hit != null && hit.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return hit;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static MovingObjectPosition getLookedAtBlockClient(double reach, boolean liq) {
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        return ReikaPlayerAPI.getLookedAtBlock((EntityPlayer)ep, reach, liq);
    }

    public static FakePlayer getFakePlayerByNameAndUUID(WorldServer world, String name, UUID uuid) {
        FakePlayer fp = fakePlayers.get(name);
        if (fp == null) {
            fp = FakePlayerFactory.get((WorldServer)world, (GameProfile)new GameProfile(uuid, name));
            fakePlayers.put(name, fp);
        }
        return fp;
    }

    private static boolean isAdmin(WorldServer world, String name, UUID uuid) {
        FakePlayer fp = ReikaPlayerAPI.getFakePlayerByNameAndUUID(world, name, uuid);
        return ReikaPlayerAPI.isAdmin((EntityPlayerMP)fp);
    }

    public static boolean isAdmin(EntityPlayerMP ep) {
        return MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(ep.func_146103_bH());
    }

    public static void setPlayerWalkSpeed(EntityPlayer ep, float speed) {
        PlayerCapabilities pc = ep.field_71075_bZ;
        NBTTagCompound nbt = new NBTTagCompound();
        pc.func_75091_a(nbt);
        nbt.func_74776_a("walkSpeed", speed);
        pc.func_75095_b(nbt);
    }

    public static boolean playerHasOrIsCreative(EntityPlayer ep, ItemStack is) {
        if (ep.field_71075_bZ.field_75098_d) {
            return true;
        }
        PlayerHasItemEvent evt = new PlayerHasItemEvent(ep, is);
        switch (evt.getResult()) {
            case DENY: {
                return false;
            }
            case ALLOW: {
                return true;
            }
        }
        ItemStack[] ii = ep.field_71071_by.field_70462_a;
        if (is.func_77973_b().func_77614_k() && is.func_77960_j() != Short.MAX_VALUE) {
            return ReikaInventoryHelper.checkForItemStack(is, ii, false);
        }
        return ReikaInventoryHelper.checkForItem(is.func_77973_b(), ii);
    }

    public static boolean playerHasOrIsCreative(EntityPlayer ep, Item id) {
        return ReikaPlayerAPI.playerHasOrIsCreative(ep, new ItemStack(id));
    }

    public static boolean playerHasOrIsCreative(EntityPlayer ep, Block id, int meta) {
        return ReikaPlayerAPI.playerHasOrIsCreative(ep, new ItemStack(id, 1, meta));
    }

    public static void setFoodLevel(EntityPlayer ep, int level) {
        NBTTagCompound NBT = new NBTTagCompound();
        ep.func_71024_bL().func_75117_b(NBT);
        NBT.func_74768_a("foodLevel", level);
        ep.func_71024_bL().func_75112_a(NBT);
    }

    public static void setSaturationLevel(EntityPlayer ep, int level) {
        NBTTagCompound NBT = new NBTTagCompound();
        ep.func_71024_bL().func_75117_b(NBT);
        NBT.func_74776_a("foodSaturationLevel", (float)level);
        ep.func_71024_bL().func_75112_a(NBT);
    }

    public static boolean playerCanBreakAt(WorldServer world, BlockArray b, EntityPlayerMP ep) {
        for (int i = 0; i < b.getSize(); ++i) {
            Coordinate c = b.getNthBlock(i);
            if (ReikaPlayerAPI.playerCanBreakAt(world, c.xCoord, c.yCoord, c.zCoord, ep)) continue;
            return false;
        }
        return true;
    }

    public static boolean playerCanBreakAt(WorldServer world, int x, int y, int z, EntityPlayerMP ep) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        return ReikaPlayerAPI.playerCanBreakAt(world, x, y, z, b, meta, ep);
    }

    public static boolean playerCanBreakAt(WorldServer world, int x, int y, int z, Block id, int meta, EntityPlayerMP ep) {
        if (ep == null) {
            DragonAPICore.logError("Cannot check permissions of a null player!");
            return false;
        }
        if (DragonAPICore.isSinglePlayer()) {
            return true;
        }
        if (ReikaPlayerAPI.isAdmin(ep) && DragonOptions.ADMINPERMBYPASS.getState()) {
            return true;
        }
        if (MinecraftServer.func_71276_C().func_96290_a((World)world, x, y, z, (EntityPlayer)ep)) {
            return false;
        }
        BlockEvent.BreakEvent evt = new BlockEvent.BreakEvent(x, y, z, (World)world, id, meta, (EntityPlayer)ep);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return !evt.isCanceled();
    }

    public static boolean playerCanBreakAt(WorldServer world, int x, int y, int z, Block id, int meta, String name, UUID uuid) {
        if (name == null) {
            DragonAPICore.logError("Cannot check permissions of a null player!");
            return false;
        }
        if (DragonAPICore.isSinglePlayer()) {
            return true;
        }
        if (ReikaPlayerAPI.isAdmin(world, name, uuid) && DragonOptions.ADMINPERMBYPASS.getState()) {
            return true;
        }
        FakePlayer fp = ReikaPlayerAPI.getFakePlayerByNameAndUUID(world, name, uuid);
        if (MinecraftServer.func_71276_C().func_96290_a((World)world, x, y, z, (EntityPlayer)fp)) {
            return false;
        }
        BlockEvent.BreakEvent evt = new BlockEvent.BreakEvent(x, y, z, (World)world, id, meta, (EntityPlayer)fp);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return !evt.isCanceled();
    }

    public static boolean playerCanBreakAt(WorldServer world, int x, int y, int z, String name, UUID uuid) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        return ReikaPlayerAPI.playerCanBreakAt(world, x, y, z, b, meta, name, uuid);
    }

    public static void removeExperience(EntityPlayer ep, int xp) {
        while (xp > 0 && ep.field_71067_cb > 0) {
            ep.func_71023_q(-1);
            if (ep.field_71106_cc < 0.0f) {
                ep.func_82242_a(-1);
                ep.field_71106_cc = 0.95f;
            }
            --xp;
        }
    }

    public static void clearExperience(EntityPlayer ep) {
        ep.field_71106_cc = 0.0f;
        ep.field_71068_ca = 0;
        ep.field_71067_cb = 0;
    }

    public static void syncCustomData(EntityPlayerMP ep) {
        ReikaPacketHelper.sendNBTPacket("DragonAPIData", APIPacketHandler.PacketIDs.PLAYERDATSYNC.ordinal(), ep.getEntityData(), new PacketTarget.PlayerTarget(ep));
    }

    public static void syncAttributes(EntityPlayerMP ep) {
        Set set = ((ServersideAttributeMap)ep.func_110140_aT()).func_111161_b();
        ep.field_71135_a.func_147359_a((Packet)new S20PacketEntityProperties(ep.func_145782_y(), (Collection)set));
    }

    @SideOnly(value=Side.CLIENT)
    public static void syncCustomDataFromClient(EntityPlayer ep) {
        ReikaPacketHelper.sendNBTPacket("DragonAPIData", APIPacketHandler.PacketIDs.PLAYERDATSYNC_CLIENT.ordinal(), ep.getEntityData(), PacketTarget.server);
    }

    public static NBTTagCompound getDeathPersistentNBT(EntityPlayer ep) {
        NBTTagCompound nbt = ep.getEntityData().func_74775_l("PlayerPersisted");
        ep.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)nbt);
        return nbt;
    }

    public static void notifyAdmins(String s) {
        MinecraftServer ms = MinecraftServer.func_71276_C();
        if (ms != null) {
            Collection<EntityPlayer> ops = ReikaPlayerAPI.getOps();
            for (EntityPlayer ep : ops) {
                ReikaChatHelper.sendChatToPlayer(ep, s);
            }
        }
    }

    public static Collection<EntityPlayer> getOps() {
        WorldServer[] w = MinecraftServer.func_71276_C().field_71305_c;
        ArrayList<EntityPlayer> ops = new ArrayList<EntityPlayer>();
        for (int i = 0; i < w.length; ++i) {
            WorldServer ws = w[i];
            ops.addAll(ReikaPlayerAPI.getOps((World)ws));
        }
        return ops;
    }

    public static Collection<EntityPlayer> getOps(World world) {
        ArrayList<EntityPlayer> ops = new ArrayList<EntityPlayer>();
        for (Object o : world.field_73010_i) {
            EntityPlayerMP ep = (EntityPlayerMP)o;
            if (!ReikaPlayerAPI.isAdmin(ep)) continue;
            ops.add((EntityPlayer)ep);
        }
        return ops;
    }

    public static EntityPlayerMP getPlayerByNameAnyWorld(String name) {
        for (WorldServer world : DimensionManager.getWorlds()) {
            EntityPlayerMP ep = (EntityPlayerMP)world.func_72924_a(name);
            if (ep == null) continue;
            return ep;
        }
        return null;
    }

    public static boolean isFakeOrNotInteractable(EntityPlayer ep, double x, double y, double z, double dist) {
        return ReikaPlayerAPI.isFake(ep) || ep.func_70092_e(x, y, z) >= dist * dist;
    }

    public static boolean isFake(EntityPlayer ep) {
        if (ep instanceof FakePlayer) {
            return true;
        }
        if (ep.func_70005_c_().contains("CoFH") || ep.func_70005_c_().contains("Thaumcraft")) {
            return true;
        }
        if (ep.getClass().getName().toLowerCase(Locale.ENGLISH).contains("fake")) {
            return true;
        }
        return ep instanceof EntityPlayerMP && ((EntityPlayerMP)ep).field_71135_a == null;
    }

    public static boolean isReika(EntityPlayer ep) {
        return ep.func_110124_au().equals(DragonAPICore.Reika_UUID);
    }

    public static List<EntityPlayerMP> getPlayersWithin(World world, AxisAlignedBB box) {
        ArrayList<EntityPlayerMP> li = new ArrayList<EntityPlayerMP>();
        for (Object o : world.field_73010_i) {
            if (!(o instanceof EntityPlayerMP) || !((EntityPlayerMP)o).field_70121_D.func_72326_a(box)) continue;
            EntityPlayerMP ep = (EntityPlayerMP)o;
            if (!ep.field_70121_D.func_72326_a(box)) continue;
            li.add(ep);
        }
        return li;
    }

    public static void kickPlayer(EntityPlayerMP ep, String reason) {
        ep.field_71135_a.func_147360_c(reason);
    }

    @SideOnly(value=Side.CLIENT)
    public static void kickPlayerClientside(EntityPlayer ep, String reason) {
        ReikaPacketHelper.sendStringPacket("DragonAPIData", APIPacketHandler.PacketIDs.PLAYERKICK.ordinal(), reason, PacketTarget.server);
    }

    public static void addOrDropItem(ItemStack is, EntityPlayer ep) {
        if (!ReikaInventoryHelper.addToIInv(is, (IInventory)ep.field_71071_by)) {
            ReikaItemHelper.dropItem((Entity)ep, is);
        }
    }

    public static void findAndDecrItem(EntityPlayer ep, Block b, int meta) {
        ReikaPlayerAPI.findAndDecrItem(ep, new ItemStack(b, 1, meta));
    }

    public static void findAndDecrItem(EntityPlayer ep, Item i, int meta) {
        ReikaPlayerAPI.findAndDecrItem(ep, new ItemStack(i, 1, meta));
    }

    public static void findAndDecrItem(EntityPlayer ep, ItemStack is) {
        if (MinecraftForge.EVENT_BUS.post((Event)new RemovePlayerItemEvent(ep, is))) {
            return;
        }
        int slot = ReikaInventoryHelper.locateInInventory(is, ep.field_71071_by.field_70462_a, false);
        if (slot != -1) {
            ReikaInventoryHelper.decrStack(slot, ep.field_71071_by.field_70462_a);
        }
    }
}

