/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Registry;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.ImmutableItemStack;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.DragonAPI.ModRegistry.ModOreList;
import cofh.api.energy.IEnergyContainerItem;
import com.builtbroken.mc.api.items.energy.IEnergyItem;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import mekanism.api.gas.IGasItem;
import net.machinemuse.api.electricity.MuseElectricItem;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public final class ReikaItemHelper
extends DragonAPICore {
    public static final ItemStack inksac = new ItemStack(Items.field_151100_aR, 1, 0);
    public static final ItemStack redDye = new ItemStack(Items.field_151100_aR, 1, 1);
    public static final ItemStack cactusDye = new ItemStack(Items.field_151100_aR, 1, 2);
    public static final ItemStack cocoaBeans = new ItemStack(Items.field_151100_aR, 1, 3);
    public static final ItemStack lapisDye = new ItemStack(Items.field_151100_aR, 1, 4);
    public static final ItemStack purpleDye = new ItemStack(Items.field_151100_aR, 1, 5);
    public static final ItemStack cyanDye = new ItemStack(Items.field_151100_aR, 1, 6);
    public static final ItemStack lgrayDye = new ItemStack(Items.field_151100_aR, 1, 7);
    public static final ItemStack grayDye = new ItemStack(Items.field_151100_aR, 1, 8);
    public static final ItemStack pinkDye = new ItemStack(Items.field_151100_aR, 1, 9);
    public static final ItemStack limeDye = new ItemStack(Items.field_151100_aR, 1, 10);
    public static final ItemStack yellowDye = new ItemStack(Items.field_151100_aR, 1, 11);
    public static final ItemStack lblueDye = new ItemStack(Items.field_151100_aR, 1, 12);
    public static final ItemStack magentaDye = new ItemStack(Items.field_151100_aR, 1, 13);
    public static final ItemStack orangeDye = new ItemStack(Items.field_151100_aR, 1, 14);
    public static final ItemStack bonemeal = new ItemStack(Items.field_151100_aR, 1, 15);
    public static final ItemStack blackWool = new ItemStack(Blocks.field_150325_L, 1, 15);
    public static final ItemStack redWool = new ItemStack(Blocks.field_150325_L, 1, 14);
    public static final ItemStack greenWool = new ItemStack(Blocks.field_150325_L, 1, 13);
    public static final ItemStack brownWool = new ItemStack(Blocks.field_150325_L, 1, 12);
    public static final ItemStack blueWool = new ItemStack(Blocks.field_150325_L, 1, 11);
    public static final ItemStack purpleWool = new ItemStack(Blocks.field_150325_L, 1, 10);
    public static final ItemStack cyanWool = new ItemStack(Blocks.field_150325_L, 1, 9);
    public static final ItemStack lgrayWool = new ItemStack(Blocks.field_150325_L, 1, 8);
    public static final ItemStack grayWool = new ItemStack(Blocks.field_150325_L, 1, 7);
    public static final ItemStack pinkWool = new ItemStack(Blocks.field_150325_L, 1, 6);
    public static final ItemStack limeWool = new ItemStack(Blocks.field_150325_L, 1, 5);
    public static final ItemStack yellowWool = new ItemStack(Blocks.field_150325_L, 1, 4);
    public static final ItemStack lblueWool = new ItemStack(Blocks.field_150325_L, 1, 3);
    public static final ItemStack magentaWool = new ItemStack(Blocks.field_150325_L, 1, 2);
    public static final ItemStack orangeWool = new ItemStack(Blocks.field_150325_L, 1, 1);
    public static final ItemStack whiteWool = new ItemStack(Blocks.field_150325_L, 1, 0);
    public static final ItemStack stoneBricks = new ItemStack(Blocks.field_150417_aV, 1, 0);
    public static final ItemStack mossyBricks = new ItemStack(Blocks.field_150417_aV, 1, 1);
    public static final ItemStack crackBricks = new ItemStack(Blocks.field_150417_aV, 1, 2);
    public static final ItemStack circleBricks = new ItemStack(Blocks.field_150417_aV, 1, 3);
    public static final ItemStack sandstone = new ItemStack(Blocks.field_150322_A, 1, 0);
    public static final ItemStack carvedSandstone = new ItemStack(Blocks.field_150322_A, 1, 1);
    public static final ItemStack smoothSandstone = new ItemStack(Blocks.field_150322_A, 1, 2);
    public static final ItemStack quartz = new ItemStack(Blocks.field_150371_ca, 1, 0);
    public static final ItemStack carvedQuartz = new ItemStack(Blocks.field_150371_ca, 1, 1);
    public static final ItemStack columnQuartz = new ItemStack(Blocks.field_150371_ca, 1, 2);
    public static final ItemStack oakWood = new ItemStack(Blocks.field_150344_f, 1, 0);
    public static final ItemStack spruceWood = new ItemStack(Blocks.field_150344_f, 1, 1);
    public static final ItemStack birchWood = new ItemStack(Blocks.field_150344_f, 1, 2);
    public static final ItemStack jungleWood = new ItemStack(Blocks.field_150344_f, 1, 3);
    public static final ItemStack acaciaWood = new ItemStack(Blocks.field_150344_f, 1, 4);
    public static final ItemStack darkOakWood = new ItemStack(Blocks.field_150344_f, 1, 5);
    public static final ItemStack stoneSlab = new ItemStack((Block)Blocks.field_150333_U, 1, 0);
    public static final ItemStack sandstoneSlab = new ItemStack((Block)Blocks.field_150333_U, 1, 1);
    public static final ItemStack cobbleSlab = new ItemStack((Block)Blocks.field_150333_U, 1, 3);
    public static final ItemStack brickSlab = new ItemStack((Block)Blocks.field_150333_U, 1, 4);
    public static final ItemStack stonebrickSlab = new ItemStack((Block)Blocks.field_150333_U, 1, 5);
    public static final ItemStack netherSlab = new ItemStack((Block)Blocks.field_150333_U, 1, 6);
    public static final ItemStack quartzSlab = new ItemStack((Block)Blocks.field_150333_U, 1, 7);
    public static final ItemStack stoneDoubleSlab = new ItemStack((Block)Blocks.field_150334_T, 1, 0);
    public static final ItemStack sandstoneDoubleSlab = new ItemStack((Block)Blocks.field_150334_T, 1, 1);
    public static final ItemStack cobbleDoubleSlab = new ItemStack((Block)Blocks.field_150334_T, 1, 3);
    public static final ItemStack brickDoubleSlab = new ItemStack((Block)Blocks.field_150334_T, 1, 4);
    public static final ItemStack stonebrickDoubleSlab = new ItemStack((Block)Blocks.field_150334_T, 1, 5);
    public static final ItemStack netherDoubleSlab = new ItemStack((Block)Blocks.field_150334_T, 1, 6);
    public static final ItemStack quartzDoubleSlab = new ItemStack((Block)Blocks.field_150334_T, 1, 7);
    public static final ItemStack oakSlab = new ItemStack((Block)Blocks.field_150376_bx, 1, 0);
    public static final ItemStack spruceSlab = new ItemStack((Block)Blocks.field_150376_bx, 1, 1);
    public static final ItemStack birchSlab = new ItemStack((Block)Blocks.field_150376_bx, 1, 2);
    public static final ItemStack jungleSlab = new ItemStack((Block)Blocks.field_150376_bx, 1, 3);
    public static final ItemStack oakDoubleSlab = new ItemStack((Block)Blocks.field_150373_bw, 1, 0);
    public static final ItemStack spruceDoubleSlab = new ItemStack((Block)Blocks.field_150373_bw, 1, 1);
    public static final ItemStack birchDoubleSlab = new ItemStack((Block)Blocks.field_150373_bw, 1, 2);
    public static final ItemStack jungleDoubleSlab = new ItemStack((Block)Blocks.field_150373_bw, 1, 3);
    public static final ItemStack tallgrass = new ItemStack((Block)Blocks.field_150329_H, 1, 1);
    public static final ItemStack fern = new ItemStack((Block)Blocks.field_150329_H, 1, 2);
    public static final ItemStack chiseledQuartz = new ItemStack(Blocks.field_150371_ca, 1, 1);
    public static final ItemStack quartzPillar = new ItemStack(Blocks.field_150371_ca, 1, 2);
    public static final ItemComparator comparator = new ItemComparator();
    private static final HashMap<Fluid, ItemStack> fluidContainerData = new HashMap();
    private static final HashMap<Item, Double> itemMass = new HashMap();
    private static Field oreListField;
    private static final HashMap<Item, ArrayList<ItemStack>> permutations;

    public static boolean matchStacks(ImmutableItemStack a, ImmutableItemStack b) {
        return ReikaItemHelper.matchStacks(a.getItemStack(), b.getItemStack());
    }

    public static boolean matchStacks(ItemStack a, ImmutableItemStack b) {
        return ReikaItemHelper.matchStacks(a, b.getItemStack());
    }

    public static boolean matchStacks(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() == null || b.func_77973_b() == null) {
            return false;
        }
        if (a.func_77973_b().func_77614_k() || b.func_77973_b().func_77614_k()) {
            return a.func_77973_b() == b.func_77973_b() && (a.func_77960_j() == b.func_77960_j() || a.func_77960_j() == Short.MAX_VALUE || b.func_77960_j() == Short.MAX_VALUE);
        }
        return a.func_77973_b() == b.func_77973_b();
    }

    public static boolean isFireworkIngredient(Item id) {
        if (id == Items.field_151045_i) {
            return true;
        }
        if (id == Items.field_151100_aR) {
            return true;
        }
        if (id == Items.field_151114_aO) {
            return true;
        }
        if (id == Items.field_151008_G) {
            return true;
        }
        if (id == Items.field_151074_bl) {
            return true;
        }
        if (id == Items.field_151059_bz) {
            return true;
        }
        if (id == Items.field_151045_i) {
            return true;
        }
        if (id == Items.field_151144_bL) {
            return true;
        }
        if (id == Items.field_151154_bQ) {
            return true;
        }
        if (id == Items.field_151121_aF) {
            return true;
        }
        return id == Items.field_151016_H;
    }

    public static ItemStack getSizedItemStack(ItemStack is, int num) {
        if (is == null) {
            return null;
        }
        if (is.func_77973_b() == null) {
            return null;
        }
        if (num <= 0) {
            return null;
        }
        ItemStack is2 = new ItemStack(is.func_77973_b(), num, is.func_77960_j());
        if (is.field_77990_d != null) {
            is2.field_77990_d = (NBTTagCompound)is.field_77990_d.func_74737_b();
        }
        return is2;
    }

    public static EntityItem dropItem(Entity e, ItemStack is) {
        return ReikaItemHelper.dropItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, is);
    }

    public static EntityItem dropItem(World world, double x, double y, double z, ItemStack is) {
        return ReikaItemHelper.dropItem(world, x, y, z, is, 1.0);
    }

    public static EntityItem dropItem(World world, double x, double y, double z, ItemStack is, double vscale) {
        if (is == null) {
            return null;
        }
        EntityItem ei = new EntityItem(world, x, y, z, is.func_77946_l());
        ei.field_145804_b = 10;
        ei.field_70159_w = (-0.1 + 0.2 * rand.nextDouble()) * vscale;
        ei.field_70179_y = (-0.1 + 0.2 * rand.nextDouble()) * vscale;
        ei.field_70181_x = 0.2 * rand.nextDouble() * vscale;
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)ei);
        }
        return ei;
    }

    public static void dropItems(World world, double x, double y, double z, Collection<ItemStack> li) {
        for (ItemStack is : li) {
            ReikaItemHelper.dropItem(world, x, y, z, is);
        }
    }

    public static boolean isBlock(ItemStack is) {
        Block b = Block.func_149634_a((Item)is.func_77973_b());
        return b != null && b != Blocks.field_150350_a;
    }

    public static boolean collectionContainsItemStack(Collection<ItemStack> li, ItemStack is) {
        return ReikaItemHelper.listContainsItemStack(li, is, false);
    }

    public static boolean listContainsItemStack(Collection<ItemStack> li, ItemStack is, boolean NBT) {
        for (ItemStack is2 : li) {
            if (!ReikaItemHelper.matchStacks(is, is2) || NBT && !ItemStack.func_77970_a((ItemStack)is, (ItemStack)is2)) continue;
            return true;
        }
        return false;
    }

    public static void dropInventory(EntityPlayer ep) {
        InventoryPlayer ii = ep.field_71071_by;
        Random par5Random = new Random();
        if (ii != null) {
            for (int i = 0; i < ii.func_70302_i_(); ++i) {
                ItemStack itemstack = ii.func_70301_a(i);
                if (itemstack == null) continue;
                float f = par5Random.nextFloat() * 0.8f + 0.1f;
                float f1 = par5Random.nextFloat() * 0.8f + 0.1f;
                float f2 = par5Random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j = par5Random.nextInt(21) + 10;
                    if (j > itemstack.field_77994_a) {
                        j = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j;
                    EntityItem ei = new EntityItem(ep.field_70170_p, ep.field_70165_t + (double)f, ep.field_70163_u + 0.25 + (double)f1, ep.field_70161_v + (double)f2, new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        ei.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    ei.field_70159_w = (float)par5Random.nextGaussian() * f3;
                    ei.field_70181_x = (float)par5Random.nextGaussian() * f3 + 0.2f;
                    ei.field_70179_y = (float)par5Random.nextGaussian() * f3;
                    ei.field_145804_b = 10;
                    ep.field_70170_p.func_72838_d((Entity)ei);
                }
            }
        }
    }

    public static void dropInventory(World world, int x, int y, int z) {
        IInventory ii = (IInventory)world.func_147438_o(x, y, z);
        Random par5Random = new Random();
        if (ii != null) {
            for (int i = 0; i < ii.func_70302_i_(); ++i) {
                ItemStack itemstack = ii.func_70301_a(i);
                if (itemstack == null) continue;
                float f = par5Random.nextFloat() * 0.8f + 0.1f;
                float f1 = par5Random.nextFloat() * 0.8f + 0.1f;
                float f2 = par5Random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j = par5Random.nextInt(21) + 10;
                    if (j > itemstack.field_77994_a) {
                        j = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j;
                    EntityItem ei = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        ei.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    ei.field_70159_w = (float)par5Random.nextGaussian() * f3;
                    ei.field_70181_x = (float)par5Random.nextGaussian() * f3 + 0.2f;
                    ei.field_70179_y = (float)par5Random.nextGaussian() * f3;
                    ei.field_145804_b = 10;
                    world.func_72838_d((Entity)ei);
                }
            }
        }
    }

    public static BlockKey getWorldBlockFromItem(ItemStack is) {
        if (is == null) {
            return new BlockKey(Blocks.field_150350_a);
        }
        if (!(is.func_77973_b() instanceof ItemBlock)) {
            return new BlockKey(Blocks.field_150350_a);
        }
        int meta = is.func_77973_b().func_77647_b(is.func_77960_j());
        if (ReikaItemHelper.matchStackWithBlock(is, (Block)Blocks.field_150331_J) || ReikaItemHelper.matchStackWithBlock(is, (Block)Blocks.field_150320_F)) {
            meta = 0;
        }
        return new BlockKey(Block.func_149634_a((Item)is.func_77973_b()), meta);
    }

    public static boolean oreItemExists(String tag) {
        ArrayList li = OreDictionary.getOres((String)tag);
        return li != null && !li.isEmpty();
    }

    public static boolean oreItemsExist(String ... tags) {
        for (int i = 0; i < tags.length; ++i) {
            if (ReikaItemHelper.oreItemExists(tags[i])) continue;
            return false;
        }
        return true;
    }

    public static void addToList(ArrayList<ItemStack> items, ArrayList<ItemStack> toAdd) {
        for (int i = 0; i < toAdd.size(); ++i) {
            ItemStack is = toAdd.get(i);
            ReikaItemHelper.addItemToList(items, is);
        }
    }

    public static void addItemToList(ArrayList<ItemStack> items, ItemStack is) {
        for (int i = 0; i < items.size() && is.field_77994_a > 0; ++i) {
            ItemStack in = items.get(i);
            if (!ReikaItemHelper.matchStacks(is, in) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)in)) continue;
            int sum = in.field_77994_a + is.field_77994_a;
            if (sum <= in.func_77976_d()) {
                in.field_77994_a = sum;
                return;
            }
            int diff = in.func_77976_d() - in.field_77994_a;
            in.field_77994_a = in.func_77976_d();
            is.field_77994_a -= diff;
        }
        if (is.field_77994_a > 0) {
            items.add(is);
        }
    }

    public static boolean matchStackWithBlock(ItemStack is, Block b) {
        return is.func_77973_b() == Item.func_150898_a((Block)b);
    }

    public static ItemStack stripNBT(ItemStack is) {
        ItemStack is2 = is.func_77946_l();
        is2.field_77990_d = null;
        return is2;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<ItemStack> getAllMetadataPermutations(Item item) {
        if (item == null) {
            throw new MisuseException("You cannot get the permutations of null!");
        }
        ArrayList<Object> li = permutations.get(item);
        if (li == null) {
            li = new ArrayList();
            CreativeTabs[] tabs = item.getCreativeTabs();
            for (int k = 0; k < tabs.length; ++k) {
                CreativeTabs tab = tabs[k];
                item.func_150895_a(item, tab, li);
            }
            permutations.put(item, li);
        }
        return Collections.unmodifiableList(li);
    }

    public static void sortItems(List<ItemStack> li) {
        Collections.sort(li, comparator);
    }

    public static boolean isItemAddedByMod(Item i, String modID) {
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)i);
        return id != null ? modID.equalsIgnoreCase(id.modId) : modID == null;
    }

    public static ItemStack getContainerForFluid(Fluid fluid) {
        if (fluidContainerData.containsKey(fluid)) {
            ItemStack ret = fluidContainerData.get(fluid);
            return ret != null ? ret.func_77946_l() : null;
        }
        ItemStack ret = ReikaItemHelper.calculateContainerForFluid(fluid);
        fluidContainerData.put(fluid, ret);
        return ret != null ? ret.func_77946_l() : null;
    }

    private static ItemStack calculateContainerForFluid(Fluid fluid) {
        ItemStack is = new ItemStack(Items.field_151133_ar);
        ItemStack fill = FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(fluid, Integer.MAX_VALUE), (ItemStack)is);
        if (fill != null) {
            return fill;
        }
        FluidContainerRegistry.FluidContainerData[] dat = FluidContainerRegistry.getRegisteredFluidContainerData();
        for (int i = 0; i < dat.length; ++i) {
            FluidContainerRegistry.FluidContainerData fcd = dat[i];
            if (fcd.fluid == null || fcd.fluid.getFluid() != fluid || fcd.filledContainer == null) continue;
            return fcd.filledContainer.func_77946_l();
        }
        return null;
    }

    public static boolean isVanillaBlock(Block b) {
        return ReikaItemHelper.isVanillaItem(Item.func_150898_a((Block)b));
    }

    public static boolean isVanillaItem(ItemStack is) {
        return ReikaItemHelper.isVanillaItem(is.func_77973_b());
    }

    public static boolean isVanillaItem(Item i) {
        return "minecraft".equals(ReikaItemHelper.getNamespace(i));
    }

    public static String getNamespace(Block b) {
        if (b == null) {
            return null;
        }
        String s = Block.field_149771_c.func_148750_c((Object)b);
        return s.substring(0, s.indexOf(58));
    }

    public static String getNamespace(Item i) {
        if (i == null) {
            return null;
        }
        String s = Item.field_150901_e.func_148750_c((Object)i);
        return s.substring(0, s.indexOf(58));
    }

    public static String getRegistrantMod(ItemStack is) {
        if (ReikaItemHelper.isVanillaItem(is)) {
            return "Minecraft";
        }
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)is.func_77973_b());
        return id != null ? id.modId : "[No Mod]";
    }

    public static boolean checkOreDictOverlap(ItemStack is1, ItemStack is2) {
        for (String s : ReikaItemHelper.getOreNames(is1)) {
            if (!ReikaItemHelper.isInOreTag(is2, s)) continue;
            return true;
        }
        return false;
    }

    public static EntityPlayer getDropper(EntityItem ei) {
        if (ei.getEntityData().func_74764_b("dropper")) {
            try {
                return ei.field_70170_p.func_152378_a(UUID.fromString(ei.getEntityData().func_74779_i("dropper")));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static HashSet<String> getOreNames(ItemStack in) {
        HashSet<String> set = new HashSet<String>();
        int[] ids = OreDictionary.getOreIDs((ItemStack)in);
        for (int i = 0; i < ids.length; ++i) {
            set.add(OreDictionary.getOreName((int)ids[i]));
        }
        return set;
    }

    public static String[] getOreNamesArray(ItemStack is) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)is);
        String[] ore = new String[ids.length];
        for (int i = 0; i < ore.length; ++i) {
            ore[i] = OreDictionary.getOreName((int)ids[i]);
        }
        return ore;
    }

    public static boolean isInOreTag(ItemStack is, String name) {
        return ReikaItemHelper.getOreNames(is).contains(name);
    }

    public static Collection<ItemStack> getAllOreItemsExcept(String tag, ItemStack excl) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (ItemStack is : OreDictionary.getOres((String)tag)) {
            if (ReikaItemHelper.matchStacks(is, excl)) continue;
            li.add(is);
        }
        return li;
    }

    public static boolean verifyItemStack(ItemStack is, boolean fullCheck) {
        if (is == null) {
            return true;
        }
        if (is.func_77973_b() == null) {
            return false;
        }
        try {
            is.toString();
            if (fullCheck) {
                is.func_82833_r();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void removeOreDictEntry(String tag, ItemStack is) throws Exception {
        ArrayList ores = OreDictionary.getOres((String)tag);
        ArrayList li = (ArrayList)oreListField.get(ores);
        li.remove(is);
        DragonAPICore.log("Removed item " + is + " from OreDict tag '" + tag + "'");
    }

    public static void registerItemMass(Item i, double density, int ingots) {
        ReikaItemHelper.registerItemMass(i, density / 9.0 * (double)ingots * 0.125);
    }

    public static void registerItemMass(Item i, double mass) {
        itemMass.put(i, mass);
    }

    public static void toggleDamageBit(ItemStack is, int bit) {
        is.func_77964_b(ReikaMathLibrary.toggleBit(is.func_77960_j(), bit));
    }

    public static ArrayList<ItemStack> collateItemList(Collection<ItemStack> c) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        HashMap<KeyedItemStack, Integer> vals = new HashMap<KeyedItemStack, Integer>();
        for (ItemStack itemStack : c) {
            KeyedItemStack ks = new KeyedItemStack(itemStack).setSimpleHash(true).setIgnoreNBT(false);
            Integer get = (Integer)vals.get(ks);
            int val = get != null ? get : 0;
            vals.put(ks, val + itemStack.field_77994_a);
        }
        for (KeyedItemStack keyedItemStack : vals.keySet()) {
            int amt;
            for (int val = ((Integer)vals.get(keyedItemStack)).intValue(); val > 0; val -= amt) {
                amt = Math.min(val, keyedItemStack.getItemStack().func_77976_d());
                ItemStack copy = ReikaItemHelper.getSizedItemStack(keyedItemStack.getItemStack(), amt);
                li.add(copy);
            }
        }
        return li;
    }

    public static ItemStack lookupItem(String s) {
        String[] parts = s.split(":");
        int m = 0;
        if (parts.length == 3) {
            try {
                m = parts[2].equalsIgnoreCase("*") ? Short.MAX_VALUE : Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ReikaItemHelper.lookupItem(parts[0], parts[1], m);
    }

    public static ItemStack lookupItem(ModList mod, String s, int meta) {
        return ReikaItemHelper.lookupItem(mod.modLabel, s, meta);
    }

    public static ItemStack lookupItem(String mod, String item, int meta) {
        Item i = GameRegistry.findItem((String)mod, (String)item);
        return i != null ? new ItemStack(i, 1, meta) : null;
    }

    public static ItemStack lookupBlock(ModList mod, String s, int meta) {
        return ReikaItemHelper.lookupBlock(mod.modLabel, s, meta);
    }

    public static ItemStack lookupBlock(String mod, String s, int meta) {
        Block b = Block.func_149684_b((String)(mod + ":" + s));
        return b != null ? new ItemStack(b, 1, meta) : null;
    }

    public static boolean isOreDrop(ItemStack is) {
        Enum ore = ReikaOreHelper.getByDrop(is);
        if (ore != null) {
            return true;
        }
        ore = ModOreList.getByDrop(is);
        return ore != null;
    }

    public static double getItemMass(ItemStack is) {
        if (is == null) {
            return 0.0;
        }
        Double get = itemMass.get(is);
        return get != null ? get : 0.0;
    }

    public static ItemStack dechargeItem(ItemStack is) {
        if (is != null) {
            Item i = is.func_77973_b();
            if (InterfaceCache.GASITEM.instanceOf(i)) {
                ((IGasItem)i).removeGas(is, Integer.MAX_VALUE);
            }
            if (InterfaceCache.ENERGYITEM.instanceOf(i)) {
                ((IEnergyItem)i).discharge(is, Double.POSITIVE_INFINITY, true);
            }
            if (InterfaceCache.RFENERGYITEM.instanceOf(i)) {
                ((IEnergyContainerItem)i).extractEnergy(is, Integer.MAX_VALUE, false);
            }
            if (InterfaceCache.IELECTRICITEM.instanceOf(i)) {
                is = new ItemStack(((IElectricItem)i).getEmptyItem(is));
            }
            if (InterfaceCache.MUSEELECTRICITEM.instanceOf(i)) {
                ((MuseElectricItem)i).extractEnergy(is, Integer.MAX_VALUE, false);
            }
        }
        return is;
    }

    public static ItemStack getAnyMetaStack(ItemStack is) {
        ItemStack ret = is.func_77946_l();
        ret.func_77964_b(Short.MAX_VALUE);
        return ret;
    }

    public static boolean areStacksCombinable(ItemStack is1, ItemStack is2, int limit) {
        if (is1 != null) {
            limit = Math.min(limit, is1.func_77976_d());
        }
        return is1 != null && is2 != null && ReikaItemHelper.matchStacks(is1, is2) && ItemStack.func_77970_a((ItemStack)is1, (ItemStack)is2) && is1.field_77994_a + is2.field_77994_a <= limit;
    }

    public static ItemStack parseItem(Object o) {
        if (o instanceof ItemStack) {
            return ((ItemStack)o).func_77946_l();
        }
        if (o instanceof Item) {
            return new ItemStack((Item)o);
        }
        if (o instanceof Block) {
            return new ItemStack((Block)o);
        }
        if (o instanceof String) {
            return ReikaItemHelper.lookupItem((String)o);
        }
        return null;
    }

    static {
        permutations = new HashMap();
        try {
            Class<?> c = Class.forName("net.minecraftforge.oredict.OreDictionary$UnmodifiableArrayList");
            oreListField = c.getDeclaredField("list");
            oreListField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        double ingotFactor = 0.0078125;
        double massIron = 866.6666666666666 * ingotFactor;
        double massGold = 2144.4444444444443 * ingotFactor;
        double massDiamond = 388.8888888888889 * ingotFactor;
        itemMass.put(Items.field_151042_j, massIron);
        itemMass.put(Items.field_151043_k, massGold);
        itemMass.put(Items.field_151045_i, massDiamond);
        itemMass.put((Item)Items.field_151028_Y, massIron * 5.0);
        itemMass.put((Item)Items.field_151030_Z, massIron * 8.0);
        itemMass.put((Item)Items.field_151165_aa, massIron * 7.0);
        itemMass.put((Item)Items.field_151167_ab, massIron * 4.0);
        itemMass.put((Item)Items.field_151169_ag, massGold * 5.0);
        itemMass.put((Item)Items.field_151171_ah, massGold * 8.0);
        itemMass.put((Item)Items.field_151149_ai, massGold * 7.0);
        itemMass.put((Item)Items.field_151151_aj, massGold * 4.0);
        itemMass.put((Item)Items.field_151161_ac, massDiamond * 5.0);
        itemMass.put((Item)Items.field_151163_ad, massDiamond * 8.0);
        itemMass.put((Item)Items.field_151173_ae, massDiamond * 7.0);
        itemMass.put((Item)Items.field_151175_af, massDiamond * 4.0);
    }

    private static class ItemComparator
    implements Comparator<ItemStack> {
        private ItemComparator() {
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            if (o1.func_77973_b() == o2.func_77973_b()) {
                if (o1.func_77960_j() == o2.func_77960_j()) {
                    if (o1.field_77994_a == o2.field_77994_a) {
                        if (o1.field_77990_d == o2.field_77990_d || o1.field_77990_d != null && o1.field_77990_d.equals((Object)o2.field_77990_d)) {
                            return 0;
                        }
                        if (o1.field_77990_d == null && o2.field_77990_d != null) {
                            return -1;
                        }
                        if (o2.field_77990_d == null && o1.field_77990_d != null) {
                            return 1;
                        }
                        return ReikaNBTHelper.compareNBTTags(o1.field_77990_d, o2.field_77990_d);
                    }
                    return o1.field_77994_a - o2.field_77994_a;
                }
                return o1.func_77960_j() - o2.func_77960_j();
            }
            return Item.func_150891_b((Item)o1.func_77973_b()) - Item.func_150891_b((Item)o2.func_77973_b());
        }
    }
}

