/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Registry;

import Reika.DragonAPI.Interfaces.Registry.CropType;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public enum ReikaCropHelper implements CropType
{
    WHEAT(Blocks.field_150464_aj, 7, Items.field_151014_N),
    CARROT(Blocks.field_150459_bM, 7, Items.field_151172_bF),
    POTATO(Blocks.field_150469_bN, 7, Items.field_151174_bG),
    NETHERWART(Blocks.field_150388_bm, 3, Items.field_151075_bm),
    COCOA(Blocks.field_150375_by, 2, ReikaItemHelper.cocoaBeans);

    public final Block blockID;
    public final int ripeMeta;
    private final ItemStack seedItem;
    public static final ReikaCropHelper[] cropList;
    private static final HashMap<Block, ReikaCropHelper> cropMappings;

    private ReikaCropHelper(Block id, int metaripe, Item seed) {
        this(id, metaripe, new ItemStack(seed));
    }

    private ReikaCropHelper(Block id, int metaripe, ItemStack seed) {
        this.blockID = id;
        this.ripeMeta = metaripe;
        this.seedItem = seed;
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int fortune) {
        int meta = world.func_72805_g(x, y, z);
        return this.blockID.getDrops(world, x, y, z, meta, fortune);
    }

    public static ReikaCropHelper getCrop(Block id) {
        return cropMappings.get(id);
    }

    public static boolean isCrop(Block id) {
        return ReikaCropHelper.getCrop(id) != null;
    }

    @Override
    public boolean destroyOnHarvest() {
        return false;
    }

    @Override
    public boolean isRipe(World world, int x, int y, int z) {
        return this.isRipe(world.func_72805_g(x, y, z));
    }

    public boolean isRipe(int meta) {
        if (this == COCOA) {
            meta /= 4;
        }
        return meta == this.ripeMeta;
    }

    public int getHarvestedMeta(int meta_ripe) {
        if (this == COCOA) {
            return meta_ripe & 3;
        }
        return 0;
    }

    @Override
    public boolean existsInGame() {
        return true;
    }

    @Override
    public void setHarvested(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, 0, 3);
    }

    @Override
    public void makeRipe(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, this.ripeMeta, 3);
    }

    @Override
    public boolean isSeedItem(ItemStack is) {
        return ReikaItemHelper.matchStacks(is, this.seedItem);
    }

    public ItemStack getSeedItem() {
        return this.seedItem.func_77946_l();
    }

    @Override
    public int getGrowthState(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public boolean isCrop(Block id, int meta) {
        return id == this.blockID;
    }

    @Override
    public boolean neverDropsSecondSeed() {
        return false;
    }

    static {
        cropList = ReikaCropHelper.values();
        cropMappings = new HashMap();
        for (int i = 0; i < cropList.length; ++i) {
            ReikaCropHelper w = cropList[i];
            Block id = w.blockID;
            cropMappings.put(id, w);
        }
    }
}

