/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaReflectionHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;

public final class GenerationInterceptWorld
extends World {
    private World delegate;
    private final HashSet<BlockKey> disallowedBlocks = new HashSet();
    private final MultiMap<BlockKey, BlockKey> disallowedChanges = new MultiMap(new MultiMap.HashSetFactory());
    private final HashSet<Coordinate> changeList = new HashSet();
    private final Collection<TileHook> hooks = new ArrayList<TileHook>();
    private final BlockMap<BlockKey> overrides = new BlockMap();

    public GenerationInterceptWorld() {
        super((ISaveHandler)new NoSaveHandler(), null, new WorldSettings(0L, WorldSettings.GameType.NOT_SET, false, false, WorldType.field_77137_b), null, null);
    }

    public void link(World world) {
        if (this.delegate == world) {
            return;
        }
        if (world == null) {
            try {
                this.delegate = null;
                boolean obf = !ReikaObfuscationHelper.isDeObfEnvironment();
                ReikaReflectionHelper.setFinalField(World.class, obf ? "field_73019_z" : "saveHandler", (Object)this, null);
                ReikaReflectionHelper.setFinalField(World.class, obf ? "field_73011_w" : "provider", (Object)this, null);
                this.field_72986_A = null;
                ReikaReflectionHelper.setFinalField(World.class, obf ? "field_72984_F" : "theProfiler", (Object)this, null);
                this.field_72988_C = null;
                this.field_73020_y = null;
                ReikaReflectionHelper.setFinalField(World.class, obf ? "perWorldStorage" : "perWorldStorage", (Object)this, null);
                this.field_72982_D = null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        this.delegate = world;
        try {
            boolean obf = !ReikaObfuscationHelper.isDeObfEnvironment();
            ReikaReflectionHelper.setFinalField(World.class, obf ? "field_73019_z" : "saveHandler", (Object)this, world.func_72860_G());
            ReikaReflectionHelper.setFinalField(World.class, obf ? "field_73011_w" : "provider", (Object)this, world.field_73011_w);
            this.field_72986_A = world.func_72912_H();
            ReikaReflectionHelper.setFinalField(World.class, obf ? "field_72984_F" : "theProfiler", (Object)this, world.field_72984_F);
            this.field_72988_C = world.field_72988_C;
            this.field_73020_y = world.func_72863_F();
            ReikaReflectionHelper.setFinalField(World.class, obf ? "perWorldStorage" : "perWorldStorage", (Object)this, world.perWorldStorage);
            this.field_72982_D = world.field_72982_D;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void disallowBlock(Block b) {
        this.disallowedBlocks.add(new BlockKey(b));
    }

    public void disallowBlock(Block b, int meta) {
        this.disallowedBlocks.add(new BlockKey(b, meta));
    }

    public void disallowBlock(BlockKey bk) {
        this.disallowedBlocks.add(bk);
    }

    public void disallowBlockChange(Block b, Block b2) {
        this.disallowBlockChange(new BlockKey(b), new BlockKey(b2));
    }

    public void disallowBlockChange(BlockKey b, BlockKey b2) {
        this.disallowedChanges.addValue(b, b2);
    }

    public void addHook(TileHook th) {
        this.hooks.add(th);
    }

    public void addGetOverride(Block b, int meta, Block overb) {
        this.addGetOverride(b, meta, overb, 0);
    }

    public void addGetOverride(Block b, int meta, Block overb, int overm) {
        this.addGetOverride(b, meta, new BlockKey(overb, overm));
    }

    public void addGetOverride(Block b, int meta, BlockKey override) {
        this.overrides.put(b, meta, override);
    }

    private boolean check(int x, int y, int z, Block b, int meta) {
        BlockKey bk = new BlockKey(b, meta);
        if (this.disallowedBlocks.contains(bk)) {
            return false;
        }
        return !this.disallowedChanges.get(BlockKey.getAt((IBlockAccess)this.delegate, x, y, z)).contains(bk);
    }

    public boolean func_147449_b(int x, int y, int z, Block b) {
        boolean flag;
        boolean bl = flag = this.check(x, y, z, b, 0) ? this.delegate.func_147449_b(x, y, z, b) : false;
        if (flag) {
            this.markHook(x, y, z);
        }
        return flag;
    }

    public boolean func_147465_d(int x, int y, int z, Block b, int meta, int flags) {
        boolean flag;
        boolean bl = flag = this.check(x, y, z, b, meta) ? this.delegate.func_147465_d(x, y, z, b, meta, flags) : false;
        if (flag) {
            this.markHook(x, y, z);
        }
        return flag;
    }

    public boolean func_72921_c(int x, int y, int z, int meta, int flags) {
        boolean flag;
        boolean bl = flag = this.check(x, y, z, this.delegate.func_147439_a(x, y, z), meta) ? this.delegate.func_72921_c(x, y, z, meta, flags) : false;
        if (flag) {
            this.markHook(x, y, z);
        }
        return flag;
    }

    public void func_147455_a(int x, int y, int z, TileEntity te) {
        this.delegate.func_147455_a(x, y, z, te);
        this.markHook(x, y, z);
    }

    public Block func_147439_a(int x, int y, int z) {
        Block ret = this.delegate.func_147439_a(x, y, z);
        BlockKey over = this.overrides.get(ret, this.delegate.func_72805_g(x, y, z));
        return over != null ? over.blockID : ret;
    }

    public int func_72805_g(int x, int y, int z) {
        int ret = this.delegate.func_72805_g(x, y, z);
        BlockKey over = this.overrides.get(this.delegate.func_147439_a(x, y, z), ret);
        return over != null ? over.metadata : ret;
    }

    private void markHook(int x, int y, int z) {
        this.changeList.add(new Coordinate(x, y, z));
    }

    public void runHooks() {
        for (TileHook th : this.hooks) {
            for (Coordinate c : this.changeList) {
                if (!th.shouldRun(this.delegate, c.xCoord, c.yCoord, c.zCoord)) continue;
                TileEntity te = c.getTileEntity(this.delegate);
                th.onTileChanged(te);
            }
        }
        this.changeList.clear();
    }

    public boolean func_72838_d(Entity e) {
        return this.delegate.func_72838_d(e);
    }

    protected IChunkProvider func_72970_h() {
        return null;
    }

    protected int func_152379_p() {
        return 10;
    }

    public Entity func_73045_a(int id) {
        return this.delegate.func_73045_a(id);
    }

    public void func_72939_s() {
    }

    public void func_72870_g(Entity e) {
    }

    public void func_72866_a(Entity e, boolean flag) {
    }

    public static interface TileHook {
        public void onTileChanged(TileEntity var1);

        public boolean shouldRun(World var1, int var2, int var3, int var4);
    }

    private static class NoSaveHandler
    implements ISaveHandler {
        private NoSaveHandler() {
        }

        public WorldInfo func_75757_d() {
            return null;
        }

        public void func_75762_c() throws MinecraftException {
        }

        public IChunkLoader func_75763_a(WorldProvider p_75763_1_) {
            return null;
        }

        public void func_75755_a(WorldInfo p_75755_1_, NBTTagCompound p_75755_2_) {
        }

        public void func_75761_a(WorldInfo p_75761_1_) {
        }

        public IPlayerFileData func_75756_e() {
            return null;
        }

        public void func_75759_a() {
        }

        public File func_75765_b() {
            return null;
        }

        public File func_75758_b(String p_75758_1_) {
            return null;
        }

        public String func_75760_g() {
            return null;
        }
    }
}

