/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.ParticleController;

import Reika.DragonAPI.Interfaces.MotionController;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;

public class AttractiveMotionController
implements MotionController {
    public final double targetX;
    public final double targetY;
    public final double targetZ;
    private final double damping;
    private final double acceleration;
    private double velocityXZ = 0.0;
    private double accelerationY = 0.0;
    private double maxVelocityY;
    private double velocityY;

    public AttractiveMotionController(TileEntity te, double axz, double vy, double damping) {
        this((double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5, axz, vy, damping);
    }

    public AttractiveMotionController(double x, double y, double z, double axz, double vy, double damping) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.damping = damping;
        this.acceleration = axz;
        this.velocityY = this.maxVelocityY = vy;
    }

    @Override
    public void update(Entity e) {
        this.accelerationY = -0.125 * (e.field_70163_u - this.targetY - 0.5);
        this.velocityY += this.accelerationY;
        this.velocityY = MathHelper.func_151237_a((double)this.velocityY, (double)(-this.maxVelocityY), (double)this.maxVelocityY);
        this.maxVelocityY *= this.damping;
        this.velocityXZ += this.acceleration;
    }

    @Override
    public double getMotionX(Entity e) {
        return -(e.field_70165_t - this.targetX) * this.velocityXZ / e.func_70011_f(this.targetX, this.targetY, this.targetZ);
    }

    @Override
    public double getMotionY(Entity e) {
        return this.velocityY;
    }

    @Override
    public double getMotionZ(Entity e) {
        return -(e.field_70161_v - this.targetZ) * this.velocityXZ / e.func_70011_f(this.targetX, this.targetY, this.targetZ);
    }
}

