/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.ModInteract;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.ModList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import thaumcraft.api.aspects.Aspect;

public class CompoundAspectTank {
    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    private HashMap<Aspect, Integer> aspects;
    protected final int capacity;
    public final int maxTypes;

    public CompoundAspectTank(int c) {
        this(c, Integer.MAX_VALUE);
    }

    public CompoundAspectTank(int c, int types) {
        this.capacity = c;
        this.maxTypes = types;
        if (ModList.THAUMCRAFT.isLoaded()) {
            this.aspects = new HashMap();
        }
    }

    public int getMaxCapacity(Aspect a) {
        return this.capacity;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int getLevel(Aspect a) {
        Integer ret = this.aspects.get(a);
        return ret != null ? ret : 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public final int getRemainingSpace(Aspect a) {
        return this.getMaxCapacity(a) - this.getLevel(a);
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public Collection<Aspect> getAspects() {
        return Collections.unmodifiableCollection(this.aspects.keySet());
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public void setAspect(Aspect a, int amt) {
        if (this.canAccept(a)) {
            this.aspects.put(a, amt);
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int addAspect(Aspect a, int amt) {
        if (this.canAccept(a)) {
            int add = Math.min(amt, this.getRemainingSpace(a));
            int newlevel = this.getLevel(a) + add;
            this.setAspect(a, newlevel);
            return add;
        }
        return 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean canAccept(Aspect a) {
        return this.aspects.containsKey(a) || this.aspects.size() < this.maxTypes;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int drainAspect(Aspect a, int amt) {
        int rem;
        int level = this.getLevel(a);
        int newlevel = level - (rem = Math.min(amt, level));
        if (newlevel <= 0) {
            this.aspects.remove(a);
        } else {
            this.setAspect(a, newlevel);
        }
        return rem;
    }

    public void writeToNBT(NBTTagCompound NBT) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return;
        }
        NBTTagCompound dat = new NBTTagCompound();
        for (Aspect a : this.aspects.keySet()) {
            dat.func_74768_a(a.getTag(), this.getLevel(a));
        }
        NBT.func_74782_a("aspectData", (NBTBase)dat);
    }

    public void readFromNBT(NBTTagCompound NBT) {
        if (!ModList.THAUMCRAFT.isLoaded()) {
            return;
        }
        NBTTagCompound dat = NBT.func_74775_l("aspectData");
        this.aspects.clear();
        for (Object o : dat.func_150296_c()) {
            String s = (String)o;
            Aspect a = Aspect.getAspect((String)s);
            this.aspects.put(a, dat.func_74762_e(s));
        }
    }

    public void empty() {
        this.aspects.clear();
    }

    public Aspect getFirstAspect() {
        return this.isEmpty() ? null : (Aspect)this.aspects.keySet().toArray()[0];
    }

    public boolean isEmpty() {
        return this.aspects.isEmpty();
    }

    public static class PrimalOnlyAspectTank
    extends CompoundAspectTank {
        public PrimalOnlyAspectTank(int c) {
            super(c);
        }

        public PrimalOnlyAspectTank(int c, int types) {
            super(c, types);
        }

        @Override
        public boolean canAccept(Aspect a) {
            return a.isPrimal();
        }
    }
}

