/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.IO.ReikaXMLBase;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLInterface {
    private Document doc;
    private final boolean requireFile;
    private final Object[] loadData;
    private final LoadFormat format;
    private final HashMap<String, String> data = new HashMap();
    private final MultiMap<String, String> tree = new MultiMap();
    public static final String NULL_VALUE = "#NULL!";

    public XMLInterface(Class root, String path) {
        this(root, path, false);
    }

    public XMLInterface(File path, boolean crashIfNull) {
        this.format = LoadFormat.FILE;
        this.loadData = new Object[]{path};
        this.requireFile = crashIfNull;
        try {
            this.doc = ReikaXMLBase.getXMLDocument(new FileInputStream(path));
        }
        catch (Exception e) {
            if (this.requireFile) {
                throw new RuntimeException("Could not load XML at " + path, e);
            }
            e.printStackTrace();
        }
    }

    public XMLInterface(Class root, String path, boolean crashIfNull) {
        this.format = LoadFormat.JARPATH;
        this.requireFile = crashIfNull;
        this.loadData = new Object[]{root, path};
        try {
            InputStream in = root.getResourceAsStream(path);
            if (in == null) {
                throw new RuntimeException("XML file at " + path + " relative to " + root.getName() + " not found!");
            }
            this.doc = ReikaXMLBase.getXMLDocument(in);
        }
        catch (RuntimeException e) {
            if (this.requireFile) {
                throw new RuntimeException("Could not load XML at " + path + " relative to " + root.getName(), e);
            }
            e.printStackTrace();
        }
        this.readFileToMap();
    }

    public void reread() {
        try {
            InputStream in = this.format.getInputStream(this.loadData);
            this.doc = ReikaXMLBase.getXMLDocument(in);
            this.readFileToMap();
        }
        catch (Exception e) {
            if (this.requireFile) {
                throw new RuntimeException("Could not load XML: " + Arrays.toString(this.loadData), e);
            }
            e.printStackTrace();
        }
    }

    private void readFileToMap() {
        this.data.clear();
        this.tree.clear();
        this.recursiveRead("$TOP$", this.doc);
    }

    private void recursiveRead(String parent, Node n) {
        if (n == null) {
            return;
        }
        NodeList li = n.getChildNodes();
        int len = li.getLength();
        for (int i = 0; i < len; ++i) {
            Node ch = li.item(i);
            String key = ReikaXMLBase.getNodeNameTree(ch);
            this.tree.addValue(parent, key);
            if (ch.getNodeType() == 1) {
                this.recursiveRead(key, ch);
                continue;
            }
            if (ch.getNodeType() != 3) continue;
            String val = ch.getNodeValue();
            if (val != null) {
                if (val.equals("\n")) {
                    val = null;
                } else {
                    if (val.startsWith("\n")) {
                        val = val.substring(1);
                    }
                    if (val.endsWith("\n")) {
                        val = val.substring(0, val.length() - 1);
                    }
                }
                if (val != null && val.equals("\n")) {
                    val = null;
                }
            }
            if (val == null) continue;
            if (this.data.containsKey(key)) {
                // empty if block
            }
            this.data.put(key, this.cleanString(val));
        }
    }

    private String cleanString(String val) {
        val = val.replace("\t", "");
        while (!val.isEmpty() && val.endsWith("\\n")) {
            val = val.substring(0, val.length() - 2);
        }
        while (!val.isEmpty() && val.charAt(0) == ' ') {
            val = val.substring(1);
        }
        while (!val.isEmpty() && val.charAt(val.length() - 1) == ' ') {
            val = val.substring(0, val.length() - 1);
        }
        return val;
    }

    public String getValueAtNode(String name) {
        String dat = this.data.get(name);
        if (dat == null) {
            dat = NULL_VALUE;
        }
        return dat;
    }

    public boolean nodeExists(String name) {
        return this.data.containsKey(name);
    }

    public Collection<String> getNodesWithin(String name) {
        return name == null ? this.getTopNodes() : this.tree.get(name);
    }

    public Collection<String> getTopNodes() {
        return this.tree.get("$TOP$");
    }

    public String toString() {
        return this.data.toString();
    }

    private static enum LoadFormat {
        JARPATH,
        FILE;


        private InputStream getInputStream(Object[] data) throws Exception {
            switch (this) {
                case FILE: {
                    return new FileInputStream((File)data[0]);
                }
                case JARPATH: {
                    return ((Class)data[0]).getResourceAsStream((String)data[1]);
                }
            }
            return null;
        }
    }
}

