/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Interfaces.DataSync;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public final class SyncPacket
extends S35PacketUpdateTileEntity
implements DataSync {
    private final HashMap<String, NBTBase> data = new HashMap();
    private final HashMap<String, NBTBase> oldData = new HashMap();
    private final HashMap<String, NBTBase> changes = new HashMap();
    private boolean dispatch;
    private boolean receive;
    private static final String ERROR_TAG = "erroredPacket";

    @Override
    public void setData(TileEntity te, boolean force, NBTTagCompound NBT) {
        if (this.dispatch) {
            if (DragonOptions.LOGSYNCCME.getState()) {
                DragonAPICore.log("The sync packet for " + te + " would have just CME'd, as the");
                DragonAPICore.log("Server-Thread data-writing code has overlapped with the Network-Thread byte[] dispatch.");
                DragonAPICore.log("Seeing this message frequently could indicate a serious issue.\n");
            }
            return;
        }
        this.field_148863_a = te.field_145851_c;
        this.field_148861_b = te.field_145848_d;
        this.field_148862_c = te.field_145849_e;
        this.changes.clear();
        Set c = NBT.func_150296_c();
        for (String name : c) {
            if (name == null) {
                DragonAPICore.logError("An NBT tag with a null key is being sent to the sync packet from " + te);
                continue;
            }
            NBTBase tag = NBT.func_74781_a(name);
            this.addData(name, tag, force);
        }
    }

    private void addData(String key, NBTBase value, boolean force) {
        NBTBase prev = this.data.get(key);
        this.oldData.put(key, prev);
        this.data.put(key, value);
        if (force || !this.match(prev, value)) {
            this.changes.put(key, value);
        }
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public void func_148837_a(PacketBuffer in) throws IOException {
        this.receive = true;
        try {
            this.field_148863_a = in.readInt();
            this.field_148861_b = in.readShort();
            this.field_148862_c = in.readInt();
            NBTTagCompound received = in.func_150793_b();
            if (!received.func_74767_n(ERROR_TAG)) {
                this.populateFromStream(received);
            }
        }
        catch (Exception e) {
            DragonAPICore.logError("Error reading Sync Tag!");
            e.printStackTrace();
            this.data.clear();
        }
        this.receive = false;
    }

    private void populateFromStream(NBTTagCompound received) {
        Set c = received.func_150296_c();
        for (String name : c) {
            NBTBase tag = received.func_74781_a(name);
            this.data.put(name, tag);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readForSync(TileEntity te, NBTTagCompound NBT) {
        if (this.dispatch) {
            if (DragonOptions.LOGSYNCCME.getState()) {
                DragonAPICore.log("The sync packet for " + te + " would have just CME'd, as the");
                DragonAPICore.log("Client-Thread data-reading code has overlapped with the Network-Thread byte[] reading.");
                DragonAPICore.log("Seeing this message frequently could indicate a serious issue.\n");
            }
            return;
        }
        for (String key : this.data.keySet()) {
            NBT.func_74782_a(key, this.data.get(key));
        }
    }

    public void func_148840_b(PacketBuffer out) throws IOException {
        this.dispatch = true;
        out.writeInt(this.field_148863_a);
        out.writeShort(this.field_148861_b);
        out.writeInt(this.field_148862_c);
        NBTTagCompound toSend = new NBTTagCompound();
        try {
            this.saveChanges(toSend);
        }
        catch (Exception e) {
            toSend.func_74757_a(ERROR_TAG, true);
            e.printStackTrace();
        }
        try {
            out.func_150786_a(toSend);
        }
        catch (Exception e) {
            DragonAPICore.logError("Error writing Sync Tag!");
            out.clear();
            e.printStackTrace();
        }
        this.dispatch = false;
    }

    private void saveChanges(NBTTagCompound toSend) {
        for (String key : this.changes.keySet()) {
            NBTBase val = this.changes.get(key);
            toSend.func_74782_a(key, val);
        }
    }

    private boolean match(NBTBase old, NBTBase cur) {
        if (old == cur) {
            return true;
        }
        if (old == null || cur == null) {
            return false;
        }
        return cur.equals((Object)old);
    }

    public String toString() {
        return this.changes.isEmpty() ? "[Empty]" : this.changes.toString();
    }

    @Override
    public boolean hasNoData() {
        return this.data.isEmpty();
    }
}

