/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data;

import Reika.DragonAPI.Exception.MisuseException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public final class KeyedItemStack {
    private final ItemStack item;
    private final boolean[] enabledCriteria = new boolean[Criteria.access$000().length];
    private boolean lock = false;
    private boolean simpleHash = false;

    public KeyedItemStack(Block b) {
        this(Item.func_150898_a((Block)b));
    }

    public KeyedItemStack(Item i) {
        this(new ItemStack(i, 1, Short.MAX_VALUE));
        this.setIgnoreMetadata(true);
        this.setSized(false);
        this.setIgnoreNBT(true);
        this.setSimpleHash(true);
    }

    public KeyedItemStack(ItemStack is) {
        if (is == null || is.func_77973_b() == null) {
            throw new MisuseException("You cannot key a null itemstack!");
        }
        this.item = is.func_77946_l();
        for (int i = 0; i < this.enabledCriteria.length; ++i) {
            this.enabledCriteria[i] = Criteria.list[i].defaultState;
        }
    }

    public KeyedItemStack setSized(boolean size) {
        if (!this.lock) {
            this.enabledCriteria[Criteria.SIZE.ordinal()] = size;
        }
        return this;
    }

    public KeyedItemStack setIgnoreMetadata(boolean ignore) {
        if (!this.lock) {
            this.enabledCriteria[Criteria.METADATA.ordinal()] = !ignore;
        }
        return this;
    }

    public KeyedItemStack setIgnoreNBT(boolean ignore) {
        if (!this.lock) {
            this.enabledCriteria[Criteria.NBT.ordinal()] = !ignore;
        }
        return this;
    }

    public KeyedItemStack setSimpleHash(boolean flag) {
        if (!this.lock) {
            this.simpleHash = flag;
        }
        return this;
    }

    public KeyedItemStack lock() {
        this.lock = true;
        return this;
    }

    public final int hashCode() {
        if (this.simpleHash) {
            return this.item.func_77973_b().hashCode();
        }
        int hash = 0;
        for (int i = 0; i < Criteria.list.length; ++i) {
            Criteria c = Criteria.list[i];
            if (!this.enabledCriteria[i]) continue;
            hash += c.hash(this) << i;
        }
        return hash;
    }

    public final boolean equals(Object o) {
        if (o instanceof KeyedItemStack) {
            KeyedItemStack ks = (KeyedItemStack)o;
            return this.match(ks, false);
        }
        return false;
    }

    public boolean exactMatch(KeyedItemStack ks) {
        return this.match(ks, true);
    }

    private boolean match(KeyedItemStack ks, boolean force) {
        for (int i = 0; i < Criteria.list.length; ++i) {
            Criteria c = Criteria.list[i];
            if (!force && (!this.enabledCriteria[i] || !ks.enabledCriteria[i]) || c.match(this, ks)) continue;
            return false;
        }
        return true;
    }

    public boolean match(ItemStack is) {
        KeyedItemStack ks = new KeyedItemStack(is);
        ks.setSimpleHash(this.simpleHash);
        for (int i = 0; i < Criteria.list.length; ++i) {
            ks.enabledCriteria[i] = this.enabledCriteria[i];
        }
        return this.equals(ks);
    }

    public ItemStack getItemStack() {
        return this.item.func_77946_l();
    }

    public String toString() {
        return this.item.toString() + "|" + this.getCriteriaFlags();
    }

    private String getCriteriaFlags() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.enabledCriteria.length; ++i) {
            sb.append(this.enabledCriteria[i] ? "1" : "0");
        }
        return sb.toString();
    }

    public KeyedItemStack copy() {
        KeyedItemStack ks = new KeyedItemStack(this.item.func_77946_l());
        ks.setSimpleHash(this.simpleHash);
        for (int i = 0; i < Criteria.list.length; ++i) {
            ks.enabledCriteria[i] = this.enabledCriteria[i];
        }
        ks.lock = this.lock;
        return ks;
    }

    public String getCriteriaAsChatFormatting() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.enabledCriteria.length; ++i) {
            if (!this.enabledCriteria[i]) continue;
            sb.append(Criteria.list[i].chatChar.toString());
        }
        return sb.toString();
    }

    public static KeyedItemStack readFromNBT(NBTTagCompound nbt) {
        return new KeyedItemStack(ItemStack.func_77949_a((NBTTagCompound)nbt)).setIgnoreMetadata(nbt.func_74767_n("ignoremeta")).setIgnoreNBT(nbt.func_74767_n("ignorenbt")).setSized(nbt.func_74767_n("sized")).setSimpleHash(nbt.func_74767_n("simplehash"));
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.item.func_77955_b(nbt);
        nbt.func_74757_a("sized", this.enabledCriteria[Criteria.SIZE.ordinal()]);
        nbt.func_74757_a("ignorenbt", !this.enabledCriteria[Criteria.NBT.ordinal()]);
        nbt.func_74757_a("ignoremeta", !this.enabledCriteria[Criteria.METADATA.ordinal()]);
        nbt.func_74757_a("useID", this.enabledCriteria[Criteria.ID.ordinal()]);
        nbt.func_74757_a("simplehash", this.simpleHash);
    }

    private static enum Criteria {
        ID(true, EnumChatFormatting.RESET),
        METADATA(true, EnumChatFormatting.LIGHT_PURPLE),
        SIZE(false, EnumChatFormatting.BOLD),
        NBT(true, EnumChatFormatting.UNDERLINE);

        private final boolean defaultState;
        private final EnumChatFormatting chatChar;
        private static final Criteria[] list;

        private Criteria(boolean b, EnumChatFormatting f) {
            this.defaultState = b;
            this.chatChar = f;
        }

        public int hash(KeyedItemStack ks) {
            switch (this) {
                case ID: {
                    return ks.item.func_77973_b().hashCode();
                }
                case METADATA: {
                    return ks.item.func_77960_j();
                }
                case SIZE: {
                    return ((KeyedItemStack)ks).item.field_77994_a;
                }
                case NBT: {
                    return ((KeyedItemStack)ks).item.field_77990_d != null ? ((KeyedItemStack)ks).item.field_77990_d.hashCode() : -1;
                }
            }
            return 0;
        }

        private boolean match(KeyedItemStack k1, KeyedItemStack k2) {
            switch (this) {
                case ID: {
                    return k1.item.func_77973_b() == k2.item.func_77973_b();
                }
                case METADATA: {
                    if (k1.item.func_77973_b().func_77614_k() || k2.item.func_77973_b().func_77614_k()) {
                        int m2;
                        int m1 = k1.item.func_77960_j();
                        return m1 == (m2 = k2.item.func_77960_j()) || m1 == Short.MAX_VALUE || m2 == Short.MAX_VALUE;
                    }
                    return true;
                }
                case SIZE: {
                    return ((KeyedItemStack)k1).item.field_77994_a == ((KeyedItemStack)k2).item.field_77994_a;
                }
                case NBT: {
                    return ItemStack.func_77970_a((ItemStack)k1.item, (ItemStack)k2.item);
                }
            }
            return false;
        }

        static {
            list = Criteria.values();
        }
    }
}

