/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.ChromatiCraft.API.TreeGetter;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Registry.TreeType;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public final class TreeReader
extends BlockArray {
    private int leafCount;
    private int logCount;
    private TreeType tree;
    private ReikaDyeHelper dyeTree;
    private final Block dyeLeafID;
    private final Block rainbowLeafID;
    private final Block rainbowSaplingID;
    private final Block dyeSaplingID;
    private boolean isDyeTree = false;
    private boolean isRainbowTree = false;
    private int dyeMeta = -1;

    public TreeReader() {
        if (ModList.CHROMATICRAFT.isLoaded()) {
            this.dyeLeafID = TreeGetter.getNaturalDyeLeafID();
            this.rainbowLeafID = TreeGetter.getRainbowLeafID();
            this.rainbowSaplingID = TreeGetter.getRainbowSaplingID();
            this.dyeSaplingID = TreeGetter.getSaplingID();
        } else {
            this.dyeLeafID = null;
            this.rainbowLeafID = null;
            this.rainbowSaplingID = null;
            this.dyeSaplingID = null;
        }
    }

    public boolean isDyeTree() {
        return this.isDyeTree;
    }

    public boolean isRainbowTree() {
        return this.isRainbowTree;
    }

    public int getDyeTreeMeta() {
        return this.dyeMeta;
    }

    public void addTree(World world, int x, int y, int z) {
        HashSet<Coordinate> search = new HashSet<Coordinate>();
        HashSet<Coordinate> failed = new HashSet<Coordinate>();
        HashSet<Coordinate> next = new HashSet<Coordinate>();
        int iterations = 0;
        this.validateAndAdd(world, x, y, z, search, failed);
        while (!search.isEmpty() && iterations < this.maxDepth) {
            ++iterations;
            Iterator<Coordinate> it = search.iterator();
            while (it.hasNext()) {
                Coordinate c = it.next();
                this.addBlockCoordinate(c.xCoord, c.yCoord, c.zCoord);
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        for (int dz = -1; dz <= 1; ++dz) {
                            Coordinate c2;
                            if (dx == 0 && dy == 0 && dz == 0 || search.contains(c2 = c.offset(dx, dy, dz)) || next.contains(c2) || this.containsKey(c2) || failed.contains(c2)) continue;
                            this.validateAndAdd(world, c2.xCoord, c2.yCoord, c2.zCoord, next, failed);
                        }
                    }
                }
                it.remove();
            }
            search.addAll(next);
            next.clear();
        }
    }

    private boolean isTree(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (this.tree != null && this.tree.getLogID() == b) {
            ++this.logCount;
            return true;
        }
        if (!(this.isRainbowTree || b != this.dyeLeafID || this.dyeMeta != -1 && this.dyeMeta != meta)) {
            this.dyeMeta = meta;
            this.isDyeTree = true;
            ++this.leafCount;
            this.maxDepth = 12;
            return true;
        }
        if (!this.isDyeTree && b == this.rainbowLeafID) {
            this.isRainbowTree = true;
            ++this.leafCount;
            this.maxDepth = 36;
            return true;
        }
        if (this.tree != null && !this.isDyeTree && !this.isRainbowTree && b == this.tree.getLeafID() && this.tree.getLeafMetadatas().contains(meta)) {
            ++this.leafCount;
            return true;
        }
        return false;
    }

    private void validateAndAdd(World world, int x, int y, int z, HashSet<Coordinate> search, HashSet<Coordinate> failed) {
        Coordinate c = new Coordinate(x, y, z);
        if (this.isTree(world, x, y, z)) {
            search.add(c);
        } else {
            failed.add(c);
        }
    }

    public int getNumberLeaves() {
        return this.leafCount;
    }

    public int getNumberLogs() {
        return this.logCount;
    }

    public void reset() {
        this.logCount = 0;
        this.leafCount = 0;
        this.tree = null;
        this.isDyeTree = false;
        this.dyeMeta = -1;
    }

    public void setTree(TreeType tree) {
        this.tree = tree;
        if (tree != null) {
            this.maxDepth = TreeReader.getMaxDepthFromTreeType(tree);
        }
    }

    public static int getMaxDepthFromTreeType(TreeType tree) {
        if (tree instanceof ReikaTreeHelper) {
            switch ((ReikaTreeHelper)tree) {
                case ACACIA: {
                    return 12;
                }
                case BIRCH: {
                    return 6;
                }
                case DARKOAK: {
                    return 12;
                }
                case JUNGLE: {
                    return 36;
                }
                case OAK: {
                    return 18;
                }
                case SPRUCE: {
                    return 48;
                }
            }
            return 12;
        }
        if (tree instanceof ModWoodList) {
            switch ((ModWoodList)tree) {
                case IRONWOOD: {
                    return 60;
                }
                case SEQUOIA: {
                    return 200;
                }
                case REDWOOD: {
                    return 130;
                }
                case DARKWOOD: {
                    return 80;
                }
                case SACRED: {
                    return 50;
                }
                case CANOPY: {
                    return 40;
                }
                case TWILIGHTOAK: {
                    return 200;
                }
                case MANGROVE: {
                    return 30;
                }
                case SAKURA: {
                    return 24;
                }
                case GREATWOOD: 
                case SILVERWOOD: {
                    return 28;
                }
                case MFRRUBBER: {
                    return 80;
                }
            }
            return 12;
        }
        return 12;
    }

    public ItemStack getSapling() {
        if (this.isDyeTree) {
            return new ItemStack(this.dyeSaplingID, 1, this.dyeMeta);
        }
        if (this.isRainbowTree) {
            return new ItemStack(this.rainbowSaplingID);
        }
        return this.tree != null ? new ItemStack(this.tree.getSaplingID(), 1, this.tree.getSaplingMeta()) : null;
    }

    @Override
    public Coordinate getNextAndMoveOn() {
        Coordinate next = super.getNextAndMoveOn();
        if (this.isEmpty()) {
            // empty if block
        }
        return next;
    }

    public boolean isValidTree() {
        if (this.tree == ModWoodList.SEQUOIA) {
            return true;
        }
        return this.getNumberLeaves() >= 5 && this.getNumberLogs() >= 2;
    }

    public TreeType getTreeType() {
        return this.tree;
    }

    @Override
    protected BlockArray instantiate() {
        return new TreeReader();
    }

    @Override
    public void copyTo(BlockArray cp) {
        TreeReader copy = (TreeReader)cp;
        copy.leafCount = this.leafCount;
        copy.logCount = this.logCount;
        copy.tree = this.tree;
        copy.dyeTree = this.dyeTree;
        copy.isDyeTree = this.isDyeTree;
        copy.isRainbowTree = this.isRainbowTree;
        copy.dyeMeta = this.dyeMeta;
    }
}

