/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Data.BlockStruct;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.SphericalVector;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class CurvedTrajectory {
    private final DecimalPosition origin;
    public int trailCount = 1;
    public float trailForkChance = 0.0f;
    public BlockBox bounds = BlockBox.infinity();
    private final HashSet<Coordinate> locations = new HashSet();
    private final Collection<Trail> trails = new ArrayList<Trail>();

    public CurvedTrajectory(int x, int y, int z) {
        this.origin = new DecimalPosition((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
    }

    public void generatePaths(long seed, TrailShape ts) {
        this.generatePaths(seed, ts, null);
    }

    public void generatePaths(long seed, TrailShape ts, InitialAngleProvider p) {
        Random rand = new Random(seed);
        for (int i = 0; i < this.trailCount; ++i) {
            this.trails.add(new Trail(this.origin, seed, p));
        }
        while (!this.trails.isEmpty()) {
            ArrayList<Trail> newTrails = this.trailForkChance > 0.0f ? new ArrayList<Trail>() : null;
            Iterator<Trail> it = this.trails.iterator();
            while (it.hasNext()) {
                Trail t = it.next();
                t.step();
                if (this.bounds.asAABB().func_72318_a(t.position.toVec3())) {
                    Collection<Coordinate> li = ts.getBlocks(t.position);
                    if (li.isEmpty()) {
                        it.remove();
                        continue;
                    }
                    boolean flag = false;
                    for (Coordinate c : li) {
                        if (!this.locations.add(c)) continue;
                        flag = true;
                    }
                    if (!flag) {
                        // empty if block
                    }
                    if (rand.nextFloat() < this.trailForkChance) {
                        Trail t2 = t.copy();
                        t2.updateVelocity();
                        t2.targetPhi += -10.0 + rand.nextDouble() * 20.0;
                        t2.targetTheta += -10.0 + rand.nextDouble() * 20.0;
                        newTrails.add(t2);
                    }
                    t.updateVelocity();
                    continue;
                }
                it.remove();
            }
            if (newTrails == null) continue;
            this.trails.addAll(newTrails);
        }
    }

    public HashSet<Coordinate> getLocations() {
        return new HashSet<Coordinate>(this.locations);
    }

    private class Trail {
        private DecimalPosition position;
        private final long seed;
        private final Random rand;
        private final SphericalVector velocity;
        private double targetTheta;
        private double targetPhi;

        private Trail(DecimalPosition pos, long seed, InitialAngleProvider p) {
            this.seed = seed;
            this.rand = new Random(seed);
            this.position = pos;
            this.velocity = new SphericalVector(0.25, p != null ? p.getInitialTheta(this.rand, CurvedTrajectory.this.trails.size()) : (double)this.rand.nextInt(360), p != null ? p.getInitialPhi(this.rand, CurvedTrajectory.this.trails.size()) : (double)this.rand.nextInt(360));
        }

        public Trail copy() {
            Trail t = new Trail(this.position, this.seed, null);
            t.velocity.inclination = this.velocity.inclination;
            t.velocity.rotation = this.velocity.magnitude;
            t.targetPhi = this.targetPhi;
            t.targetTheta = this.targetTheta;
            return t;
        }

        private void step() {
            double[] xyz = this.velocity.getCartesian();
            this.position = this.position.offset(xyz[0], xyz[1], xyz[2]);
        }

        private void updateVelocity() {
            if (ReikaMathLibrary.approxr(this.velocity.inclination, this.targetTheta, 2.0)) {
                this.targetTheta = this.rand.nextInt(360);
            } else {
                this.velocity.inclination = this.targetTheta > this.velocity.inclination ? (this.velocity.inclination += 2.0) : (this.velocity.inclination -= 2.0);
            }
            if (ReikaMathLibrary.approxr(this.velocity.rotation, this.targetPhi, 2.0)) {
                this.targetPhi = this.rand.nextInt(360);
            } else {
                this.velocity.rotation = this.targetPhi > this.velocity.rotation ? (this.velocity.rotation += 2.0) : (this.velocity.rotation -= 2.0);
            }
        }
    }

    public static interface InitialAngleProvider {
        public double getInitialTheta(Random var1, int var2);

        public double getInitialPhi(Random var1, int var2);
    }

    public static interface TrailShape {
        public Collection<Coordinate> getBlocks(DecimalPosition var1);
    }
}

