/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Interfaces.Configuration.BooleanConfig;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Interfaces.Configuration.DecimalConfig;
import Reika.DragonAPI.Interfaces.Configuration.IntArrayConfig;
import Reika.DragonAPI.Interfaces.Configuration.IntegerConfig;
import Reika.DragonAPI.Interfaces.Configuration.StringArrayConfig;
import Reika.DragonAPI.Interfaces.Configuration.StringConfig;
import java.util.logging.Level;
import net.minecraft.util.EnumChatFormatting;

public class Alert {
    private final ConfigList option;
    private final String message;
    public final Level severity;
    public final String ID;

    public Alert(String id, ConfigList cfg, Level lvl, String msg) {
        this.option = cfg;
        this.message = msg;
        this.severity = lvl;
        this.ID = id;
    }

    public String toString() {
        String c = this.isSevere() ? "(Severe!)" : "";
        return this.ID + " " + this.getValue() + " (normally " + this.getDefault() + "):" + this.message + "; " + c;
    }

    public final boolean isSevere() {
        return this.severity == Level.SEVERE;
    }

    private EnumChatFormatting getColor() {
        if (this.severity == Level.SEVERE) {
            return EnumChatFormatting.RED;
        }
        if (this.severity == Level.WARNING) {
            return EnumChatFormatting.GOLD;
        }
        return EnumChatFormatting.WHITE;
    }

    public String getMessage() {
        return this.getColor().toString() + this.message + "\nDefault: " + this.getDefault() + "\nActual Value: " + this.getValue();
    }

    public boolean equals(Object o) {
        return o instanceof Alert && ((Alert)o).option == this.option && ((Alert)o).message.equals(this.message);
    }

    private final Object getDefault() {
        if (this.option instanceof BooleanConfig && ((BooleanConfig)this.option).isBoolean()) {
            return ((BooleanConfig)this.option).getDefaultState();
        }
        if (this.option instanceof IntegerConfig && ((IntegerConfig)this.option).isNumeric()) {
            return ((IntegerConfig)this.option).getDefaultValue();
        }
        if (this.option instanceof DecimalConfig && ((DecimalConfig)this.option).isDecimal()) {
            return Float.valueOf(((DecimalConfig)this.option).getDefaultFloat());
        }
        if (this.option instanceof StringConfig && ((StringConfig)this.option).isString()) {
            return ((StringConfig)this.option).getDefaultString();
        }
        if (this.option instanceof IntArrayConfig && ((IntArrayConfig)this.option).isIntArray()) {
            return ((IntArrayConfig)this.option).getDefaultIntArray();
        }
        if (this.option instanceof StringArrayConfig && ((StringArrayConfig)this.option).isStringArray()) {
            return ((StringArrayConfig)this.option).getDefaultStringArray();
        }
        return null;
    }

    private final Object getValue() {
        if (this.option instanceof BooleanConfig && ((BooleanConfig)this.option).isBoolean()) {
            return ((BooleanConfig)this.option).getState();
        }
        if (this.option instanceof IntegerConfig && ((IntegerConfig)this.option).isNumeric()) {
            return ((IntegerConfig)this.option).getValue();
        }
        if (this.option instanceof DecimalConfig && ((DecimalConfig)this.option).isDecimal()) {
            return Float.valueOf(((DecimalConfig)this.option).getFloat());
        }
        if (this.option instanceof StringConfig && ((StringConfig)this.option).isString()) {
            return ((StringConfig)this.option).getString();
        }
        if (this.option instanceof IntArrayConfig && ((IntArrayConfig)this.option).isIntArray()) {
            return ((IntArrayConfig)this.option).getIntArray();
        }
        if (this.option instanceof StringArrayConfig && ((StringArrayConfig)this.option).isStringArray()) {
            return ((StringArrayConfig)this.option).getStringArray();
        }
        return null;
    }
}

