/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.EnumChatFormatting;

public class FindThreadCommand
extends DragonCommandBase {
    public void func_71515_b(ICommandSender ics, String[] args) {
        if (args.length < 1) {
            FindThreadCommand.sendChatToSender(ics, EnumChatFormatting.RED + "You must specify a thread name, and optionally an action.");
            return;
        }
        Thread t = ReikaJavaLibrary.getThreadByName(args[0]);
        if (t == null) {
            FindThreadCommand.sendChatToSender(ics, EnumChatFormatting.RED + "No such thread '" + args[0] + "'");
            return;
        }
        FindThreadCommand.sendChatToSender(ics, "Thread class: " + t.getClass().getName());
        FindThreadCommand.sendChatToSender(ics, "Thread status: " + (Object)((Object)t.getState()));
        FindThreadCommand.sendChatToSender(ics, "Thread priority: " + t.getPriority());
        FindThreadCommand.sendChatToSender(ics, "Thread is alive: " + t.isAlive());
        FindThreadCommand.sendChatToSender(ics, "Thread is daemon: " + t.isDaemon());
        if (args.length == 2) {
            switch (args[1].toLowerCase(Locale.ENGLISH)) {
                case "stack": 
                case "stacktrace": 
                case "trace": {
                    FindThreadCommand.sendChatToSender(ics, "Thread class: " + t.getStackTrace());
                    break;
                }
                case "kill": 
                case "end": 
                case "terminate": 
                case "stop": {
                    t.stop();
                    FindThreadCommand.sendChatToSender(ics, "Thread '" + t.getName() + "' stopped.");
                }
            }
        }
    }

    @Override
    public String getCommandString() {
        return "findthread";
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }
}

