/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Command.ReflectiveBasedCommand;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;

public class BytecodeCommand
extends ReflectiveBasedCommand {
    private static final HashMap<UUID, Stack> objectStack = new HashMap();

    public void func_71515_b(ICommandSender ics, String[] args) {
        if (args[0].equalsIgnoreCase("define")) {
            try {
                Object o;
                String cl = args[1];
                if (cl.equalsIgnoreCase("*stack*") && (o = this.getStack(ics).pop()) instanceof Class) {
                    Class c = (Class)o;
                    if (BytecodeCommand.addClassShortcut(c)) {
                        BytecodeCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "New shortcut defined for class: #" + c.getSimpleName() + " for " + c.getName());
                    } else {
                        BytecodeCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Class shortcut already defined for " + args[1]);
                    }
                    return;
                }
                Class c = this.findClass(cl);
                if (BytecodeCommand.addClassShortcut(c)) {
                    BytecodeCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "New shortcut defined for class: #" + c.getSimpleName() + " for " + c.getName());
                } else {
                    BytecodeCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Class shortcut already defined for " + args[1]);
                }
            }
            catch (ClassNotFoundException e) {
                BytecodeCommand.sendChatToSender(ics, EnumChatFormatting.RED + "No such class: " + args[1]);
            }
            return;
        }
        if (args[0].equalsIgnoreCase("look")) {
            EntityPlayerMP ep = BytecodeCommand.func_71521_c((ICommandSender)ics);
            MovingObjectPosition mov = ReikaPlayerAPI.getLookedAtBlock((EntityPlayer)ep, 4.5, false);
            if (mov != null) {
                this.getStack(ics).push(ep.field_70170_p);
                this.getStack(ics).push(mov.field_72311_b);
                this.getStack(ics).push(mov.field_72312_c);
                this.getStack(ics).push(mov.field_72309_d);
                BytecodeCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "Loaded looked position onto the stack.");
            } else {
                BytecodeCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Not looking at a block.");
            }
            return;
        }
        Opcodes o = Opcodes.valueOf(args[0].toUpperCase(Locale.ENGLISH));
        args = Arrays.copyOfRange(args, 1, args.length);
        try {
            o.call(this, ics, args, this.getStack(ics));
            if (o != Opcodes.OUTPUT) {
                Opcodes.OUTPUT.call(this, ics, null, this.getStack(ics));
            }
        }
        catch (ClassNotFoundException e) {
            this.error(ics, "No such class: " + e);
        }
        catch (NoSuchFieldException e) {
            this.error(ics, "No such field: " + e);
        }
        catch (NoSuchMethodException e) {
            this.error(ics, "No such method: " + e);
        }
        catch (IllegalArgumentException e) {
            this.error(ics, "Invalid specified type: " + e);
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            this.error(ics, "Called method threw exception: " + e);
        }
        catch (InstantiationException e) {
            this.error(ics, "Could not construct object: " + e);
        }
    }

    @Override
    protected void error(ICommandSender ics, String s) {
        super.error(ics, s);
        try {
            Opcodes.FLUSH.call(this, ics, null, this.getStack(ics));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Stack getStack(ICommandSender ics) {
        UUID id = this.getUID(ics);
        Stack s = objectStack.get(id);
        if (s == null) {
            s = new Stack();
            objectStack.put(id, s);
        }
        return s;
    }

    @Override
    public String getCommandString() {
        return "bytecodeexec";
    }

    private static enum Opcodes {
        LDC,
        NEW,
        DUP,
        POP,
        SWAP,
        INVOKESTATIC,
        INVOKEVIRTUAL,
        GETSTATIC,
        GETFIELD,
        SETFIELD,
        OUTPUT,
        FLUSH;

        private static final Opcodes[] list;

        private void call(ReflectiveBasedCommand cmd, ICommandSender ics, String[] args, Stack s) throws ClassNotFoundException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
            switch (this) {
                case FLUSH: {
                    s.clear();
                    break;
                }
                case GETFIELD: {
                    Class c = cmd.findClass(args[0]);
                    Field f = c.getDeclaredField(cmd.deSRG(c, args[1]));
                    f.setAccessible(true);
                    if (s.isEmpty()) {
                        throw new IllegalArgumentException("Operand stack underflow");
                    }
                    s.push(f.get(s.pop()));
                    break;
                }
                case SETFIELD: {
                    Class c = cmd.findClass(args[0]);
                    Field f = c.getDeclaredField(cmd.deSRG(c, args[1]));
                    f.setAccessible(true);
                    if (s.size() < 2) {
                        throw new IllegalArgumentException("Operand stack underflow");
                    }
                    Object arg = s.pop();
                    f.set(s.pop(), arg);
                    break;
                }
                case GETSTATIC: {
                    Class c = cmd.findClass(args[0]);
                    Field f = c.getDeclaredField(cmd.deSRG(c, args[1]));
                    f.setAccessible(true);
                    s.push(f.get(null));
                    break;
                }
                case INVOKESTATIC: {
                    Class c = cmd.findClass(args[0]);
                    Class[] types = cmd.parseTypes(args[2]);
                    Method m = c.getDeclaredMethod(cmd.deSRG(c, args[1]), types);
                    m.setAccessible(true);
                    Object[] vals = new Object[types.length];
                    if (vals.length > s.size()) {
                        throw new IllegalArgumentException("Operand stack underflow");
                    }
                    for (int i = vals.length - 1; i >= 0; --i) {
                        vals[i] = s.pop();
                    }
                    s.push(m.invoke(null, vals));
                    break;
                }
                case INVOKEVIRTUAL: {
                    Class c = cmd.findClass(args[0]);
                    Class[] types = cmd.parseTypes(args[2]);
                    Method m = c.getDeclaredMethod(cmd.deSRG(c, args[1]), types);
                    m.setAccessible(true);
                    Object[] vals = new Object[types.length];
                    if (vals.length + 1 > s.size()) {
                        throw new IllegalArgumentException("Operand stack underflow");
                    }
                    for (int i = vals.length - 1; i >= 0; --i) {
                        vals[i] = s.pop();
                    }
                    s.push(m.invoke(s.pop(), vals));
                    break;
                }
                case LDC: {
                    s.push(cmd.parseObject(args[0]));
                    break;
                }
                case NEW: {
                    Class c = cmd.findClass(args[0]);
                    Class[] types = cmd.parseTypes(args[1]);
                    Object[] vals = new Object[types.length];
                    if (vals.length > s.size()) {
                        throw new IllegalArgumentException("Operand stack underflow");
                    }
                    for (int i = vals.length - 1; i >= 0; --i) {
                        vals[i] = s.pop();
                    }
                    Constructor cn = c.getDeclaredConstructor(types);
                    cn.setAccessible(true);
                    Object o = cn.newInstance(args);
                    s.push(o);
                    break;
                }
                case OUTPUT: {
                    DragonCommandBase.sendChatToSender(ics, "Current stack: [");
                    for (Object o : s) {
                        DragonCommandBase.sendChatToSender(ics, cmd.toReadableString(o));
                    }
                    DragonCommandBase.sendChatToSender(ics, "]");
                    break;
                }
                case DUP: {
                    if (s.isEmpty()) {
                        throw new IllegalArgumentException("Operand stack underflow");
                    }
                    s.push(s.peek());
                    break;
                }
                case POP: {
                    if (s.isEmpty()) {
                        throw new IllegalArgumentException("Operand stack underflow");
                    }
                    s.pop();
                    break;
                }
                case SWAP: {
                    if (s.size() < 2) {
                        throw new IllegalArgumentException("Operand stack underflow");
                    }
                    Object top = s.pop();
                    Object o2 = s.pop();
                    s.push(top);
                    s.push(o2);
                    break;
                }
            }
        }

        static {
            list = Opcodes.values();
        }
    }
}

