/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.IDConflictException;
import Reika.DragonAPI.Exception.StupidIDException;
import Reika.DragonAPI.Extras.IDType;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;

public final class PotionCollisionTracker {
    private MultiMap<DragonAPIMod, Integer> IDs = new MultiMap();
    private ArrayList<DragonAPIMod> mods = new ArrayList();
    private HashMap<Integer, Class> classes = new HashMap();
    public static final PotionCollisionTracker instance = new PotionCollisionTracker();

    private PotionCollisionTracker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void addEntry(DragonAPIMod mod, int id, Class potion) {
        this.IDs.addValue(mod, id);
        this.classes.put(id, potion);
    }

    public void addPotionID(DragonAPIMod mod, int id, Class potionClass) {
        if (id < 0 || id >= Potion.field_76425_a.length) {
            throw new StupidIDException(mod, id, IDType.POTION);
        }
        Potion potion = Potion.field_76425_a[id];
        if (potion != null) {
            this.onConflict(null, id, potion.getClass(), potionClass);
        }
        if (this.classes.containsKey(id)) {
            this.onConflict(mod, id, this.classes.get(id), potionClass);
        } else {
            this.addEntry(mod, id, potionClass);
        }
    }

    public final void check() {
        for (DragonAPIMod mod : this.IDs.keySet()) {
            Collection<Integer> ids = this.IDs.get(mod);
            for (int id : ids) {
                Potion potion = Potion.field_76425_a[id];
                if (potion == null) {
                    DragonAPICore.logError("Potion ID " + id + " (" + this.classes.get(id) + ") was deleted post-registration!");
                    continue;
                }
                Class<?> c = potion.getClass();
                Class c1 = this.classes.get(id);
                if (c1 == c) continue;
                this.onConflict(mod, id, c, c1);
            }
        }
    }

    protected void onConflict(DragonAPIMod mod, int id, Class c, Class c1) {
        String s = "Potion IDs: " + Potion.field_76425_a[id] + " @ " + id + " (" + c.getSimpleName() + " & " + c1.getSimpleName() + ")";
        if (mod == null) {
            throw new IDConflictException(s);
        }
        throw new IDConflictException(mod, s);
    }
}

