/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM.Patchers;

import Reika.DragonAPI.Auxiliary.CoreModDetection;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import cpw.mods.fml.relauncher.Side;
import java.util.Locale;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public abstract class Patcher {
    public final String obfName;
    public final String deobfName;
    private static final boolean genClasses = ReikaJVMParser.isArgumentPresent("-DragonAPI_exportASM");

    public Patcher(String s) {
        this(s, s);
    }

    public Patcher(String deobf, String obf) {
        this.deobfName = deobf;
        this.obfName = obf;
    }

    public final byte[] apply(byte[] data) {
        Side s = ReikaASMHelper.getSide();
        if (!this.runsOnSide(s)) {
            ReikaASMHelper.log("Skipping " + this + " ASM handler; does not run on side " + s);
            return data;
        }
        for (int i = 0; i < CoreModDetection.list.length; ++i) {
            CoreModDetection c = CoreModDetection.list[i];
            if (!c.isInstalled() || this.runWithCoreMod(c)) continue;
            ReikaASMHelper.log("Skipping " + this + " ASM handler; not compatible with " + (Object)((Object)c));
            return data;
        }
        ClassNode cn = new ClassNode();
        ClassReader classReader = new ClassReader(data);
        classReader.accept((ClassVisitor)cn, 0);
        this.apply(cn);
        ReikaASMHelper.log("Successfully applied " + this + " ASM handler!");
        int flags = 1;
        if (this.computeFrames()) {
            flags |= 2;
        }
        ClassWriter writer = new ClassWriter(flags);
        cn.accept((ClassVisitor)writer);
        byte[] newdata = writer.toByteArray();
        if (genClasses) {
            try {
                ReikaASMHelper.writeClassFile(cn, "C:/testclass");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newdata;
    }

    protected final void log(String s) {
        ReikaASMHelper.log(s);
    }

    protected abstract void apply(ClassNode var1);

    public final boolean isEnabled() {
        String tag = "-DragonAPI_disable_ASM_" + this.name();
        return !ReikaJVMParser.isArgumentPresent(tag);
    }

    public final boolean isExceptionThrowing() {
        String tag = "-DragonAPI_silence_ASM_" + this.name();
        return !ReikaJVMParser.isArgumentPresent(tag);
    }

    public final String name() {
        return this.getClass().getSimpleName().toUpperCase(Locale.ENGLISH);
    }

    public final boolean patchesForgeCode() {
        return !this.isObfable() && (this.deobfName.startsWith("net.minecraftforge") || this.deobfName.startsWith("cpw.mods.fml"));
    }

    public final boolean patchesModCode() {
        return !this.isObfable() && !this.patchesForgeCode();
    }

    private boolean isObfable() {
        return !this.deobfName.equals(this.obfName);
    }

    public boolean runWithCoreMod(CoreModDetection c) {
        return true;
    }

    public boolean runsOnSide(Side s) {
        return true;
    }

    public final String toString() {
        return this.name() + " [" + this.deobfName + "/" + this.obfName + "]";
    }

    public boolean computeFrames() {
        return false;
    }
}

