/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.blocks.BlockPhantom;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPhantomEnergyface
extends TileEntityPhantomface
implements IEnergyHandler {
    public TileEntityPhantomEnergyface() {
        super("energyface");
        this.type = BlockPhantom.Type.ENERGYFACE;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.isBoundThingInRange() && this.getReceiver() != null ? this.getReceiver().receiveEnergy(from, maxReceive, simulate) : 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.isBoundThingInRange() && this.getProvider() != null ? this.getProvider().extractEnergy(from, maxExtract, simulate) : 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.isBoundThingInRange()) {
            if (this.getProvider() != null) {
                return this.getProvider().getEnergyStored(from);
            }
            if (this.getReceiver() != null) {
                return this.getReceiver().getEnergyStored(from);
            }
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.isBoundThingInRange()) {
            if (this.getProvider() != null) {
                return this.getProvider().getMaxEnergyStored(from);
            }
            if (this.getReceiver() != null) {
                return this.getReceiver().getMaxEnergyStored(from);
            }
        }
        return 0;
    }

    public IEnergyProvider getProvider() {
        TileEntity tile;
        if (this.boundPosition != null && (tile = this.field_145850_b.func_147438_o(this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ())) instanceof IEnergyProvider) {
            return (IEnergyProvider)tile;
        }
        return null;
    }

    public IEnergyReceiver getReceiver() {
        TileEntity tile;
        if (this.boundPosition != null && (tile = this.field_145850_b.func_147438_o(this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ())) instanceof IEnergyReceiver) {
            return (IEnergyReceiver)tile;
        }
        return null;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.isBoundThingInRange() && this.getProvider() != null) {
            this.pushEnergy(ForgeDirection.UP);
            this.pushEnergy(ForgeDirection.DOWN);
            this.pushEnergy(ForgeDirection.NORTH);
            this.pushEnergy(ForgeDirection.EAST);
            this.pushEnergy(ForgeDirection.SOUTH);
            this.pushEnergy(ForgeDirection.WEST);
        }
    }

    @Override
    public boolean isBoundThingInRange() {
        return super.isBoundThingInRange() && (this.field_145850_b.func_147438_o(this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ()) instanceof IEnergyReceiver || this.field_145850_b.func_147438_o(this.boundPosition.getX(), this.boundPosition.getY(), this.boundPosition.getZ()) instanceof IEnergyProvider);
    }

    private void pushEnergy(ForgeDirection side) {
        TileEntity tile = WorldUtil.getTileEntityFromSide(side, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (tile != null && tile instanceof IEnergyReceiver && this.getProvider().getEnergyStored(ForgeDirection.UNKNOWN) > 0 && ((IEnergyReceiver)tile).canConnectEnergy(side.getOpposite()) && this.canConnectEnergy(side)) {
            int receive = this.extractEnergy(side, Math.min(((IEnergyReceiver)tile).getMaxEnergyStored(ForgeDirection.UNKNOWN) - ((IEnergyReceiver)tile).getEnergyStored(ForgeDirection.UNKNOWN), this.getEnergyStored(ForgeDirection.UNKNOWN)), true);
            int actualReceive = ((IEnergyReceiver)tile).receiveEnergy(side.getOpposite(), receive, false);
            this.extractEnergy(side, actualReceive, false);
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        if (this.isBoundThingInRange()) {
            if (this.getProvider() != null) {
                return this.getProvider().canConnectEnergy(from);
            }
            if (this.getReceiver() != null) {
                return this.getReceiver().canConnectEnergy(from);
            }
        }
        return false;
    }
}

