/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.ellpeck.actuallyadditions.mod.tile.IEnergySaver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityItemRepairer
extends TileEntityInventoryBase
implements IEnergyReceiver,
IEnergySaver {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int ENERGY_USE = 1500;
    public EnergyStorage storage = new EnergyStorage(300000);
    public int nextRepairTick;
    private int lastEnergy;

    public TileEntityItemRepairer() {
        super(2, "repairer");
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[1] == null && TileEntityItemRepairer.canBeRepaired(this.slots[0])) {
                if (this.slots[0].func_77960_j() <= 0) {
                    this.slots[1] = this.slots[0].func_77946_l();
                    this.slots[0] = null;
                    this.nextRepairTick = 0;
                } else if (this.storage.getEnergyStored() >= 1500) {
                    ++this.nextRepairTick;
                    this.storage.extractEnergy(1500, false);
                    if (this.nextRepairTick >= 2) {
                        this.nextRepairTick = 0;
                        this.slots[0].func_77964_b(this.slots[0].func_77960_j() - 1);
                    }
                }
            } else {
                this.nextRepairTick = 0;
            }
            if (this.lastEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74768_a("NextRepairTick", this.nextRepairTick);
        super.writeSyncableNBT(compound, sync);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        this.nextRepairTick = compound.func_74762_e("NextRepairTick");
        super.readSyncableNBT(compound, sync);
        this.storage.readFromNBT(compound);
    }

    public static boolean canBeRepaired(ItemStack stack) {
        return stack != null && stack.func_77973_b().isRepairable();
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public int getItemDamageToScale(int i) {
        if (this.slots[0] != null) {
            return (this.slots[0].func_77958_k() - this.slots[0].func_77960_j()) * i / this.slots[0].func_77958_k();
        }
        return 0;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 0;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergy() {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergy(int energy) {
        this.storage.setEnergyStored(energy);
    }
}

