/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.Position;
import de.ellpeck.actuallyadditions.mod.tile.IRedstoneToggle;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBreaker
extends TileEntityInventoryBase
implements IRedstoneToggle {
    public boolean isPlacer;
    private int currentTime;
    private boolean activateOnceWithSignal;

    public TileEntityBreaker(int slots, String name) {
        super(slots, name);
    }

    public TileEntityBreaker() {
        super(9, "breaker");
        this.isPlacer = false;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!(this.field_145850_b.field_72995_K || this.isRedstonePowered || this.activateOnceWithSignal)) {
            if (this.currentTime > 0) {
                --this.currentTime;
                if (this.currentTime <= 0) {
                    this.doWork();
                }
            } else {
                this.currentTime = 15;
            }
        }
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.writeSyncableNBT(compound, sync);
        compound.func_74768_a("CurrentTime", this.currentTime);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, boolean sync) {
        super.readSyncableNBT(compound, sync);
        this.currentTime = compound.func_74762_e("CurrentTime");
    }

    private void doWork() {
        ForgeDirection sideToManipulate = ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        Position coordsBlock = WorldUtil.getCoordsFromSide(sideToManipulate, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
        if (coordsBlock != null) {
            Block blockToBreak = this.field_145850_b.func_147439_a(coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ());
            if (!this.isPlacer && blockToBreak != null && !(blockToBreak instanceof BlockAir) && blockToBreak.func_149712_f(this.field_145850_b, coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ()) > -1.0f) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                int meta = this.field_145850_b.func_72805_g(coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ());
                drops.addAll(blockToBreak.getDrops(this.field_145850_b, coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ(), meta, 0));
                if (WorldUtil.addToInventory((IInventory)this, drops, false)) {
                    this.field_145850_b.func_72926_e(2001, coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ(), Block.func_149682_b((Block)blockToBreak) + (meta << 12));
                    WorldUtil.breakBlockAtSide(sideToManipulate, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    WorldUtil.addToInventory((IInventory)this, drops, true);
                    this.func_70296_d();
                }
            } else if (this.isPlacer && this.field_145850_b.func_147439_a(coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ()).isReplaceable((IBlockAccess)this.field_145850_b, coordsBlock.getX(), coordsBlock.getY(), coordsBlock.getZ())) {
                int theSlot = WorldUtil.findFirstFilledSlot(this.slots);
                this.func_70299_a(theSlot, WorldUtil.placeBlockAtSide(sideToManipulate, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.slots[theSlot]));
                if (this.slots[theSlot] != null && this.slots[theSlot].field_77994_a <= 0) {
                    this.slots[theSlot] = null;
                }
            }
        }
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return this.isPlacer;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    @Override
    public void toggle(boolean to) {
        this.activateOnceWithSignal = to;
    }

    @Override
    public boolean isPulseMode() {
        return this.activateOnceWithSignal;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    public static class TileEntityPlacer
    extends TileEntityBreaker {
        public TileEntityPlacer() {
            super(9, "placer");
            this.isPlacer = true;
        }
    }
}

