/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.metalists.TheMiscBlocks;
import de.ellpeck.actuallyadditions.mod.config.ConfigValues;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class OreGen
implements IWorldGenerator {
    public static final int QUARTZ_MIN = 0;
    public static final int QUARTZ_MAX = 45;

    public static void init() {
        ModUtil.LOGGER.info("Registering World Generator...");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGen(), (int)10);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76577_b != WorldType.field_77138_c && Util.arrayContains(ConfigValues.oreGenDimensionBlacklist, world.field_73011_w.field_76574_g) < 0) {
            switch (world.field_73011_w.field_76574_g) {
                case -1: {
                    this.generateNether(world, random, chunkX * 16, chunkZ * 16);
                }
                case 1: {
                    this.generateEnd(world, random, chunkX * 16, chunkZ * 16);
                }
            }
            this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    private void generateNether(World world, Random random, int x, int z) {
    }

    private void generateEnd(World world, Random random, int x, int z) {
    }

    private void generateSurface(World world, Random random, int x, int z) {
        if (ConfigBoolValues.GENERATE_QUARTZ.isEnabled()) {
            this.addOreSpawn(InitBlocks.blockMisc, TheMiscBlocks.ORE_QUARTZ.ordinal(), Blocks.field_150348_b, world, random, x, z, MathHelper.func_76136_a((Random)random, (int)5, (int)8), 10, 0, 45);
        }
    }

    public void addOreSpawn(Block block, int meta, Block blockIn, World world, Random random, int blockXPos, int blockZPos, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        if (maxY > minY) {
            int yDiff = maxY - minY;
            for (int i = 0; i < chancesToSpawn; ++i) {
                int posX = blockXPos + random.nextInt(16);
                int posY = minY + random.nextInt(yDiff);
                int posZ = blockZPos + random.nextInt(16);
                new WorldGenMinable(block, meta, maxVeinSize, blockIn).func_76484_a(world, random, posX, posY, posZ);
            }
        } else {
            ModUtil.LOGGER.fatal("Couldn't generate '" + block.func_149739_a() + "' into the world because the Min Y coordinate is bigger than the Max! This is definitely a Config Error! Check the Files!");
        }
    }
}

