/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IFacadePluggable;
import buildcraft.core.lib.render.FakeBlock;
import buildcraft.core.lib.render.TextureStateManager;
import buildcraft.core.lib.utils.MatrixTranformations;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.render.FacadeBlockAccess;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public final class FacadeRenderHelper {
    private static final float zFightOffset = 2.4414062E-4f;
    private static final float[][] zeroStateFacade = new float[3][2];
    private static final float[][] zeroStateSupport = new float[3][2];
    private static final float[] xOffsets = new float[6];
    private static final float[] yOffsets = new float[6];
    private static final float[] zOffsets = new float[6];

    private FacadeRenderHelper() {
    }

    private static void setRenderBounds(RenderBlocks renderblocks, float[][] rotated, ForgeDirection side) {
        renderblocks.func_147782_a((double)(rotated[0][0] + xOffsets[side.ordinal()]), (double)(rotated[1][0] + yOffsets[side.ordinal()]), (double)(rotated[2][0] + zOffsets[side.ordinal()]), (double)(rotated[0][1] - xOffsets[side.ordinal()]), (double)(rotated[1][1] - yOffsets[side.ordinal()]), (double)(rotated[2][1] - zOffsets[side.ordinal()]));
    }

    public static void pipeFacadeRenderer(RenderBlocks renderblocks, ITextureStates blockStateMachine, IPipeTile tile, int renderPass, int x, int y, int z, ForgeDirection direction, IFacadePluggable pluggable) {
        ITextureStates textureManager = blockStateMachine;
        IIcon[] textures = ((TextureStateManager)textureManager.getTextureState()).popArray();
        Block renderBlock = pluggable.getCurrentBlock();
        if (renderBlock != null && tile != null) {
            FacadeBlockAccess facadeBlockAccess = new FacadeBlockAccess((IBlockAccess)tile.getWorld(), direction);
            if (renderBlock.canRenderInPass(renderPass)) {
                float[][] rotated;
                int renderMeta = pluggable.getCurrentMetadata();
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    textures[side.ordinal()] = renderBlock.func_149673_e((IBlockAccess)facadeBlockAccess, tile.x(), tile.y(), tile.z(), side.ordinal());
                    if (textures[side.ordinal()] == null) {
                        textures[side.ordinal()] = renderBlock.func_149691_a(side.ordinal(), renderMeta);
                    }
                    if (side == direction || side == direction.getOpposite()) {
                        blockStateMachine.setRenderSide(side, true);
                        continue;
                    }
                    if (!(tile.getPipePluggable(side) instanceof IFacadePluggable)) {
                        blockStateMachine.setRenderSide(side, true);
                        continue;
                    }
                    IFacadePluggable pluggable2 = (IFacadePluggable)((Object)tile.getPipePluggable(side));
                    blockStateMachine.setRenderSide(side, pluggable2.getCurrentBlock() == null);
                }
                if (renderBlock.func_149645_b() == 31) {
                    if ((renderMeta & 0xC) == 4) {
                        renderblocks.field_147875_q = 1;
                        renderblocks.field_147873_r = 1;
                        renderblocks.field_147867_u = 1;
                        renderblocks.field_147865_v = 1;
                    } else if ((renderMeta & 0xC) == 8) {
                        renderblocks.field_147871_s = 1;
                        renderblocks.field_147869_t = 1;
                    }
                }
                ((FakeBlock)blockStateMachine.getBlock()).setColor(renderBlock.func_149741_i(renderMeta));
                if (pluggable.isHollow()) {
                    renderblocks.field_152631_f = true;
                    rotated = MatrixTranformations.deepClone(zeroStateFacade);
                    rotated[0][0] = 0.24902344f;
                    rotated[0][1] = 0.75097656f;
                    rotated[2][0] = 0.0f;
                    rotated[2][1] = 0.24951172f;
                    MatrixTranformations.transform(rotated, direction);
                    FacadeRenderHelper.setRenderBounds(renderblocks, rotated, direction);
                    renderblocks.func_147736_d(blockStateMachine.getBlock(), x, y, z, 1.0f, 1.0f, 1.0f);
                    rotated = MatrixTranformations.deepClone(zeroStateFacade);
                    rotated[0][0] = 0.24902344f;
                    rotated[0][1] = 0.75097656f;
                    rotated[2][0] = 0.7504883f;
                    MatrixTranformations.transform(rotated, direction);
                    FacadeRenderHelper.setRenderBounds(renderblocks, rotated, direction);
                    renderblocks.func_147736_d(blockStateMachine.getBlock(), x, y, z, 1.0f, 1.0f, 1.0f);
                    rotated = MatrixTranformations.deepClone(zeroStateFacade);
                    rotated[0][0] = 0.0f;
                    rotated[0][1] = 0.24951172f;
                    MatrixTranformations.transform(rotated, direction);
                    FacadeRenderHelper.setRenderBounds(renderblocks, rotated, direction);
                    renderblocks.func_147736_d(blockStateMachine.getBlock(), x, y, z, 1.0f, 1.0f, 1.0f);
                    rotated = MatrixTranformations.deepClone(zeroStateFacade);
                    rotated[0][0] = 0.7504883f;
                    rotated[0][1] = 1.0f;
                    MatrixTranformations.transform(rotated, direction);
                    FacadeRenderHelper.setRenderBounds(renderblocks, rotated, direction);
                    renderblocks.func_147736_d(blockStateMachine.getBlock(), x, y, z, 1.0f, 1.0f, 1.0f);
                    renderblocks.field_152631_f = false;
                } else {
                    rotated = MatrixTranformations.deepClone(zeroStateFacade);
                    MatrixTranformations.transform(rotated, direction);
                    FacadeRenderHelper.setRenderBounds(renderblocks, rotated, direction);
                    renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
                }
                ((FakeBlock)blockStateMachine.getBlock()).setColor(0xFFFFFF);
                if (renderBlock.func_149645_b() == 31) {
                    renderblocks.field_147871_s = 0;
                    renderblocks.field_147875_q = 0;
                    renderblocks.field_147873_r = 0;
                    renderblocks.field_147869_t = 0;
                    renderblocks.field_147867_u = 0;
                    renderblocks.field_147865_v = 0;
                }
            }
        }
        ((FakeBlock)blockStateMachine.getBlock()).setColor(0xFFFFFF);
        ((TextureStateManager)textureManager.getTextureState()).pushArray();
        blockStateMachine.setRenderAllSides();
        textureManager.getTextureState().set(BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal()));
        if (renderPass == 0 && !pluggable.isHollow() && renderBlock.func_149688_o().func_76218_k()) {
            float[][] rotated = MatrixTranformations.deepClone(zeroStateSupport);
            MatrixTranformations.transform(rotated, direction);
            renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
            renderblocks.func_147784_q(blockStateMachine.getBlock(), x, y, z);
        }
    }

    static {
        FacadeRenderHelper.zeroStateFacade[0][0] = 0.0f;
        FacadeRenderHelper.zeroStateFacade[0][1] = 1.0f;
        FacadeRenderHelper.zeroStateFacade[1][0] = 0.0f;
        FacadeRenderHelper.zeroStateFacade[1][1] = 0.125f;
        FacadeRenderHelper.zeroStateFacade[2][0] = 0.0f;
        FacadeRenderHelper.zeroStateFacade[2][1] = 1.0f;
        FacadeRenderHelper.zeroStateSupport[0][0] = 0.25f;
        FacadeRenderHelper.zeroStateSupport[0][1] = 0.75f;
        FacadeRenderHelper.zeroStateSupport[1][0] = 0.125f;
        FacadeRenderHelper.zeroStateSupport[1][1] = 0.25f;
        FacadeRenderHelper.zeroStateSupport[2][0] = 0.25f;
        FacadeRenderHelper.zeroStateSupport[2][1] = 0.75f;
        FacadeRenderHelper.xOffsets[0] = 2.4414062E-4f;
        FacadeRenderHelper.xOffsets[1] = 2.4414062E-4f;
        FacadeRenderHelper.xOffsets[2] = 0.0f;
        FacadeRenderHelper.xOffsets[3] = 0.0f;
        FacadeRenderHelper.xOffsets[4] = 0.0f;
        FacadeRenderHelper.xOffsets[5] = 0.0f;
        FacadeRenderHelper.yOffsets[0] = 0.0f;
        FacadeRenderHelper.yOffsets[1] = 0.0f;
        FacadeRenderHelper.yOffsets[2] = 2.4414062E-4f;
        FacadeRenderHelper.yOffsets[3] = 2.4414062E-4f;
        FacadeRenderHelper.yOffsets[4] = 0.0f;
        FacadeRenderHelper.yOffsets[5] = 0.0f;
        FacadeRenderHelper.zOffsets[0] = 2.4414062E-4f;
        FacadeRenderHelper.zOffsets[1] = 2.4414062E-4f;
        FacadeRenderHelper.zOffsets[2] = 0.0f;
        FacadeRenderHelper.zOffsets[3] = 0.0f;
        FacadeRenderHelper.zOffsets[4] = 0.0f;
        FacadeRenderHelper.zOffsets[5] = 0.0f;
    }
}

