/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.urbanism;

import buildcraft.builders.urbanism.ContainerUrbanist;
import buildcraft.builders.urbanism.TileUrbanist;
import buildcraft.builders.urbanism.UrbanistTool;
import buildcraft.builders.urbanism.UrbanistToolArea;
import buildcraft.builders.urbanism.UrbanistToolBlock;
import buildcraft.builders.urbanism.UrbanistToolBlueprint;
import buildcraft.builders.urbanism.UrbanistToolErase;
import buildcraft.builders.urbanism.UrbanistToolFiller;
import buildcraft.builders.urbanism.UrbanistToolPath;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiUrbanist
extends GuiAdvancedInterface {
    private static final ResourceLocation TOOLBAR_TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/urbanist_tools.png");
    private static final int TOOLBAR_TEXTURE_WIDTH = 194;
    private static final int TOOLBAR_TEXTURE_HEIGHT = 27;
    public TileUrbanist urbanist;
    public UrbanistTool[] tools = new UrbanistTool[10];
    private int selectedTool = -1;

    public GuiUrbanist(IInventory playerInventory, TileUrbanist urbanist) {
        super(new ContainerUrbanist(playerInventory, urbanist), (IInventory)urbanist, TOOLBAR_TEXTURE);
        this.field_146999_f = this.field_146294_l;
        this.field_147000_g = this.field_146295_m;
        this.urbanist = urbanist;
        urbanist.createUrbanistEntity();
        this.tools[0] = new UrbanistToolBlock();
        this.tools[1] = new UrbanistToolErase();
        this.tools[2] = new UrbanistToolArea();
        this.tools[3] = new UrbanistToolPath();
        this.tools[4] = new UrbanistToolFiller();
        this.tools[5] = new UrbanistToolBlueprint();
        this.tools[6] = new UrbanistTool();
        this.tools[7] = new UrbanistTool();
        this.tools[8] = new UrbanistTool();
        this.tools[9] = new UrbanistTool();
        for (int i = 0; i < 10; ++i) {
            this.slots.add(new ToolSlot(this.tools[i]));
        }
        for (UrbanistTool t : this.tools) {
            t.createSlots(this, this.slots);
        }
    }

    public void func_146276_q_() {
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float par3) {
        this.field_146999_f = this.field_146294_l;
        this.field_147000_g = this.field_146295_m;
        this.field_147003_i = 0;
        this.field_147009_r = 0;
        super.func_73863_a(mouseX, mouseY, par3);
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        this.drawTooltipForSlotAt(par1, par2);
        if (this.selectedTool != -1) {
            this.tools[this.selectedTool].drawGuiContainerForegroundLayer(this, par1, par2);
        }
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int cornerX = (this.field_146294_l - 194) / 2;
        int cornerY = this.field_146295_m - 27;
        this.field_146297_k.field_71446_o.func_110577_a(TOOLBAR_TEXTURE);
        this.func_73729_b(cornerX, cornerY, 0, 0, 194, 27);
        for (int i = 0; i < 10; ++i) {
            ((AdvancedSlot)this.slots.get((int)i)).x = cornerX + 8 + i * 18;
            ((AdvancedSlot)this.slots.get((int)i)).y = cornerY + 8;
        }
        if (this.selectedTool != -1) {
            this.tools[this.selectedTool].drawGuiContainerBackgroundLayer(this, f, x, y);
        }
        this.drawBackgroundSlots();
        if (this.selectedTool != -1) {
            this.tools[this.selectedTool].drawSelection(this, f, x, y);
        }
        if (this.selectedTool != -1) {
            this.field_146297_k.field_71446_o.func_110577_a(TOOLBAR_TEXTURE);
            this.func_73729_b(cornerX + 8 + this.selectedTool * 18, cornerY + 8, 194, 0, 18, 18);
        }
    }

    public void func_146281_b() {
        this.urbanist.destroyUrbanistEntity();
    }

    private boolean onInterface(int mouseX, int mouseY) {
        int cornerX = (this.field_146294_l - 194) / 2;
        int cornerY = this.field_146295_m - 27;
        if (mouseX >= cornerX && mouseX <= cornerX + 194 && mouseY >= cornerY && mouseY <= cornerY + 27) {
            return true;
        }
        return this.selectedTool != -1 && this.tools[this.selectedTool].onInterface(mouseX, mouseY);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (!this.onInterface(mouseX, mouseY)) {
            if (this.selectedTool != -1) {
                this.tools[this.selectedTool].worldClicked(this, this.urbanist.urbanist.rayTraceMouse());
            }
            return;
        }
        int clicked = this.getSlotIndexAtLocation(mouseX, mouseY);
        if (clicked != -1 && clicked < 10 && clicked != this.selectedTool) {
            if (this.selectedTool != -1) {
                this.tools[this.selectedTool].hide();
            }
            this.selectedTool = clicked;
            this.tools[this.selectedTool].show();
        }
        if (clicked != -1) {
            ((AdvancedSlot)this.slots.get(clicked)).selected();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146274_d() {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (this.onInterface(x, y)) {
            return;
        }
        if (this.selectedTool != -1) {
            this.tools[this.selectedTool].worldMoved(this, this.urbanist.urbanist.rayTraceMouse());
        }
    }

    class ToolSlot
    extends AdvancedSlot {
        UrbanistTool tool;

        public ToolSlot(UrbanistTool tool) {
            super(GuiUrbanist.this, 0, 0);
            this.tool = tool;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public IIcon getIcon() {
            return this.tool.getIcon();
        }

        @Override
        public String getDescription() {
            return this.tool.getDescription();
        }
    }
}

