/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.pressure.IExplodable;
import com.cout970.magneticraft.api.pressure.IPressureConductor;
import com.cout970.magneticraft.api.pressure.PressureUtils;
import com.cout970.magneticraft.api.pressure.prefab.PressureConductor;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.util.CubeRenderer_Util;
import com.cout970.magneticraft.util.tile.TilePressure;
import net.minecraft.init.Blocks;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TilePressureTank
extends TilePressure
implements IFluidHandler,
IExplodable {
    public CubeRenderer_Util cubeRenderer;

    @Override
    public IPressureConductor initConductor() {
        return new PressureConductor(this, 16000.0);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.pressure.getPressure() > this.pressure.getMaxPressure()) {
            this.explode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void explode(World world, int x, int y, int z, boolean explodeNeighbors) {
        if (!world.field_72995_K) {
            this.pressure.onBlockExplode();
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            if (explodeNeighbors) {
                for (MgDirection dir : MgDirection.values()) {
                    VecInt pos = new VecInt(this).add(dir);
                    IExplodable exp = PressureUtils.getExplodable(world, pos);
                    if (exp == null) continue;
                    exp.explode(world, pos.getX(), pos.getY(), pos.getZ(), true);
                }
            }
            Explosion e = world.func_72876_a(null, (double)x, (double)y, (double)z, 1.0f, true);
            e.func_77278_a();
        }
    }

    public int fill(ForgeDirection from, FluidStack gas, boolean doFill) {
        return this.pressure.applyGas(gas, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.pressure.drainGas(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.pressure.getFluid() == null || this.pressure.getFluid().equals(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.pressure.getFluid() != null && this.pressure.getFluid() == fluid;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }
}

