/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.compat.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.cout970.magneticraft.api.access.MgRecipeRegister;
import com.cout970.magneticraft.api.access.RecipePolymerizer;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.util.RenderUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class CraftingPolymerizer
extends TemplateRecipeHandler {
    public List<RecipePolymerizer> recipes = new ArrayList<RecipePolymerizer>();
    private static ResourceLocation tank = new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/tank.png");
    private static ResourceLocation heat = new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/heatbar.png");

    public String getRecipeName() {
        return "Polymerizer";
    }

    public String getGuiTexture() {
        return "magneticraft:textures/gui/nei/polimerizer.png";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(68, 21, 24, 15), this.getRecipesID(), new Object[0]));
    }

    private String getRecipesID() {
        return "mg_polymerizer";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadCraftingRecipes(ItemStack result) {
        this.recipes.addAll(MgRecipeRegister.polymerizer.stream().filter(rec -> rec != null && MgUtils.areEqual(result, rec.getOutput(), true)).collect(Collectors.toList()));
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        this.recipes.addAll(MgRecipeRegister.polymerizer.stream().filter(rec -> rec != null && MgUtils.areEqual(ingredient, rec.getInput(), true)).collect(Collectors.toList()));
    }

    public PositionedStack getResultStack(int recipe) {
        return new PositionedStack((Object)this.recipes.get(recipe).getOutput(), 119, 25);
    }

    public List<PositionedStack> getOtherStacks(int recipe) {
        return new ArrayList<PositionedStack>();
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        ArrayList<PositionedStack> need = new ArrayList<PositionedStack>();
        need.add(new PositionedStack((Object)this.recipes.get(recipe).getInput(), 63, 25));
        return need;
    }

    public int numRecipes() {
        return this.recipes.size();
    }

    public void drawExtras(int recipe) {
        RecipePolymerizer rec = this.recipes.get(recipe);
        RenderUtil.drawString(rec.getFluid().getLocalizedName(), 45, 60, RenderUtil.fromRGB(255, 255, 255), true);
        RenderUtil.bindTexture(TextureMap.field_110575_b);
        this.drawTexturedModelRectFromIcon(36, 14, rec.getFluid().getFluid().getIcon(), 18, 39);
        RenderUtil.bindTexture(tank);
        RenderUtil.drawTexturedModalRectScaled(35, 13, 0, 0, 18, 39, 20, 41);
        RenderUtil.bindTexture(heat);
        int scale = Math.min(44, (int)(rec.getTemperature() * 44.0 / 1400.0));
        RenderUtil.drawTexturedModalRectScaled(15, 9 + (44 - scale), 0, 44 - scale, 6, scale, 12, 45);
    }

    public void drawTexturedModelRectFromIcon(int p_94065_1_, int p_94065_2_, IIcon p_94065_3_, int p_94065_4_, int p_94065_5_) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)p_94065_1_, (double)(p_94065_2_ + p_94065_5_), 0.0, (double)p_94065_3_.func_94209_e(), (double)p_94065_3_.func_94210_h());
        tessellator.func_78374_a((double)(p_94065_1_ + p_94065_4_), (double)(p_94065_2_ + p_94065_5_), 0.0, (double)p_94065_3_.func_94212_f(), (double)p_94065_3_.func_94210_h());
        tessellator.func_78374_a((double)(p_94065_1_ + p_94065_4_), (double)p_94065_2_, 0.0, (double)p_94065_3_.func_94212_f(), (double)p_94065_3_.func_94206_g());
        tessellator.func_78374_a((double)p_94065_1_, (double)p_94065_2_, 0.0, (double)p_94065_3_.func_94209_e(), (double)p_94065_3_.func_94206_g());
        tessellator.func_78381_a();
    }
}

