/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab;

import cofh.api.energy.IEnergyHandler;
import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.framework.energy.data.EnergyBuffer;
import com.builtbroken.mc.prefab.tile.TileModuleMachine;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileICBMMachine
extends TileModuleMachine
implements IEnergyHandler {
    protected boolean updateClient = false;

    public TileICBMMachine(String name, Material material) {
        super(name, material);
    }

    public void update() {
        super.update();
        this.doUpdateGuiUsers();
    }

    public void doUpdateGuiUsers() {
        if (this.isServer()) {
            PacketTile packet;
            if (this.updateClient) {
                this.updateClient = false;
                this.sendDescPacket();
            }
            if (this.ticks % 3L == 0L && (packet = this.getGUIPacket()) != null) {
                this.sendPacketToGuiUsers((IPacket)packet);
            }
        }
    }

    protected PacketTile getGUIPacket() {
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
    }

    protected boolean useMetaForFacing() {
        return true;
    }

    public int getEnergy() {
        EnergyBuffer buffer = this.getEnergyBuffer(ForgeDirection.UNKNOWN);
        if (buffer != null) {
            return buffer.getEnergyStored();
        }
        return 0;
    }

    public void setEnergy(int energy) {
        EnergyBuffer buffer = this.getEnergyBuffer(ForgeDirection.UNKNOWN);
        if (buffer != null) {
            buffer.setEnergyStored(energy);
        }
    }

    public void extractEnergy() {
        EnergyBuffer buffer = this.getEnergyBuffer(ForgeDirection.UNKNOWN);
        if (buffer != null) {
            buffer.removeEnergyFromStorage(this.getEnergyConsumption(), true);
        }
    }

    public boolean checkExtract() {
        return this.getEnergy() >= this.getEnergyConsumption();
    }

    public int getEnergyConsumption() {
        return 10000;
    }

    public int getEnergyBufferSize() {
        return this.getEnergyConsumption() * 2;
    }

    public boolean hasPower() {
        return this.getEnergy() > 0;
    }
}

