/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.ex.missiles;

import com.builtbroken.jlib.data.vector.IPos2D;
import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.imp.transform.vector.Pos;
import icbm.classic.content.entity.EntityMissile;
import icbm.classic.content.explosive.blast.BlastTNT;
import icbm.classic.content.explosive.ex.missiles.Missile;
import icbm.classic.content.items.ItemTracker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class MissileHoming
extends Missile {
    public MissileHoming() {
        super("homing", 1);
        this.hasBlock = false;
        this.missileModelPath = "missiles/tier1/missile_head_homing.obj";
    }

    @Override
    public void launch(EntityMissile missileObj) {
        WorldServer worldServer;
        Entity trackingEntity;
        if (!missileObj.field_70170_p.field_72995_K && (trackingEntity = (worldServer = (WorldServer)missileObj.field_70170_p).func_73045_a(missileObj.trackingVar)) != null) {
            if (trackingEntity == missileObj) {
                missileObj.setExplode();
            }
            missileObj.targetVector = new Pos(trackingEntity);
        }
    }

    @Override
    public void update(EntityMissile missileObj) {
        World world;
        Entity trackingEntity;
        if ((float)missileObj.getTicksInAir() > missileObj.missileFlightTime / 2.0f && missileObj.missileType == EntityMissile.MissileType.MISSILE && (trackingEntity = (world = missileObj.field_70170_p).func_73045_a(missileObj.trackingVar)) != null) {
            if (trackingEntity.equals((Object)missileObj)) {
                missileObj.setExplode();
            }
            missileObj.targetVector = new Pos(trackingEntity);
            missileObj.missileType = EntityMissile.MissileType.CruiseMissile;
            missileObj.deltaPathX = missileObj.targetVector.x() - missileObj.field_70165_t;
            missileObj.deltaPathY = missileObj.targetVector.y() - missileObj.field_70163_u;
            missileObj.deltaPathZ = missileObj.targetVector.z() - missileObj.field_70161_v;
            missileObj.flatDistance = missileObj.sourceOfProjectile.toVector2().distance((IPos2D)missileObj.targetVector.toVector2());
            missileObj.maxHeight = 150 + (int)(missileObj.flatDistance * 1.8);
            missileObj.missileFlightTime = (float)Math.max(100.0, 2.4 * missileObj.flatDistance);
            missileObj.acceleration = (float)missileObj.maxHeight * 2.0f / (missileObj.missileFlightTime * missileObj.missileFlightTime);
            if (missileObj.xiaoDanMotion.equals((Object)new Pos()) || missileObj.xiaoDanMotion == null) {
                float suDu = 0.3f;
                missileObj.xiaoDanMotion = new Pos(missileObj.deltaPathX / (double)(missileObj.missileFlightTime * suDu), missileObj.deltaPathY / (double)(missileObj.missileFlightTime * suDu), missileObj.deltaPathZ / (double)(missileObj.missileFlightTime * suDu));
            }
        }
    }

    @Override
    public boolean onInteract(EntityMissile missileObj, EntityPlayer entityPlayer) {
        Entity trackingEntity;
        if (!missileObj.field_70170_p.field_72995_K && missileObj.getTicksInAir() <= 0 && entityPlayer.func_71045_bC() != null && entityPlayer.func_71045_bC().func_77973_b() instanceof ItemTracker && (trackingEntity = ((ItemTracker)entityPlayer.func_71045_bC().func_77973_b()).getTrackingEntity(missileObj.field_70170_p, entityPlayer.func_71045_bC())) != null && missileObj.trackingVar != trackingEntity.func_145782_y()) {
            missileObj.trackingVar = trackingEntity.func_145782_y();
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Missile target locked to: " + trackingEntity.func_70005_c_()));
            if (missileObj.getLauncher() != null && missileObj.getLauncher().getController() != null) {
                Pos newTarget = new Pos(trackingEntity.field_70165_t, 0.0, trackingEntity.field_70161_v);
                missileObj.getLauncher().getController().setTarget(newTarget);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCruise() {
        return false;
    }

    @Override
    public void doCreateExplosion(World world, double x, double y, double z, Entity entity) {
        new BlastTNT(world, entity, x, y, z, 4.0f).setDestroyItems().explode();
    }

    public IWorldChangeAction createBlastForTrigger(World world, double x, double y, double z, TriggerCause triggerCause, double size, NBTTagCompound tag) {
        return null;
    }
}

