/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.explosive.blast;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.entity.EntityLightBeam;
import icbm.classic.content.explosive.blast.Blast;
import icbm.classic.content.explosive.thread.ThreadExplosion;
import icbm.classic.content.explosive.thread.ThreadSky;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlastBeam
extends Blast {
    protected ThreadExplosion thread;
    protected Set<EntityFlyingBlock> feiBlocks = new HashSet<EntityFlyingBlock>();
    protected EntityLightBeam lightBeam;
    protected float red;
    protected float green;
    protected float blue;
    protected int radius = 5;

    public BlastBeam(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    @Override
    public void doPreExplode() {
        if (!this.oldWorld().field_72995_K) {
            this.oldWorld().func_72876_a(this.field_77283_e, this.position.x(), this.position.y(), this.position.z(), 4.0f, true);
            this.lightBeam = new EntityLightBeam(this.oldWorld(), (IPos3D)this.position, 400, this.red, this.green, this.blue);
            this.oldWorld().func_72838_d((Entity)this.lightBeam);
            this.thread = new ThreadSky((IWorldPosition)this.position, (int)this.getRadius(), 50.0f, this.field_77283_e);
            this.thread.start();
        }
    }

    @Override
    public void doExplode() {
        if (!this.oldWorld().field_72995_K) {
            if (this.callCount > 100 / this.proceduralInterval() && this.thread.isComplete) {
                this.controller.endExplosion();
            }
            if (this.canFocusBeam(this.oldWorld(), this.position)) {
                int r = this.radius;
                for (int x = -r; x < r; ++x) {
                    for (int y = -r; y < r; ++y) {
                        for (int z = -r; z < r; ++z) {
                            Pos currentPos;
                            Block block;
                            double dist = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
                            if (dist > (double)r || dist < (double)(r - 3) || (block = (currentPos = new Pos(this.position.x() + (double)x, this.position.y() + (double)y, this.position.z() + (double)z)).getBlock((IBlockAccess)this.oldWorld())) == null || block.isAir((IBlockAccess)this.oldWorld(), x, y, z) || block.func_149712_f(this.oldWorld(), x, y, x) < 0.0f) continue;
                            int metadata = this.oldWorld().func_72805_g(currentPos.xi(), currentPos.yi(), currentPos.zi());
                            if (this.oldWorld().field_73012_v.nextInt(2) <= 0) continue;
                            this.oldWorld().func_147468_f(currentPos.xi(), currentPos.yi(), currentPos.zi());
                            currentPos = (Pos)currentPos.add(0.5);
                            EntityFlyingBlock entity = new EntityFlyingBlock(this.oldWorld(), (IPos3D)currentPos, block, metadata);
                            this.oldWorld().func_72838_d((Entity)entity);
                            this.feiBlocks.add(entity);
                            entity.pitchChange = 50.0f * this.oldWorld().field_73012_v.nextFloat();
                        }
                    }
                }
            } else {
                this.controller.endExplosion();
            }
            for (EntityFlyingBlock entity : this.feiBlocks) {
                Pos entityPosition = new Pos((Entity)entity);
                Pos centeredPosition = (Pos)entityPosition.add((IPos3D)this.position.multiply(-1.0));
                centeredPosition.rotate(2.0);
                Location newPosition = (Location)this.position.add((IPos3D)centeredPosition);
                entity.field_70159_w /= 3.0;
                entity.field_70181_x /= 3.0;
                entity.field_70179_y /= 3.0;
                entity.func_70024_g((newPosition.x() - entityPosition.x()) * 0.5 * (double)this.proceduralInterval(), 0.09 * (double)this.proceduralInterval(), (newPosition.z() - entityPosition.z()) * 0.5 * (double)this.proceduralInterval());
                entity.yawChange += 3.0f * this.oldWorld().field_73012_v.nextFloat();
            }
        }
    }

    @Override
    public void doPostExplode() {
        if (!this.oldWorld().field_72995_K && this.lightBeam != null) {
            this.lightBeam.func_70106_y();
            this.lightBeam = null;
        }
    }

    public boolean canFocusBeam(World worldObj, Location position) {
        return worldObj.func_72937_j(position.xi(), position.yi() + 1, position.zi());
    }

    @Override
    public int proceduralInterval() {
        return 4;
    }

    @Override
    public long getEnergy() {
        return 10000L;
    }
}

