/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.World;

import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.ReikaPotionHelper;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerLiquidReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.PacketRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityDefoliator
extends InventoriedPowerLiquidReceiver
implements RangedEffect {
    public static final int CAPACITY = 4000;

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    public int getPoisonScaled(int i) {
        return this.tank.getLevel() * i / 4000;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        if (world.field_72995_K) {
            return;
        }
        this.consumePotions();
        if (!this.tank.isEmpty()) {
            int r = this.getRange();
            int n = this.getNumberPasses();
            for (int i = 0; i < n && !this.tank.isEmpty(); ++i) {
                int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)r);
                int ry = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)r);
                int rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)r);
                this.decay(world, rx, ry, rz);
            }
        }
    }

    private int getNumberPasses() {
        if (this.power < this.MINPOWER) {
            return 0;
        }
        return 2 * (int)Math.sqrt(this.omega);
    }

    private void consumePotions() {
        if (this.inv[0] != null && this.tank.canTakeIn(1000) && this.func_94041_b(0, this.inv[0])) {
            this.tank.addLiquid(1000, FluidRegistry.getFluid((String)"poison"));
            ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
            ReikaInventoryHelper.addOrSetStack((Item)Items.field_151069_bo, (int)1, (int)0, (ItemStack[])this.inv, (int)1);
        }
    }

    private void decay(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!world.field_72995_K && !ReikaPlayerAPI.playerCanBreakAt((WorldServer)((WorldServer)this.field_145850_b), (int)x, (int)y, (int)z, (Block)id, (int)meta, (EntityPlayerMP)this.getServerPlacer())) {
            return;
        }
        boolean flag = false;
        if (id != Blocks.field_150350_a) {
            Material mat = id.func_149688_o();
            if (mat == Material.field_151584_j) {
                flag = true;
            } else if (mat == Material.field_151585_k || mat == Material.field_151582_l || mat == Material.field_151570_A) {
                flag = true;
            } else if (id == Blocks.field_150364_r) {
                flag = true;
            } else if (id == Blocks.field_150363_s) {
                flag = true;
            } else if (id == Blocks.field_150345_g) {
                flag = true;
            } else if (ModWoodList.isModWood((Block)id, (int)meta)) {
                flag = true;
            } else if (ModWoodList.isModLeaf((Block)id, (int)meta)) {
                flag = true;
            } else if (ModWoodList.isModSapling((Block)id, (int)meta)) {
                flag = true;
            }
            if (flag) {
                ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)id);
                ArrayList li = id.getDrops(world, x, y, z, meta, 0);
                world.func_147468_f(x, y, z);
                ReikaItemHelper.dropItems((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (Collection)li);
                AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b(3.0, 3.0, 3.0);
                List li2 = world.func_72872_a(EntityLivingBase.class, box);
                for (EntityLivingBase e : li2) {
                    e.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 50, 3));
                    e.func_70097_a(DamageSource.field_76377_j, 0.5f);
                }
                if (world.func_72904_c(x, y, z, x, y, z)) {
                    ReikaPacketHelper.sendDataPacket((String)"RotaryCraftData", (int)PacketRegistry.DEFOLIATOR.getMinValue(), (TileEntity)this, (int)x, (int)y, (int)z);
                }
                this.tank.removeLiquid(1);
            }
        }
    }

    public void onBlockBreak(World world, int x, int y, int z) {
        int r = 3;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    ReikaParticleHelper.spawnColoredParticlesWithOutset((World)world, (int)(x + i), (int)(y + j), (int)(z + k), (double)0.0, (double)20.0, (double)0.0, (int)1, (double)2.0);
                }
            }
        }
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.DEFOLIATOR;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return itemstack.func_77973_b() == Items.field_151069_bo;
    }

    public int func_70302_i_() {
        return 2;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        return is.func_77973_b() == Items.field_151068_bn && ReikaPotionHelper.getPotionDamageValue((Potion)Potion.field_76436_u) == is.func_77960_j();
    }

    @Override
    public int getRange() {
        int r = (int)(8.0 * ReikaMathLibrary.logbase((long)this.torque, (int)2));
        return r > this.getMaxRange() ? this.getMaxRange() : r;
    }

    @Override
    public int getMaxRange() {
        return 128;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        return f == FluidRegistry.getFluid((String)"poison") || f == FluidRegistry.getFluid((String)"rc chlorine");
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from.offsetY == 0;
    }

    @Override
    public int getCapacity() {
        return 4000;
    }
}

