/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Surveying;

import Reika.DragonAPI.Instantiable.ConfigurableEntitySelector;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.RotaryCraft.API.Interfaces.RadarJammer;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityMobRadar
extends TileEntityPowerReceiver
implements GuiController,
RangedEffect {
    private List<EntityLivingBase> inzone = new ArrayList<EntityLivingBase>();
    public String owner;
    public static final int FALLOFF = 1024;
    public boolean hostile = true;
    public boolean animal = true;
    public boolean player = true;
    private boolean isJammed;
    private ConfigurableEntitySelector selector = new ConfigurableEntitySelector();

    public List<EntityLivingBase> getEntities() {
        return Collections.unmodifiableList(this.inzone);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getPowerBelow();
        this.getMobs(world, x, y, z);
    }

    @Override
    public int getRange() {
        int range = (int)(8L + (this.power - this.MINPOWER) / 1024L);
        return Math.min(range, this.getMaxRange());
    }

    public boolean isJammed() {
        return this.isJammed;
    }

    public void getMobs(World world, int x, int y, int z) {
        this.isJammed = false;
        int range = this.getRange();
        AxisAlignedBB zone = AxisAlignedBB.func_72330_a((double)(x - range), (double)0.0, (double)(z - range), (double)(x + 1 + range), (double)255.0, (double)(z + 1 + range));
        this.inzone = world.func_82733_a(EntityLivingBase.class, zone, this.getSelector());
        for (EntityLivingBase ent : this.inzone) {
            if (ent instanceof RadarJammer && ((RadarJammer)ent).jamRadar(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.isJammed = true;
                break;
            }
            int ex = (int)ent.field_70165_t - x;
            int ey = (int)ent.field_70163_u - y;
            int ez = (int)ent.field_70161_v - z;
        }
    }

    private IEntitySelector getSelector() {
        this.selector.animals = this.animal;
        this.selector.players = this.player;
        this.selector.hostiles = this.hostile;
        return this.selector;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        if (this.power < this.MINPOWER) {
            return;
        }
        this.phi += 4.0f;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.owner != null && !this.owner.isEmpty()) {
            NBT.func_74778_a("own", this.owner);
        }
        NBT.func_74757_a("jam", this.isJammed);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.owner = NBT.func_74779_i("own");
        this.isJammed = NBT.func_74767_n("jam");
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.MOBRADAR;
    }

    @Override
    public int getMaxRange() {
        return 256;
    }

    public int getRedstoneOverride() {
        return 0;
    }
}

