/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Production;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityObsidianMaker
extends InventoriedPowerReceiver
implements TemperatureTE,
PipeConnector,
IFluidHandler,
MultiOperational,
ConditionalOperation {
    public int mixTime;
    public int temperature;
    private int temptick = 0;
    public float overred;
    public float overgreen;
    public float overblue;
    public boolean idle = false;
    public static final int CAPACITY = 320000;
    public static final int MAXTEMP = 1000;
    private final HybridTank lava = new HybridTank("lavamix", 320000);
    private final HybridTank water = new HybridTank("watermix", 320000);

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        ++this.temptick;
        this.getPowerBelow();
        if (this.temptick >= 20) {
            this.updateTemperature(world, x, y, z, meta);
            this.temptick = 0;
        }
        if (this.power < this.MINPOWER || this.omega < this.MINSPEED || this.water.isEmpty() || this.lava.isEmpty()) {
            return;
        }
        this.testIdle();
        int n = this.getNumberConsecutiveOperations();
        for (int i = 0; i < n; ++i) {
            this.doOperation(n > 1);
        }
    }

    private void doOperation(boolean multiple) {
        if (multiple || this.tickcount >= this.getOperationTime()) {
            this.tickcount = 0;
            this.mix();
        }
    }

    public void testIdle() {
        boolean noliq = false;
        if (this.water.isEmpty() || this.lava.isEmpty()) {
            noliq = true;
        }
        boolean full = this.getNonFullStack() == -1;
        this.idle = full || noliq;
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        this.overblue = 0.0f;
        this.overgreen = 0.0f;
        this.overred = 0.0f;
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature < Tamb) {
            ++this.temperature;
        }
        if (!this.lava.isEmpty() && this.water.isEmpty()) {
            this.temperature += 3;
        }
        if (this.temperature > 500) {
            this.overred = 0.25f;
        }
        if ((double)this.temperature > 800.0) {
            this.overred = 0.4f;
            this.overgreen = 0.1f;
            RotaryCraft.logger.warn((Object)("WARNING: " + this + " is reaching very high temperature!"));
        }
        if (this.temperature > 1000 && ConfigRegistry.BLOCKDAMAGE.getState()) {
            this.overheat(world, x, y, z);
        }
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 3.0f, 1.0f);
        world.func_147449_b(x, y, z, (Block)Blocks.field_150356_k);
    }

    public void mix() {
        int slot = this.getNonFullStack();
        if (slot == -1) {
            return;
        }
        if (this.lava.getLevel() < 1000 || this.water.getLevel() < 1000) {
            return;
        }
        this.lava.removeLiquid(1000);
        this.water.removeLiquid(1000);
        ReikaInventoryHelper.addOrSetStack((Block)Blocks.field_150343_Z, (int)1, (int)0, (ItemStack[])this.inv, (int)slot);
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.fizz", 0.5f + 0.5f * rand.nextFloat(), 0.7f + 0.3f * rand.nextFloat());
        this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.75, (double)this.field_145849_e + 0.25, 0.0, 0.0, 0.0);
        this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.75, (double)this.field_145849_e + 0.5, 0.0, 0.0, 0.0);
        this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.75, (double)this.field_145849_e + 0.75, 0.0, 0.0, 0.0);
        this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.25, (double)this.field_145848_d + 0.75, (double)this.field_145849_e + 0.25, 0.0, 0.0, 0.0);
        this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.25, (double)this.field_145848_d + 0.75, (double)this.field_145849_e + 0.5, 0.0, 0.0, 0.0);
        this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.25, (double)this.field_145848_d + 0.75, (double)this.field_145849_e + 0.75, 0.0, 0.0, 0.0);
        this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.75, (double)this.field_145848_d + 0.75, (double)this.field_145849_e + 0.25, 0.0, 0.0, 0.0);
        this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.75, (double)this.field_145848_d + 0.75, (double)this.field_145849_e + 0.5, 0.0, 0.0, 0.0);
        this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.75, (double)this.field_145848_d + 0.75, (double)this.field_145849_e + 0.75, 0.0, 0.0, 0.0);
    }

    public int getNonFullStack() {
        int slot = -1;
        for (int k = 0; k < this.inv.length && slot == -1; ++k) {
            if (this.inv[k] == null) {
                slot = k;
                continue;
            }
            if (!ReikaItemHelper.matchStackWithBlock((ItemStack)this.inv[k], (Block)Blocks.field_150343_Z) || this.inv[k].field_77994_a >= this.func_70297_j_()) continue;
            slot = k;
        }
        return slot;
    }

    public int getWaterScaled(int par1) {
        return this.water.getLevel() * par1 / 320000;
    }

    public int getLavaScaled(int par1) {
        return this.lava.getLevel() * par1 / 320000;
    }

    public int func_70302_i_() {
        return 9;
    }

    public static boolean func_52005_b(ItemStack par0ItemStack) {
        return true;
    }

    public int getCookProgressScaled(int par1) {
        return this.mixTime * par1 / (600 - (int)(40.0 * ReikaMathLibrary.logbase((long)this.omega, (int)2)));
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.lava.writeToNBT(NBT);
        this.water.writeToNBT(NBT);
        NBT.func_74768_a("mix", this.mixTime);
        NBT.func_74768_a("temp", this.temperature);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.water.readFromNBT(NBT);
        this.lava.readFromNBT(NBT);
        this.mixTime = NBT.func_74762_e("mix");
        this.temperature = NBT.func_74762_e("temp");
    }

    @Override
    public boolean hasModelTransparency() {
        return true;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.OBSIDIAN;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return false;
    }

    @Override
    public int getThermalDamage() {
        return 0;
    }

    public int getRedstoneOverride() {
        if (this.getNonFullStack() == -1) {
            return 15;
        }
        if (this.lava.isEmpty()) {
            return 15;
        }
        if (this.water.isEmpty()) {
            return 15;
        }
        return 0;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return side.offsetY == 0;
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        Fluid f = resource.getFluid();
        if (!this.canFill(from, f)) {
            return 0;
        }
        if (f.equals(FluidRegistry.WATER)) {
            return this.water.fill(resource, doFill);
        }
        if (f.equals(FluidRegistry.LAVA)) {
            return this.lava.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from.offsetY != 0) {
            return false;
        }
        return fluid.equals(FluidRegistry.WATER) || fluid.equals(FluidRegistry.LAVA);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.lava.getInfo(), this.water.getInfo()};
    }

    public int getWater() {
        return this.water.getLevel();
    }

    public int getLava() {
        return this.lava.getLevel();
    }

    public void addWater(int amt) {
        this.water.addLiquid(amt, FluidRegistry.WATER);
    }

    public void addLava(int amt) {
        this.lava.addLiquid(amt, FluidRegistry.LAVA);
    }

    public void setLava(int amt) {
        this.lava.setContents(amt, FluidRegistry.LAVA);
    }

    public void setWater(int amt) {
        this.water.setContents(amt, FluidRegistry.WATER);
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side.offsetY == 0 ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.NONE;
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.OBSIDIAN.getOperationTime(this.omega);
    }

    @Override
    public int getNumberConsecutiveOperations() {
        return DurationRegistry.OBSIDIAN.getNumberOperations(this.omega);
    }

    @Override
    public boolean areConditionsMet() {
        return !this.lava.isEmpty() && !this.water.isEmpty();
    }

    @Override
    public String getOperationalStatus() {
        return this.lava.isEmpty() ? "No Lava" : (this.water.isEmpty() ? "No Water" : "Operational");
    }

    @Override
    public boolean canBeCooledWithFins() {
        return true;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    @Override
    public int getMaxTemperature() {
        return 1000;
    }
}

