/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Processing;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MystCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModList;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.EnchantableMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.MultiOperational;
import Reika.RotaryCraft.Base.TileEntity.InventoriedPowerReceiver;
import Reika.RotaryCraft.Registry.DurationRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.Recipes;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import thaumcraft.api.internal.WeightedRandomLoot;

public class TileEntityDropProcessor
extends InventoriedPowerReceiver
implements ConditionalOperation,
MultiOperational,
EnchantableMachine {
    private static final ArrayList<DropProcessing> dropHandlers = new ArrayList();
    private static final NoProcessing INVALID = new NoProcessing();
    private static final ItemHashMap<DropProcessing> itemMap = new ItemHashMap();
    private final ArrayList<ItemStack> overflow = new ArrayList();
    private HashMap<Enchantment, Integer> enchantments = new HashMap();
    public int dropProcessTime;

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return slot > 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        if (world.field_72995_K) {
            return;
        }
        this.getIOSidesDefault(world, x, y, z, meta);
        this.getPower(false);
        boolean flag1 = false;
        if (this.power >= this.MINPOWER && this.torque >= this.MINTORQUE) {
            int n = this.getNumberConsecutiveOperations();
            for (int i = 0; i < n; ++i) {
                flag1 |= this.doOperation(world, x, y, z, n > 1);
            }
        } else {
            this.dropProcessTime = 0;
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean doOperation(World world, int x, int y, int z, boolean multiple) {
        if (this.inv[1] == null) {
            if (this.overflow.isEmpty()) {
                if (this.inv[0] != null) {
                    if (TileEntityDropProcessor.isProcessable(this.inv[0])) {
                        ++this.dropProcessTime;
                        if (multiple || this.dropProcessTime >= this.getOperationTime()) {
                            this.dropProcessTime = 0;
                            this.processItem(world, x, y, z);
                        }
                        return true;
                    }
                }
                this.dropProcessTime = 0;
                return false;
            }
            this.dropProcessTime = 0;
            this.inv[1] = this.overflow.remove(0);
            return false;
        }
        this.dropProcessTime = 0;
        return false;
    }

    public static DropProcessing getHandler(ItemStack is) {
        DropProcessing d = (DropProcessing)itemMap.get(is);
        if (d != null) {
            return d;
        }
        for (DropProcessing d2 : dropHandlers) {
            if (!d2.isValidItem(is)) continue;
            d = d2;
            itemMap.put(is, (Object)d);
            return d;
        }
        itemMap.put(is, (Object)INVALID);
        return INVALID;
    }

    public static boolean isProcessable(ItemStack is) {
        return TileEntityDropProcessor.getHandler(is) != INVALID;
    }

    @SideOnly(value=Side.CLIENT)
    public static Collection<ItemStack> getAllProcessableItems() {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (DropProcessing p : dropHandlers) {
            li.addAll(p.getAllInputsForDisplay());
        }
        return li;
    }

    @SideOnly(value=Side.CLIENT)
    public static Collection<DropProcessing> getAllHandlersProducing(ItemStack is) {
        ArrayList<DropProcessing> li = new ArrayList<DropProcessing>();
        for (DropProcessing p : dropHandlers) {
            if (p instanceof BlockDropProcessing || !ReikaItemHelper.listContainsItemStack(p.getPotentialOutputsForDisplay(), (ItemStack)is, (boolean)false)) continue;
            li.add(p);
        }
        return li;
    }

    @SideOnly(value=Side.CLIENT)
    public static Collection<DropProcessing> getAllProcessors() {
        return Collections.unmodifiableCollection(dropHandlers);
    }

    private void processItem(World world, int x, int y, int z) {
        int fortune = this.getEnchantment(Enchantment.field_77346_s);
        EntityPlayer ep = this.getPlacer();
        DropProcessing dp = TileEntityDropProcessor.getHandler(this.inv[0]);
        try {
            Collection<ItemStack> c = dp.generateItems(world, x, y, z, fortune, ep, rand, this.inv[0]);
            ArrayList li = ReikaItemHelper.collateItemList(c);
            if (!li.isEmpty()) {
                this.inv[1] = (ItemStack)li.remove(0);
                this.overflow.addAll(li);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeError(e);
        }
        ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return TileEntityDropProcessor.isProcessable(is) && slot == 0;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.DROPS;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            int lvl;
            if (Enchantment.field_77331_b[i] == null || (lvl = this.getEnchantment(Enchantment.field_77331_b[i])) <= 0) continue;
            NBT.func_74768_a(Enchantment.field_77331_b[i].func_77320_a(), lvl);
        }
        NBTTagList li = new NBTTagList();
        NBT.func_74782_a("extra", (NBTBase)li);
        for (ItemStack is : this.overflow) {
            NBTTagCompound tag = new NBTTagCompound();
            is.func_77955_b(tag);
            li.func_74742_a((NBTBase)tag);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.enchantments = new HashMap();
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null) continue;
            int lvl = NBT.func_74762_e(Enchantment.field_77331_b[i].func_77320_a());
            this.enchantments.put(Enchantment.field_77331_b[i], lvl);
        }
        NBTTagList li = NBT.func_150295_c("extra", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        this.overflow.clear();
        for (Object o : li.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (is == null) continue;
            this.overflow.add(is);
        }
    }

    @Override
    public int getOperationTime() {
        return DurationRegistry.DROPS.getOperationTime(this.omega);
    }

    @Override
    public int getNumberConsecutiveOperations() {
        return DurationRegistry.DROPS.getNumberOperations(this.omega);
    }

    @Override
    public boolean areConditionsMet() {
        return this.inv[0] != null && ReikaItemHelper.isBlock((ItemStack)this.inv[0]) && this.inv[1] == null && this.overflow.isEmpty();
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "Missing Items/Full Output";
    }

    @Override
    public boolean applyEnchants(ItemStack is) {
        boolean accepted = false;
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77346_s, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77346_s, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77346_s, (ItemStack)is));
            accepted = true;
        }
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77342_w, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77342_w, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77342_w, (ItemStack)is));
            accepted = true;
        }
        if (ReikaEnchantmentHelper.hasEnchantment((Enchantment)Enchantment.field_77349_p, (ItemStack)is)) {
            this.enchantments.put(Enchantment.field_77349_p, ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantment.field_77349_p, (ItemStack)is));
            accepted = true;
        }
        return accepted;
    }

    @Override
    public ArrayList<Enchantment> getValidEnchantments() {
        ArrayList<Enchantment> li = new ArrayList<Enchantment>();
        li.add(Enchantment.field_77346_s);
        return li;
    }

    @Override
    public HashMap<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public boolean hasEnchantment(Enchantment e) {
        return this.getEnchantments().containsKey(e);
    }

    @Override
    public boolean hasEnchantments() {
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null || this.getEnchantment(Enchantment.field_77331_b[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnchantment(Enchantment e) {
        if (!this.hasEnchantment(e)) {
            return 0;
        }
        return this.getEnchantments().get(e);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.dropProcessTime = NBT.func_74765_d("CookTime");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74777_a("CookTime", (short)this.dropProcessTime);
    }

    public int getProgressScaled(int par1) {
        return this.dropProcessTime * par1 / 2 / this.getOperationTime();
    }

    public void dropCache() {
        ReikaItemHelper.dropItems((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), this.overflow);
        this.overflow.clear();
    }

    static {
        new BlockDropProcessing().register();
        new ScrapBoxProcessing().register();
        new ThaumBagProcessing().register();
        new CratedItemProcessing().register();
        new MystFolderProcessing().register();
    }

    private static class MystFolderProcessing
    extends DropProcessing {
        private MystFolderProcessing() {
        }

        @Override
        public boolean isValidItem(ItemStack is) {
            return is.func_77973_b() == MystCraftHandler.getInstance().folderID;
        }

        @Override
        protected Collection<ItemStack> generateItems(World world, int x, int y, int z, int fortune, EntityPlayer ep, Random rand, ItemStack src) throws Exception {
            return ReikaMystcraftHelper.getPagesInFolder((EntityPlayer)ep, (ItemStack)src, (boolean)true);
        }

        @Override
        protected boolean isLoadable() {
            return ModList.MYSTCRAFT.isLoaded();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ArrayList<ItemStack> getAllInputsForDisplay() {
            return ReikaJavaLibrary.makeListFrom((Object)new ItemStack(MystCraftHandler.getInstance().folderID));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<ItemStack> getOutputsOfInputForDisplay(ItemStack src) {
            try {
                return (List)this.generateItems(null, 0, 0, 0, 0, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, rand, src);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Collection<ItemStack> getPotentialOutputsForDisplay() {
            return new ArrayList<ItemStack>(ReikaMystcraftHelper.getAllAgePages());
        }
    }

    private static class CratedItemProcessing
    extends DropProcessing {
        private Class cratedItemClass;
        private Field cratedItem;

        private CratedItemProcessing() {
        }

        @Override
        protected void create() {
            try {
                this.cratedItemClass = Class.forName("forestry.core.items.ItemCrated");
                this.cratedItem = this.cratedItemClass.getDeclaredField("contained");
                this.cratedItem.setAccessible(true);
            }
            catch (Exception e) {
                RotaryCraft.logger.logError((Object)"Could not initialize Foestry crated item processing:");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.FORESTRY, e);
            }
        }

        @Override
        public boolean isValidItem(ItemStack is) {
            return is.func_77973_b().getClass() == this.cratedItemClass;
        }

        @Override
        protected Collection<ItemStack> generateItems(World world, int x, int y, int z, int fortune, EntityPlayer ep, Random rand, ItemStack src) throws Exception {
            ItemStack is = null;
            is = (ItemStack)this.cratedItem.get(src.func_77973_b());
            return is != null ? ReikaJavaLibrary.makeListFrom((Object)ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)9)) : new ArrayList();
        }

        @Override
        protected boolean isLoadable() {
            return ModList.FORESTRY.isLoaded();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ArrayList<ItemStack> getAllInputsForDisplay() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (Item i : ForestryHandler.getInstance().getAllCrates()) {
                li.add(new ItemStack(i));
            }
            return li;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<ItemStack> getOutputsOfInputForDisplay(ItemStack src) {
            try {
                return (ArrayList)this.generateItems(null, 0, 0, 0, 0, null, rand, src);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Collection<ItemStack> getPotentialOutputsForDisplay() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (ItemStack is : this.getAllInputsForDisplay()) {
                li.addAll(this.getOutputsOfInputForDisplay(is));
            }
            return li;
        }
    }

    private static class ThaumBagProcessing
    extends DropProcessing {
        private Class lootBagClass;
        private Method generateBagLoot;
        private Method getToolLoot;

        private ThaumBagProcessing() {
        }

        @Override
        protected void create() {
            try {
                this.lootBagClass = Class.forName("thaumcraft.common.items.ItemLootBag");
                Class<?> c = Class.forName("thaumcraft.common.lib.utils.Utils");
                this.generateBagLoot = c.getMethod("generateLoot", Integer.TYPE, Random.class);
                this.getToolLoot = c.getDeclaredMethod("getGearItemForSlot", Integer.TYPE, Integer.TYPE);
                this.getToolLoot.setAccessible(true);
            }
            catch (Exception e) {
                RotaryCraft.logger.logError((Object)"Could not initialize TC loot bag processing:");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.THAUMCRAFT, e);
            }
        }

        @Override
        public boolean isValidItem(ItemStack is) {
            return is.func_77973_b().getClass() == this.lootBagClass;
        }

        @Override
        protected Collection<ItemStack> generateItems(World world, int x, int y, int z, int fortune, EntityPlayer ep, Random rand, ItemStack src) throws Exception {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            int n = 8 + rand.nextInt(5);
            for (int i = 0; i < n; ++i) {
                ItemStack is = (ItemStack)this.generateBagLoot.invoke(null, src.func_77960_j(), rand);
                if (is == null) continue;
                li.add(is);
            }
            return li;
        }

        @Override
        protected boolean isLoadable() {
            return ModList.THAUMCRAFT.isLoaded();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ArrayList<ItemStack> getAllInputsForDisplay() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            li.add(ThaumItemHelper.ItemEntry.LOOTBAG1.getItem());
            li.add(ThaumItemHelper.ItemEntry.LOOTBAG2.getItem());
            li.add(ThaumItemHelper.ItemEntry.LOOTBAG3.getItem());
            return li;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<ItemStack> getOutputsOfInputForDisplay(ItemStack src) {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            ArrayList c = null;
            switch (src.func_77960_j()) {
                case 0: {
                    c = WeightedRandomLoot.lootBagCommon;
                    break;
                }
                case 1: {
                    c = WeightedRandomLoot.lootBagUncommon;
                    break;
                }
                case 2: {
                    c = WeightedRandomLoot.lootBagRare;
                }
            }
            if (c != null) {
                int totalWeight = WeightedRandom.func_76272_a((Collection)c);
                for (WeightedRandomLoot w : c) {
                    ItemStack is = w.item.func_77946_l();
                    if (is.field_77990_d == null) {
                        is.field_77990_d = new NBTTagCompound();
                    }
                    is.field_77990_d.func_74778_a("dropTooltip", String.valueOf(100.0f * (float)w.field_76292_a / (float)totalWeight) + "%");
                    li.add(is);
                }
            }
            try {
                if (src.func_77960_j() > 0) {
                    float toolc = 0.025f * (float)src.func_77960_j();
                    for (int slot = 0; slot <= 4; ++slot) {
                        for (int quality = 0; quality <= 6; ++quality) {
                            Item tool = (Item)this.getToolLoot.invoke(null, slot, quality);
                            float ch = toolc * 0.2f * (1.0f + 1.0f / (float)quality);
                            ItemStack is = new ItemStack(tool);
                            is.field_77990_d = new NBTTagCompound();
                            is.field_77990_d.func_74778_a("dropTooltip", "~" + String.valueOf(100.0f * ch) + "%");
                            li.add(is);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return li;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Collection<ItemStack> getPotentialOutputsForDisplay() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (ItemStack is : this.getAllInputsForDisplay()) {
                li.addAll(this.getOutputsOfInputForDisplay(is));
            }
            return li;
        }
    }

    private static class ScrapBoxProcessing
    extends DropProcessing {
        private ScrapBoxProcessing() {
        }

        @Override
        public boolean isValidItem(ItemStack is) {
            return IC2Handler.IC2Stacks.SCRAPBOX.match(is);
        }

        @Override
        protected Collection<ItemStack> generateItems(World world, int x, int y, int z, int fortune, EntityPlayer ep, Random rand, ItemStack src) throws Exception {
            return ReikaJavaLibrary.makeListFrom((Object)Recipes.scrapboxDrops.getDrop(src, false));
        }

        @Override
        protected boolean isLoadable() {
            return ModList.IC2.isLoaded();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ArrayList<ItemStack> getAllInputsForDisplay() {
            return ReikaJavaLibrary.makeListFrom((Object)IC2Handler.IC2Stacks.SCRAPBOX.getItem());
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<ItemStack> getOutputsOfInputForDisplay(ItemStack src) {
            Map map = Recipes.scrapboxDrops.getDrops();
            ArrayList<ItemStack> c = new ArrayList<ItemStack>();
            for (ItemStack is : map.keySet()) {
                ItemStack is2 = is.func_77946_l();
                if (is2.field_77990_d == null) {
                    is2.field_77990_d = new NBTTagCompound();
                }
                is2.field_77990_d.func_74778_a("dropTooltip", String.valueOf(((Float)map.get(is)).floatValue() * 100.0f) + "%");
                c.add(is2);
            }
            return c;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Collection<ItemStack> getPotentialOutputsForDisplay() {
            return this.getOutputsOfInputForDisplay(null);
        }
    }

    private static class BlockDropProcessing
    extends DropProcessing {
        private BlockDropProcessing() {
        }

        @Override
        protected Collection<ItemStack> generateItems(World world, int x, int y, int z, int fortune, EntityPlayer ep, Random rand, ItemStack src) throws Exception {
            Block b = Block.func_149634_a((Item)src.func_77973_b());
            ArrayList li = b.getDrops(world, x, y, z, src.func_77960_j(), fortune);
            return li;
        }

        @Override
        public boolean isValidItem(ItemStack is) {
            return ReikaItemHelper.isBlock((ItemStack)is);
        }

        @Override
        protected boolean isLoadable() {
            return true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ArrayList<ItemStack> getAllInputsForDisplay() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (Object o : Block.field_149771_c.func_148742_b()) {
                Item i;
                Block b = (Block)Block.field_149771_c.func_82594_a(o);
                if (ReikaBlockHelper.alwaysDropsSelf((Block)b) || b.func_149650_a(0, rand, 0) == null || b.func_149650_a(0, rand, 0) == Item.func_150898_a((Block)Blocks.field_150480_ab) || (i = Item.func_150898_a((Block)b)) == null) continue;
                try {
                    b.func_149666_a(i, b.func_149708_J(), li);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return li;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<ItemStack> getOutputsOfInputForDisplay(ItemStack src) {
            Block b = Block.func_149634_a((Item)src.func_77973_b());
            Random rand = new Random(System.currentTimeMillis() / 2000L);
            return ReikaJavaLibrary.makeListFrom((Object)new ItemStack(b.func_149650_a(src.func_77960_j(), rand, 0), b.quantityDropped(src.func_77960_j(), 0, rand), b.func_149692_a(src.func_77960_j())));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Collection<ItemStack> getPotentialOutputsForDisplay() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (ItemStack is : this.getAllInputsForDisplay()) {
                li.addAll(this.getOutputsOfInputForDisplay(is));
            }
            return li;
        }
    }

    private static class NoProcessing
    extends DropProcessing {
        private NoProcessing() {
        }

        @Override
        protected boolean isLoadable() {
            return true;
        }

        @Override
        public boolean isValidItem(ItemStack is) {
            return true;
        }

        @Override
        protected Collection<ItemStack> generateItems(World world, int x, int y, int z, int fortune, EntityPlayer ep, Random rand, ItemStack src) throws Exception {
            return new ArrayList<ItemStack>();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public ArrayList<ItemStack> getAllInputsForDisplay() {
            return new ArrayList<ItemStack>();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<ItemStack> getOutputsOfInputForDisplay(ItemStack src) {
            return new ArrayList<ItemStack>();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Collection<ItemStack> getPotentialOutputsForDisplay() {
            return this.getOutputsOfInputForDisplay(null);
        }
    }

    public static abstract class DropProcessing {
        final void register() {
            if (this.isLoadable()) {
                this.create();
                dropHandlers.add(this);
            }
        }

        protected void create() {
        }

        protected abstract boolean isLoadable();

        public abstract boolean isValidItem(ItemStack var1);

        protected abstract Collection<ItemStack> generateItems(World var1, int var2, int var3, int var4, int var5, EntityPlayer var6, Random var7, ItemStack var8) throws Exception;

        @SideOnly(value=Side.CLIENT)
        public abstract ArrayList<ItemStack> getAllInputsForDisplay();

        @SideOnly(value=Side.CLIENT)
        public abstract List<ItemStack> getOutputsOfInputForDisplay(ItemStack var1);

        @SideOnly(value=Side.CLIENT)
        public abstract Collection<ItemStack> getPotentialOutputsForDisplay();
    }
}

