/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft;

import Reika.DragonAPI.Auxiliary.EnumDifficulty;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.IO.ControlledConfig;
import Reika.DragonAPI.Interfaces.Configuration.ConfigList;
import Reika.DragonAPI.Interfaces.Registry.IDRegistry;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.RotaryCraft.Auxiliary.BlastGate;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.RotaryCraft;
import java.util.ArrayList;

public class RotaryConfig
extends ControlledConfig {
    private static final ArrayList<String> entries = ReikaJavaLibrary.getEnumEntriesWithoutInitializing(RotaryAchievements.class);
    private final ControlledConfig.DataElement<Integer>[] achievementIDs = new ControlledConfig.DataElement[entries.size()];
    private ControlledConfig.DataElement<String[]> blastGate;
    public static final int friction = 0;
    public static final int torquelimit = 0x3FFFFFFF;
    public static final int omegalimit = 0x3FFFFFFF;
    public static final boolean debugmode = false;
    public static final EnumDifficulty EASIEST = EnumDifficulty.EASY;
    public static final EnumDifficulty HARDEST = EnumDifficulty.HARD;

    public RotaryConfig(DragonAPIMod mod, ConfigList[] option, IDRegistry[] id) {
        super(mod, option, id);
        for (int i = 0; i < entries.size(); ++i) {
            String name = entries.get(i);
            this.achievementIDs[i] = this.registerAdditionalOption("Achievement IDs", name, 24000 + i);
        }
        this.blastGate = this.registerAdditionalOption("Other Options", "Alternate Blast Furnace Materials", new String[0]);
    }

    protected void onInit() {
    }

    public int getAchievementID(int idx) {
        return (Integer)this.achievementIDs[idx].getData();
    }

    public ArrayList<Object> getBlastFurnaceGatingMaterials() {
        String[] arr = (String[])this.blastGate.getData();
        if (arr == null || arr.length == 0) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> c = new ArrayList<Object>();
        boolean invalid = false;
        for (int i = 0; i < arr.length; ++i) {
            String idx = arr[i].toUpperCase();
            BlastGate g = null;
            try {
                g = BlastGate.valueOf(idx);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (g == null) {
                RotaryCraft.logger.logError((Object)("Gating material '" + idx + "' is invalid."));
                invalid = true;
                continue;
            }
            Object item = g.getItem();
            if (item == null) {
                RotaryCraft.logger.logError((Object)("Selected gating material " + (Object)((Object)g) + " could not be found; either the item does not exist or its mods have not yet loaded."));
                continue;
            }
            c.add(item);
        }
        if (invalid) {
            RotaryCraft.logger.log((Object)"Valid materials (case insensitive):");
            StringBuilder sb = new StringBuilder();
            for (BlastGate g : BlastGate.values()) {
                sb.append(g.name() + "; ");
            }
            RotaryCraft.logger.log((Object)sb.toString());
        }
        return c;
    }
}

