/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.ModInterface.Conversion;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Power.ReikaRailCraftHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RCToModConverter;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Base.TileEntity.PoweredLiquidIO;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBoiler
extends PoweredLiquidIO
implements TemperatureTE,
RCToModConverter {
    private int temperature;
    private long storedEnergy;
    public static final int CAPACITY = 27000;
    public static final int MAXTEMP = 500;
    private StepTimer timer = new StepTimer(20);

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BOILER;
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        if (this.output.isFull()) {
            return 15;
        }
        if (this.input.isEmpty()) {
            return 15;
        }
        return 0;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        TileEntity te;
        int mB;
        int space;
        super.updateTileEntity();
        this.getPowerBelow();
        this.timer.update();
        if (this.timer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
        if (this.acceptEnergy()) {
            this.storedEnergy = (long)((double)this.storedEnergy + (double)(this.power * 200L) * ConfigRegistry.getConverterEfficiency());
        }
        if (!world.field_72995_K && (space = this.output.getRemainingSpace()) > 0 && (mB = Math.min(space, Math.min(this.input.getLevel(), ReikaRailCraftHelper.getAmountConvertibleSteam((int)this.getInitTemp(), (long)this.storedEnergy)))) > 0) {
            this.makeSteam(mB);
        }
        if ((te = world.func_147438_o(x, y + 1, z)) instanceof IFluidHandler) {
            int amt;
            IFluidHandler ic = (IFluidHandler)te;
            if (this.output.getFluid() != null && (amt = ic.fill(ForgeDirection.DOWN, this.output.getFluid(), true)) > 0) {
                this.output.removeLiquid(amt);
            }
        }
    }

    private boolean acceptEnergy() {
        return this.temperature > 100 && !this.input.isEmpty() && !this.output.isFull();
    }

    private void makeSteam(int mB) {
        this.input.removeLiquid(mB);
        this.output.addLiquid(this.getProducedSteam(mB), FluidRegistry.getFluid((String)"steam"));
        this.storedEnergy = (long)((double)this.storedEnergy - ReikaRailCraftHelper.getSteamEnergy((int)this.getInitTemp(), (int)mB));
    }

    private int getProducedSteam(int mB) {
        return 8 * mB;
    }

    private int getInitTemp() {
        return ReikaWorldHelper.getAmbientTemperatureAt((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
    }

    public int getSteam() {
        return this.output.getFluid() != null ? this.output.getFluid().amount : 0;
    }

    public int getWater() {
        return this.input.getLevel();
    }

    @Override
    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        if (this.power > 0L) {
            this.temperature = (int)((double)this.temperature + 0.3125 * ReikaMathLibrary.logbase((long)this.power, (int)2));
        }
        this.temperature = this.temperature > Tamb ? (this.temperature -= (this.temperature - Tamb) / 40) : (this.temperature += (this.temperature - Tamb) / 40);
        if (this.temperature - Tamb <= 40 && this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > 500) {
            this.temperature = 500;
            this.overheat(world, x, y, z);
        }
        if (this.temperature > 50) {
            ForgeDirection side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150433_aE);
            if (side != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150350_a, (int)0);
            }
            if ((side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150358_i, (int)0);
            }
        }
    }

    @Override
    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public int getThermalDamage() {
        return 0;
    }

    @Override
    public void overheat(World world, int x, int y, int z) {
        world.func_147468_f(x, y, z);
        world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 6.0f, true);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("temp", this.temperature);
        NBT.func_74772_a("energy", this.storedEnergy);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.temperature = NBT.func_74762_e("temp");
        this.storedEnergy = NBT.func_74763_f("energy");
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public Fluid getInputFluid() {
        return FluidRegistry.WATER;
    }

    @Override
    public int getCapacity() {
        return 27000;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from.offsetY == 0;
    }

    @Override
    public boolean canOutputTo(ForgeDirection to) {
        return to == ForgeDirection.UP;
    }

    @Override
    public boolean canIntakeFromPipe(MachineRegistry p) {
        return p.isStandardPipe();
    }

    @Override
    public boolean canOutputToPipe(MachineRegistry p) {
        return p.isStandardPipe();
    }

    @Override
    public boolean canBeCooledWithFins() {
        return false;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    @Override
    public int getMaxTemperature() {
        return 500;
    }
}

