/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Entities;

import Reika.DragonAPI.Instantiable.Effects.EntityFluidFX;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.Base.EntityTurretShot;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Weaponry.TileEntityMultiCannon;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;

public class EntityGatlingShot
extends EntityTurretShot {
    public EntityGatlingShot(World world) {
        super(world);
    }

    public EntityGatlingShot(World world, double x, double y, double z, double vx, double vy, double vz, TileEntityMultiCannon r) {
        super(world, x, y, z, 0.0, 0.0, 0.0, r);
        this.field_70159_w = vx;
        this.field_70181_x = vy;
        this.field_70179_y = vz;
        if (!world.field_72995_K) {
            this.field_70133_I = true;
        }
        this.gun = r;
    }

    public void func_70071_h_() {
        if (this.gun == null) {
            this.func_70106_y();
            return;
        }
        if (this.field_70170_p.field_72995_K && this.func_145782_y() % 10 == 0) {
            double l = 0.25;
            for (double d = -l; d <= l; d += 0.0625) {
                double px = this.field_70165_t + this.field_70159_w * d;
                double py = this.field_70163_u + this.field_70181_x * d;
                double pz = this.field_70161_v + this.field_70179_y * d;
                float s = 3.0f * (float)(l - Math.abs(d) / 2.0);
                EntityFluidFX fx = new EntityFluidFX(this.field_70170_p, px, py, pz, FluidRegistry.LAVA).setLife(2).setScale(s);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
        ++this.field_70173_aa;
        boolean hit = false;
        World world = this.field_70170_p;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        Block id = this.field_70170_p.func_147439_a(x, y, z);
        int r = 1;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    Block id2 = world.func_147439_a(x + i, y + j, z + k);
                    if (!ConfigRegistry.ATTACKBLOCKS.getState() || id2.func_149688_o() != Material.field_151592_s && id2.func_149688_o() != Material.field_151588_w) continue;
                    ReikaSoundHelper.playBreakSound((World)world, (int)(x + i), (int)(y + j), (int)(z + k), (Block)Blocks.field_150359_w);
                    world.func_147449_b(x + i, y + j, z + k, Blocks.field_150350_a);
                }
            }
        }
        MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        List mobs = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_70046_E().func_72314_b(1.0, 1.0, 1.0));
        boolean bl = hit = mobs.size() > 0 || m != MachineRegistry.GATLING && id != Blocks.field_150350_a && !ReikaWorldHelper.softBlocks((IBlockAccess)this.field_70170_p, (int)x, (int)y, (int)z);
        if (hit) {
            this.func_70227_a(null);
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K && (this.field_70235_a != null && this.field_70235_a.field_70128_L || !this.field_70170_p.func_72899_e((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v))) {
            this.func_70106_y();
        } else {
            this.func_70030_z();
            Vec3 var15 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 var2 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition var3 = this.field_70170_p.func_72933_a(var15, var2);
            var15 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            var2 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (var3 != null) {
                var2 = Vec3.func_72443_a((double)var3.field_72307_f.field_72450_a, (double)var3.field_72307_f.field_72448_b, (double)var3.field_72307_f.field_72449_c);
            }
            Entity var4 = null;
            List var5 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double var6 = 0.0;
            for (int var8 = 0; var8 < var5.size(); ++var8) {
                double var13;
                float var10;
                AxisAlignedBB var11;
                MovingObjectPosition var12;
                Entity var9 = (Entity)var5.get(var8);
                if (!var9.func_70067_L() || var9.func_70028_i((Entity)this.field_70235_a) || (var12 = (var11 = var9.field_70121_D.func_72314_b((double)(var10 = 0.3f), (double)var10, (double)var10)).func_72327_a(var15, var2)) == null || !((var13 = var15.func_72438_d(var12.field_72307_f)) < var6) && var6 != 0.0) continue;
                var4 = var9;
                var6 = var13;
            }
            if (var4 != null) {
                var3 = new MovingObjectPosition(var4);
            }
            if (var3 != null) {
                this.func_70227_a(var3);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            if (this.func_70090_H()) {
                for (int var19 = 0; var19 < 4; ++var19) {
                    float var18 = 0.25f;
                    ReikaParticleHelper.BUBBLE.spawnAt(this.field_70170_p, this.field_70165_t - this.field_70159_w * (double)var18, this.field_70163_u - this.field_70181_x * (double)var18, this.field_70161_v - this.field_70179_y * (double)var18, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    @Override
    public void func_70227_a(MovingObjectPosition mov) {
        if (mov != null && MachineRegistry.getMachine((IBlockAccess)this.field_70170_p, mov.field_72311_b, mov.field_72312_c, mov.field_72309_d) == MachineRegistry.GATLING) {
            this.func_70106_y();
            return;
        }
        if (this.field_70128_L) {
            return;
        }
        World world = this.field_70170_p;
        double x = this.field_70165_t;
        double y = this.field_70163_u;
        double z = this.field_70161_v;
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        int r = 0;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    Block id = world.func_147439_a(x0 + i, y0 + j, z0 + k);
                    if (ConfigRegistry.ATTACKBLOCKS.getState() && (id.func_149688_o() == Material.field_151592_s || id.func_149688_o() == Material.field_151588_w)) {
                        ReikaSoundHelper.playBreakSound((World)world, (int)(x0 + i), (int)(y0 + j), (int)(z0 + k), (Block)Blocks.field_150359_w);
                        world.func_147449_b(x0 + i, y0 + j, z0 + k, Blocks.field_150350_a);
                    }
                    if (!world.field_72995_K || id.func_149688_o() == Material.field_151579_a || MachineRegistry.getMachine((IBlockAccess)this.field_70170_p, x0 + i, y0 + j, z0 + k) == MachineRegistry.GATLING) continue;
                    ReikaRenderHelper.spawnDropParticles((World)world, (int)(x0 + i), (int)(y0 + j), (int)(z0 + k), (Block)id, (int)world.func_72805_g(x0 + i, y0 + j, z0 + k));
                }
            }
        }
        double d = 1.5;
        AxisAlignedBB splash = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b(d, d, d);
        List dmgd = world.func_72872_a(Entity.class, splash);
        for (int l = 0; l < dmgd.size(); ++l) {
            Entity ent = (Entity)dmgd.get(l);
            if (ent instanceof EntityLivingBase) {
                EntityLivingBase el = (EntityLivingBase)ent;
                this.applyAttackEffectsToEntity(world, (Entity)el);
                continue;
            }
            if (!(ent instanceof EntityEnderCrystal) && !(ent instanceof EntityPainting) && !(ent instanceof EntityItemFrame)) continue;
            ent.func_70097_a(DamageSource.field_76377_j, (float)this.getAttackDamage());
        }
        this.func_70106_y();
    }

    @Override
    public int getAttackDamage() {
        return 1;
    }

    @Override
    protected void applyAttackEffectsToEntity(World world, Entity ent) {
        if (ent instanceof EntitySlime) {
            int in = ent.getEntityData().func_74762_e("embedded_rounds");
            ent.getEntityData().func_74768_a("embedded_rounds", in + 1);
            ReikaEntityHelper.knockbackEntityFromPos((double)((double)this.gun.field_145851_c + 0.5), (double)((double)this.gun.field_145848_d + 0.5), (double)((double)this.gun.field_145849_e + 0.5), (Entity)ent, (double)1.0);
            ent.func_70097_a(this.getDamageSource(), (float)this.getAttackDamage() / 8.0f);
            ent.field_70172_ad = 0;
        } else {
            ent.func_70097_a(this.getDamageSource(), (float)this.getAttackDamage());
            ReikaEntityHelper.knockbackEntityFromPos((double)((double)this.gun.field_145851_c + 0.5), (double)((double)this.gun.field_145848_d + 0.5), (double)((double)this.gun.field_145849_e + 0.5), (Entity)ent, (double)0.0625);
            ent.field_70172_ad = 0;
        }
    }
}

