/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Blocks;

import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.BlockModelledMachine;
import Reika.RotaryCraft.Items.Tools.ItemDebug;
import Reika.RotaryCraft.Items.Tools.ItemMeter;
import Reika.RotaryCraft.Items.Tools.ItemScrewdriver;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MaterialRegistry;
import Reika.RotaryCraft.RotaryCraft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityGearbox;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGearbox
extends BlockModelledMachine {
    public BlockGearbox(Material mat) {
        super(mat);
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityGearbox(MaterialRegistry.setType(meta));
    }

    @Override
    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        TileEntityGearbox tg = (TileEntityGearbox)world.func_147438_o(x, y, z);
        if (tg == null) {
            return 0;
        }
        if (tg.getGearboxType().isFlammable()) {
            return 60;
        }
        return 0;
    }

    public float getExplosionResistance(Entity ent, World world, int x, int y, int z, double eX, double eY, double eZ) {
        TileEntityGearbox gbx = (TileEntityGearbox)world.func_147438_o(x, y, z);
        if (gbx == null) {
            return 0.0f;
        }
        MaterialRegistry type = gbx.getGearboxType();
        switch (type) {
            case WOOD: {
                return 5.0f;
            }
            case STONE: {
                return 10.0f;
            }
            case STEEL: 
            case DIAMOND: 
            case BEDROCK: {
                return 15.0f;
            }
        }
        return 0.0f;
    }

    public float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        TileEntityGearbox gbx = (TileEntityGearbox)world.func_147438_o(x, y, z);
        if (gbx == null) {
            return 0.01f;
        }
        int mult = 1;
        if (ep.field_71071_by.func_70448_g() != null && ep.field_71071_by.func_70448_g().func_77973_b() == ItemRegistry.BEDPICK.getItemInstance()) {
            mult = 2;
        }
        if (this.canHarvest(world, ep, x, y, z)) {
            return (float)mult * 0.2f / (float)(gbx.getGearboxType().ordinal() + 1);
        }
        return 0.01f / (float)(gbx.getGearboxType().ordinal() + 1);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harv) {
        if (this.canHarvest(world, player, x, y, z)) {
            this.func_149636_a(world, player, x, y, z, 0);
        }
        return world.func_147468_f(x, y, z);
    }

    public boolean canHarvest(World world, EntityPlayer player, int x, int y, int z) {
        if (player.field_71075_bZ.field_75098_d) {
            return false;
        }
        TileEntityGearbox gbx = (TileEntityGearbox)world.func_147438_o(x, y, z);
        if (gbx == null) {
            return false;
        }
        MaterialRegistry type = gbx.getGearboxType();
        return type.isHarvestablePickaxe(player.field_71071_by.func_70448_g());
    }

    public void func_149636_a(World world, EntityPlayer ep, int x, int y, int z, int meta) {
        if (!this.canHarvest(world, ep, x, y, z)) {
            return;
        }
        TileEntityGearbox gbx = (TileEntityGearbox)world.func_147438_o(x, y, z);
        if (gbx != null) {
            int type = gbx.getGearboxType().ordinal();
            int ratio = gbx.func_145832_p() / 4;
            ItemStack todrop = ItemRegistry.GEARBOX.getStackOfMetadata(type + 5 * ratio);
            todrop.field_77990_d = gbx.getTagsToWriteToStack();
            if (gbx.isUnHarvestable()) {
                todrop = ReikaItemHelper.getSizedItemStack((ItemStack)ItemStacks.scrap, (int)(2 + this.par5Random.nextInt(12)));
            }
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)todrop);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase par5EntityLiving, ItemStack is) {
        int i;
        int prevmeta = world.func_72805_g(x, y, z);
        for (i = MathHelper.func_76128_c((double)((double)(par5EntityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)); i > 3; i -= 4) {
        }
        while (i < 0) {
            i += 4;
        }
        switch (i) {
            case 0: {
                world.func_72921_c(x, y, z, prevmeta + 2, 3);
                break;
            }
            case 1: {
                world.func_72921_c(x, y, z, prevmeta + 1, 3);
                break;
            }
            case 2: {
                world.func_72921_c(x, y, z, prevmeta + 3, 3);
                break;
            }
            case 3: {
                world.func_72921_c(x, y, z, prevmeta + 0, 3);
            }
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int par6, float par7, float par8, float par9) {
        if (RotaryCraft.instance.isLocked()) {
            return false;
        }
        TileEntityGearbox tile = (TileEntityGearbox)world.func_147438_o(x, y, z);
        if (ep.func_71045_bC() != null && ep.func_71045_bC().func_77973_b() == Items.field_151133_ar) {
            tile.clearLubricant();
            return true;
        }
        if (ep.func_71045_bC() != null && (ep.func_71045_bC().func_77973_b() instanceof ItemScrewdriver || ep.func_71045_bC().func_77973_b() instanceof ItemMeter || ep.func_71045_bC().func_77973_b() instanceof ItemDebug)) {
            return false;
        }
        if (tile != null) {
            ItemStack fix = tile.getGearboxType().getGearItem();
            ItemStack held = ep.func_71045_bC();
            if (held != null) {
                if (ReikaItemHelper.matchStacks((ItemStack)fix, (ItemStack)held)) {
                    boolean flag = tile.repair(1 + 20 * tile.getRandom().nextInt(18 - tile.getRatio()));
                    if (flag && !ep.field_71075_bZ.field_75098_d) {
                        int num = held.field_77994_a;
                        if (num > 1) {
                            ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, ReikaItemHelper.getSizedItemStack((ItemStack)fix, (int)(num - 1)));
                        } else {
                            ep.field_71071_by.func_70299_a(ep.field_71071_by.field_70461_c, null);
                        }
                    }
                    return true;
                }
                if (ReikaItemHelper.matchStacks((ItemStack)held, (ItemStack)ItemStacks.lubebucket) && held.field_77994_a == 1) {
                    int amt;
                    if (tile.getGearboxType().needsLubricant() && tile.canTakeLubricant(amt = 1000)) {
                        tile.addLubricant(amt);
                        if (!ep.field_71075_bZ.field_75098_d) {
                            ep.func_70062_b(0, new ItemStack(Items.field_151133_ar));
                        }
                    }
                    return true;
                }
            }
        }
        return super.func_149727_a(world, x, y, z, ep, par6, par7, par8, par9);
    }

    @Override
    public void func_149719_a(IBlockAccess par1iBlockAccess, int x, int y, int z) {
        this.setFullBlockBounds();
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityGearbox gbx = (TileEntityGearbox)world.func_147438_o(x, y, z);
        ItemStack is = ItemRegistry.GEARBOX.getStackOfMetadata(gbx.func_145832_p() / 4 * 5 + gbx.getGearboxType().ordinal());
        is.field_77990_d = gbx.getTagsToWriteToStack();
        ret.add(is);
        return ret;
    }
}

