/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base.TileEntity;

import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.RotaryCraft.Auxiliary.Interfaces.ConditionalOperation;
import Reika.RotaryCraft.Auxiliary.Interfaces.DiscreteFunction;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPowerReceiver;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.RotaryCraft;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class TileEntityAimedCannon
extends TileEntityPowerReceiver
implements RangedEffect,
DiscreteFunction,
ConditionalOperation {
    private List<String> safePlayers = new ArrayList<String>();
    public boolean targetPlayers = true;
    private int numSafePlayers = 0;
    public float theta;
    protected double[] target = new double[4];
    protected Entity closestMob;
    protected double voffset = -0.125;
    public static final int MAXLOWANGLE = -10;
    protected int dir = 1;
    public boolean isCustomAim;

    public final double[] getTarget() {
        return this.target;
    }

    protected void printSafeList() {
        for (int i = 0; i < this.safePlayers.size(); ++i) {
            String player = this.safePlayers.get(i);
            if (player == null) {
                player = "NULL PLAYER IN SLOT " + i;
            } else if (player.isEmpty()) {
                player = "EMPTY STRING PLAYER IN SLOT " + i;
            }
            RotaryCraft.logger.log((Object)("Side " + FMLCommonHandler.instance().getEffectiveSide() + ": Safe Player " + (i + 1) + " of " + this.safePlayers.size() + ": " + player));
        }
    }

    protected final double getFiringPositionY(double dy) {
        double a = this.dir == 1 ? 0.75 : 0.25;
        return (double)this.field_145848_d + this.voffset * 0.0 + a + dy;
    }

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        ++this.tickcount;
        if (this.field_145850_b.field_72995_K) {
            // empty if block
        }
        switch (this.func_145832_p()) {
            case 0: {
                this.getPowerBelow();
                this.dir = 1;
                break;
            }
            case 1: {
                this.getPowerAbove();
                this.dir = -1;
            }
        }
        if (this.power < this.MINPOWER) {
            return;
        }
        if (this.isCustomAim) {
            return;
        }
        this.target = this.getTarget(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.adjustAim(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.target);
    }

    public boolean isAimingAtTarget(World world, int x, int y, int z, double[] t) {
        float phi2;
        double[] tg = ReikaPhysicsHelper.cartesianToPolar((double)((double)x - t[0]), (double)((double)y - t[1]), (double)((double)z - t[2]));
        tg[1] = Math.abs(tg[1]) - 90.0;
        for (phi2 = this.phi; phi2 < 0.0f; phi2 += 360.0f) {
        }
        while (phi2 >= 360.0f) {
            phi2 -= 360.0f;
        }
        if (tg[2] - (double)phi2 > 180.0) {
            tg[2] = tg[2] - 360.0;
        }
        if (!ReikaMathLibrary.approxr((double)this.theta, (double)tg[1], (double)5.0)) {
            return false;
        }
        return ReikaMathLibrary.approxr((double)phi2, (double)tg[2], (double)5.0);
    }

    public void adjustAim(World world, int x, int y, int z, double[] t) {
        if (t[3] != 1.0) {
            return;
        }
        double dx = (double)x + 0.5 - t[0];
        double dy = (double)y + 0.5 - t[1];
        double dz = (double)z + 0.5 - t[2];
        double[] tg = ReikaPhysicsHelper.cartesianToPolar((double)dx, (double)dy, (double)dz);
        tg[1] = Math.abs(tg[1]) - 90.0 + 0.25;
        if (tg[2] - (double)this.phi > 180.0) {
            tg[2] = tg[2] - 360.0;
        }
        float movespeed = this.getAimingSpeed();
        if ((double)this.phi < tg[2]) {
            this.phi += movespeed * 2.0f;
        }
        if ((double)this.phi > tg[2]) {
            this.phi -= movespeed * 2.0f;
        }
        if ((double)this.theta < tg[1]) {
            this.theta += movespeed;
        }
        if ((double)this.theta > tg[1]) {
            this.theta -= movespeed;
        }
        if (this.theta < -10.0f && this.dir == 1) {
            this.theta = -10.0f;
        }
        if (this.theta > 10.0f && this.dir == -1) {
            this.theta = -10.0f;
        }
    }

    protected float getAimingSpeed() {
        return 1.0f;
    }

    public abstract boolean hasAmmo();

    protected abstract double[] getTarget(World var1, int var2, int var3, int var4);

    public abstract void fire(World var1, double[] var2);

    @Override
    public final void animateWithTick(World world, int x, int y, int z) {
    }

    protected abstract double randomOffset();

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74776_a("theta", this.theta);
        NBT.func_74776_a("phi", this.phi);
        NBT.func_74768_a("direction", this.dir);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("numsafe", this.numSafePlayers);
        NBT.func_74757_a("aim", this.isCustomAim);
        for (int i = 0; i < this.safePlayers.size(); ++i) {
            NBT.func_74778_a("Safe_Player_" + String.valueOf(i), this.safePlayers.get(i));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.isCustomAim = NBT.func_74767_n("aim");
        this.safePlayers = new ArrayList<String>();
        this.numSafePlayers = NBT.func_74762_e("numsafe");
        for (int i = 0; i < this.numSafePlayers; ++i) {
            this.safePlayers.add(NBT.func_74779_i("Safe_Player_" + String.valueOf(i)));
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.theta = NBT.func_74760_g("theta");
        this.phi = NBT.func_74760_g("phi");
        this.dir = NBT.func_74762_e("direction");
    }

    public int getUpdatePacketRadius() {
        return 192;
    }

    public final AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    protected abstract boolean isValidTarget(Entity var1);

    protected final boolean isMobOrUnlistedPlayer(EntityLivingBase ent) {
        return ReikaEntityHelper.isHostile((EntityLivingBase)ent) || this.targetPlayers && ent instanceof EntityPlayer && !this.playerIsSafe((EntityPlayer)ent);
    }

    public void addPlayerToWhiteList(String name) {
        ReikaChatHelper.write((Object)(name + " added to " + this.placer + "'s whitelist for the\n" + this.getName() + " at " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + "."));
        if (name.equals(this.placer)) {
            ReikaChatHelper.write((Object)("Note: " + name + " is the owner;"));
            ReikaChatHelper.write((Object)("They did not need to tell the " + this.getName() + " to not target them."));
        }
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            return;
        }
        this.safePlayers.add(name);
        ++this.numSafePlayers;
    }

    public void removePlayerFromWhiteList(String name) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.safePlayers.remove(name);
            --this.numSafePlayers;
        }
        this.safePlayers.removeAll(Arrays.asList("", null));
        ReikaChatHelper.write((Object)(name + " removed from " + this.placer + "'s " + this.getName() + " whitelist."));
    }

    public final boolean playerIsSafe(EntityPlayer ep) {
        if (!ConfigRegistry.TURRETPLAYERS.getState()) {
            return true;
        }
        if (ep.field_71075_bZ.field_75098_d) {
            return true;
        }
        String name = ep.func_70005_c_();
        if (name == null) {
            return true;
        }
        if (ReikaPlayerAPI.isReika((EntityPlayer)ep)) {
            return true;
        }
        if (this.getPlacer() == null) {
            return this.safePlayers.contains(name);
        }
        if (this.safePlayers == null) {
            return name.equals(this.getPlacer().func_70005_c_());
        }
        return this.safePlayers.contains(name) || name.equals(this.getPlacer().func_70005_c_());
    }

    public List<String> getCopyOfSafePlayerList() {
        return Collections.unmodifiableList(this.safePlayers);
    }

    @Override
    public int getOperationTime() {
        return 20;
    }

    @Override
    public boolean areConditionsMet() {
        return this.hasAmmo();
    }

    @Override
    public String getOperationalStatus() {
        return this.areConditionsMet() ? "Operational" : "No Ammunition";
    }
}

