/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Base.TileEntity;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Interfaces.TileEntity.ToggleTile;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.IntegratedGearboxable;
import Reika.RotaryCraft.Auxiliary.Interfaces.NBTMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Auxiliary.Interfaces.UpgradeableMachine;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Base.TileEntity.TileEntityEngine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityIOMachine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Items.Tools.ItemEngineUpgrade;
import Reika.RotaryCraft.Items.Tools.ItemIntegratedGearbox;
import Reika.RotaryCraft.Registry.ItemRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.lwjgl.input.Keyboard;

public abstract class EnergyToPowerBase
extends TileEntityIOMachine
implements SimpleProvider,
PowerGenerator,
GuiController,
UpgradeableMachine,
IFluidHandler,
PipeConnector,
TemperatureTE,
ToggleTile,
NBTMachine,
IntegratedGearboxable {
    private static final int MINBASE = -1;
    public static final int MAXTEMP = 500;
    public static final int TIERS = 6;
    protected int storedEnergy;
    protected int baseomega = -1;
    private ForgeDirection facingDir;
    private int temperature;
    private StepTimer tempTimer = new StepTimer(20);
    private static final boolean reika = DragonAPICore.isReikasComputer();
    private final HybridTank tank = new HybridTank("energytopower", 24000);
    private int tier;
    private RedstoneState rsState = RedstoneState.IGNORE;
    private boolean enabled = true;
    private boolean efficient = false;
    private int integratedGear = 0;
    private static final double[][] efficiencyTable = new double[2][6];

    private RedstoneState getRedstoneState() {
        return this.rsState != null ? this.rsState : RedstoneState.IGNORE;
    }

    private static double getEfficiency(int tier, boolean eff) {
        return efficiencyTable[eff ? 1 : 0][tier];
    }

    private static final long getTierPower(int tier) {
        return EnergyToPowerBase.getGenTorque(tier) * ReikaMathLibrary.intpow2((int)2, (int)EnergyToPowerBase.getMaxSpeedBase(tier));
    }

    private static final int getGenTorque(int tier) {
        return 8 * ReikaMathLibrary.intpow2((int)4, (int)tier);
    }

    public static final int getMaxSpeedBase(int tier) {
        return 8 + tier;
    }

    protected double getRelativeEfficiency() {
        return 1.0;
    }

    private final double getConsumption() {
        return 1.0 / this.getEfficiency();
    }

    public final double getEfficiency() {
        return EnergyToPowerBase.getEfficiency(this.tier, this.efficient) * this.getRelativeEfficiency();
    }

    public final long getTierPower() {
        return EnergyToPowerBase.getTierPower(this.tier);
    }

    public final int getGenTorque() {
        return TileEntityEngine.getIntegratedGearTorque(EnergyToPowerBase.getGenTorque(this.tier), this.integratedGear);
    }

    public final int getMaxSpeedBase() {
        return EnergyToPowerBase.getMaxSpeedBase(this.tier);
    }

    @Override
    public void updateTileEntity() {
        super.updateTileEntity();
        if (DragonAPICore.debugtest) {
            this.storedEnergy = this.getMaxStorage();
            this.tank.setContents(this.tank.getCapacity(), FluidRegistry.getFluid((String)"rc liquid nitrogen"));
        }
        if (this.storedEnergy < 0) {
            this.storedEnergy = 0;
        }
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p());
        }
    }

    public final int getTier() {
        return this.tier;
    }

    @Override
    public final void upgrade(ItemStack item) {
        if (item.func_77960_j() == ItemEngineUpgrade.Upgrades.EFFICIENCY.ordinal()) {
            this.efficient = true;
        } else {
            ++this.tier;
        }
        this.syncAllData(true);
    }

    @Override
    public final boolean canUpgradeWith(ItemStack item) {
        if (!this.efficient && item.func_77960_j() == ItemEngineUpgrade.Upgrades.EFFICIENCY.ordinal()) {
            return true;
        }
        if (this.tier >= 5) {
            return false;
        }
        if (item.func_77960_j() == 2) {
            if (item.field_77990_d == null) {
                return false;
            }
            if (item.field_77990_d.func_74762_e("magnet") < 720) {
                return false;
            }
        }
        return ItemRegistry.UPGRADE.matchItem(item) && item.func_77960_j() == this.tier + 1;
    }

    protected final boolean isMuffled() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        if (world.func_147439_a(x, y + 1, z) == Blocks.field_150325_L && world.func_147439_a(x, y - 1, z) == Blocks.field_150325_L) {
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            Block b;
            ForgeDirection dir = this.dirs[i];
            if (dir == ForgeDirection.DOWN) continue;
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if ((dir == this.write.getOpposite() || dir == this.write) && dir != ForgeDirection.UP || (b = world.func_147439_a(dx, dy, dz)) == Blocks.field_150325_L) continue;
            return false;
        }
        return true;
    }

    public final int getTierFromPowerOutput(long power) {
        for (int i = 0; i < 6; ++i) {
            long tier = EnergyToPowerBase.getTierPower(i);
            if (tier < power) continue;
            return i;
        }
        return 0;
    }

    public abstract boolean isValidSupplier(TileEntity var1);

    public boolean isRedstoneControlEnabled() {
        return this.getRedstoneState() != RedstoneState.IGNORE;
    }

    public ItemStack getRedstoneStateIcon() {
        return this.getRedstoneState().getDisplayIcon();
    }

    public boolean isEmitting() {
        if (!this.enabled) {
            return false;
        }
        if (this.isRedstoneControlEnabled()) {
            RedstoneState rs = this.getRedstoneState();
            return this.hasRedstoneSignal() ? rs == RedstoneState.HI : rs == RedstoneState.LOW;
        }
        return true;
    }

    public void incrementRedstoneState() {
        this.rsState = this.getRedstoneState().next();
    }

    public final int getStoredPower() {
        return this.storedEnergy;
    }

    public abstract int getMaxStorage();

    public final long getPowerLevel() {
        return this.isEmitting() ? (long)this.getMaxSpeed() * (long)this.getActualTorque() : 0L;
    }

    public final int getSpeed() {
        return this.omega;
    }

    public final int getMaxSpeed() {
        if (this.baseomega < 0) {
            return 0;
        }
        return TileEntityEngine.getIntegratedGearSpeed(ReikaMathLibrary.intpow2((int)2, (int)this.baseomega), this.integratedGear);
    }

    protected final void updateSpeed() {
        boolean accel;
        int maxspeed = this.isEmitting() ? this.getMaxSpeed() : 0;
        float mult = 1.0f;
        boolean bl = accel = this.omega <= maxspeed && this.hasEnoughEnergy();
        if (accel) {
            mult = 1.5f;
            this.omega = (int)((double)this.omega + 4.0 * ReikaMathLibrary.logbase((long)(maxspeed + 1), (int)2));
            if (this.omega > maxspeed) {
                this.omega = maxspeed;
            }
        } else if (this.omega > 0) {
            this.omega -= this.omega / 256 + 1;
        }
        this.torque = this.getActualTorque();
        this.power = (long)this.torque * (long)this.omega;
        if (this.power > 0L && !this.field_145850_b.field_72995_K) {
            this.usePower(mult);
        }
    }

    protected void usePower(float mult) {
        this.storedEnergy = (int)((float)this.storedEnergy - (float)this.getConsumedUnitsPerTick() * mult);
        if (this.storedEnergy < 0) {
            this.storedEnergy = 0;
        }
    }

    public final int getActualTorque() {
        return this.omega > 0 ? this.getGenTorque() : 0;
    }

    public final boolean hasEnoughEnergy() {
        float energy = this.getStoredPower();
        return energy > (float)this.getConsumedUnitsPerTick();
    }

    protected abstract int getIdealConsumedUnitsPerTick();

    public final int getConsumedUnitsPerTick() {
        return MathHelper.func_76143_f((double)((double)this.getIdealConsumedUnitsPerTick() * this.getConsumption()));
    }

    @Override
    public final void setDataFromItemStackTag(NBTTagCompound nbt) {
        if (nbt != null) {
            this.tier = nbt.func_74762_e("tier");
            this.efficient = nbt.func_74767_n("efficient");
            this.storedEnergy = nbt.func_74762_e("energy");
            int c = nbt.func_74762_e("coolant");
            if (c > 0) {
                this.tank.setContents(c, FluidRegistry.getFluid((String)"rc liquid nitrogen"));
            }
        }
    }

    @Override
    public final ArrayList<NBTTagCompound> getCreativeModeVariants() {
        ArrayList<NBTTagCompound> li = new ArrayList<NBTTagCompound>();
        li.add(new NBTTagCompound());
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("tier", 5);
        li.add(tag);
        return li;
    }

    @Override
    public final ArrayList<String> getDisplayTags(NBTTagCompound NBT) {
        ArrayList<String> li = new ArrayList<String>();
        this.setDataFromItemStackTag(NBT);
        li.add(String.format("Tier %d", this.tier));
        if (this.efficient) {
            li.add(EnumChatFormatting.GOLD + "Efficiency Boost");
        }
        if (Keyboard.isKeyDown((int)42)) {
            int torque = this.getGenTorque();
            int speed = ReikaMathLibrary.intpow2((int)2, (int)EnergyToPowerBase.getMaxSpeedBase(this.tier));
            long power = (long)torque * (long)speed;
            double val = ReikaMathLibrary.getThousandBase((double)power);
            String exp = ReikaEngLibrary.getSIPrefix((double)power);
            li.add(String.format("Torque: %d Nm", torque));
            li.add(String.format("Max Speed: %d rad/s", speed));
            li.add(String.format("Max Power: %.3f%sW", val, exp));
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Hold ");
            sb.append(EnumChatFormatting.GREEN.toString());
            sb.append("Shift");
            sb.append(EnumChatFormatting.GRAY.toString());
            sb.append(" for power data");
            li.add(sb.toString());
        }
        return li;
    }

    @Override
    public final NBTTagCompound getTagsToWriteToStack() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("tier", this.tier);
        nbt.func_74757_a("efficient", this.efficient);
        nbt.func_74768_a("energy", this.storedEnergy);
        nbt.func_74768_a("coolant", this.tank.getLevel());
        return nbt;
    }

    public final void incrementOmega() {
        if (this.baseomega < this.getMaxSpeedBase()) {
            ++this.baseomega;
            while (this.baseomega < this.getMaxSpeedBase() && this.getMaxSpeed() == 0) {
                ++this.baseomega;
            }
        }
    }

    public final void decrementOmega() {
        if (this.baseomega > -1) {
            --this.baseomega;
        }
    }

    public final int getEnergyScaled(int h) {
        return (int)(this.getPercentStorage() * (float)h);
    }

    public final float getPercentStorage() {
        return (float)this.getStoredPower() / (float)this.getMaxStorage();
    }

    protected final void getIOSides(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 0: {
                this.facingDir = ForgeDirection.NORTH;
                break;
            }
            case 1: {
                this.facingDir = ForgeDirection.WEST;
                break;
            }
            case 2: {
                this.facingDir = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                this.facingDir = ForgeDirection.EAST;
            }
        }
        this.read = this.facingDir;
        this.write = this.read.getOpposite();
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("storage", this.storedEnergy);
        NBT.func_74768_a("tiero", this.baseomega);
        NBT.func_74768_a("rs", this.getRedstoneState().ordinal());
        if (this.baseomega > EnergyToPowerBase.getMaxSpeedBase(this.tier)) {
            this.baseomega = -1;
        }
        NBT.func_74768_a("level", this.tier);
        this.tank.writeToNBT(NBT);
        NBT.func_74768_a("temp", this.temperature);
        NBT.func_74757_a("t_enable", this.enabled);
        NBT.func_74757_a("efficient", this.efficient);
        NBT.func_74768_a("gear", this.integratedGear);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.storedEnergy = NBT.func_74762_e("storage");
        this.rsState = RedstoneState.list[NBT.func_74762_e("rs")];
        this.tier = NBT.func_74762_e("level");
        if (this.baseomega > EnergyToPowerBase.getMaxSpeedBase(this.tier)) {
            this.baseomega = -1;
        }
        this.baseomega = NBT.func_74762_e("tiero");
        this.tank.readFromNBT(NBT);
        this.temperature = NBT.func_74762_e("temp");
        if (NBT.func_74764_b("t_enable")) {
            this.enabled = NBT.func_74767_n("t_enable");
        }
        this.efficient = NBT.func_74767_n("efficient");
        this.integratedGear = NBT.func_74762_e("gear");
    }

    @Override
    public final long getCurrentPower() {
        return this.power;
    }

    @Override
    public final long getMaxPower() {
        return this.getTierPower();
    }

    @Override
    public final PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        return new PowerSourceList().addSource(this);
    }

    @Override
    public final boolean canProvidePower() {
        return true;
    }

    public abstract String getUnitDisplay();

    public abstract int getPowerColor();

    public final ForgeDirection getFacing() {
        return this.facingDir != null ? this.facingDir : ForgeDirection.EAST;
    }

    public final TileEntity getProvidingTileEntity() {
        int x = this.field_145851_c + this.getFacing().offsetX;
        int y = this.field_145848_d + this.getFacing().offsetY;
        int z = this.field_145849_e + this.getFacing().offsetZ;
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        return te;
    }

    @Override
    public int getEmittingX() {
        return this.field_145851_c + this.write.offsetX;
    }

    @Override
    public int getEmittingY() {
        return this.field_145848_d + this.write.offsetY;
    }

    @Override
    public int getEmittingZ() {
        return this.field_145849_e + this.write.offsetZ;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) ? this.tank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid.equals(FluidRegistry.getFluid((String)"rc liquid nitrogen"));
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return p.isStandardPipe();
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return TileEntityPiping.Flow.INPUT;
    }

    public final int getLubricant() {
        return this.tank.getLevel();
    }

    public final int getMaxLubricant() {
        return this.tank.getCapacity();
    }

    public final int getLubricantScaled(int a) {
        return this.tank.getLevel() * a / this.tank.getCapacity();
    }

    @Override
    public final void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb;
        int n = Tamb = this.tank.isEmpty() ? ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z) : 25;
        if (this.power > 0L) {
            double d = this.tank.getLevel() >= 50 ? 0.00275 : 0.14;
            double inc = d * Math.sqrt(this.power) + ReikaMathLibrary.logbase((long)(this.tier + 1), (int)2);
            this.temperature = (int)((double)this.temperature + inc);
            if (this.temperature > Tamb && !this.tank.isEmpty()) {
                int drain = Math.max(2, 50 * this.temperature / 500);
                this.tank.removeLiquid(drain);
            }
        }
        this.temperature = this.temperature > Tamb ? (this.temperature -= (this.temperature - Tamb) / 16) : (this.temperature += (this.temperature - Tamb) / 16);
        if (this.temperature - Tamb <= 16 && this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > 500) {
            this.temperature = 500;
            if (!world.field_72995_K) {
                this.overheat(world, x, y, z);
            }
        }
        if (this.temperature < Tamb) {
            this.temperature = Tamb;
        }
    }

    @Override
    public final void addTemperature(int temp) {
        this.temperature += temp;
    }

    @Override
    public final int getTemperature() {
        return this.temperature;
    }

    @Override
    public final int getThermalDamage() {
        return 0;
    }

    @Override
    public final void overheat(World world, int x, int y, int z) {
        this.delete();
        world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, true, true);
    }

    @Override
    public final boolean canBeCooledWithFins() {
        return false;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    public final void setTemperature(int temp) {
        this.temperature = temp;
    }

    @Override
    public void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        if (dir == this.read) {
            c.add(this.getAdjacentTileEntity(this.write));
        }
    }

    @Override
    public final int getMaxTemperature() {
        return 500;
    }

    public static String getTiersAsString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            int om = ReikaMathLibrary.intpow2((int)2, (int)EnergyToPowerBase.getMaxSpeedBase(i));
            int tq = EnergyToPowerBase.getGenTorque(i);
            long pwr = EnergyToPowerBase.getTierPower(i);
            double base = ReikaMathLibrary.getThousandBase((double)pwr);
            String eng = ReikaEngLibrary.getSIPrefix((double)pwr);
            String s = String.format("Tier %d - Torque: %dNm; Max Speed: %d rad/s; Power: %.3f%sW", i, tq, om, base, eng);
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enable) {
        this.enabled = enable;
        this.syncAllData(false);
    }

    public final void breakBlock() {
        if (this.integratedGear != 0) {
            ItemStack is = ItemIntegratedGearbox.getIntegratedGearItem(this.integratedGear, null);
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + rand.nextDouble()), (double)((double)this.field_145848_d + rand.nextDouble()), (double)((double)this.field_145849_e + rand.nextDouble()), (ItemStack)is);
        }
    }

    @Override
    public final boolean applyIntegratedGear(ItemStack is) {
        if (is == null || !ItemRegistry.GEARUPGRADE.matchItem(is)) {
            return false;
        }
        if (this.integratedGear != 0) {
            return false;
        }
        if (this.omega > 0 || this.power > 0L) {
            return false;
        }
        this.integratedGear = ItemIntegratedGearbox.getRatioFromIntegratedGearItem(is, true);
        this.syncAllData(true);
        return this.integratedGear != 0;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            EnergyToPowerBase.efficiencyTable[0][i] = 0.9 - (double)i * 0.08;
            EnergyToPowerBase.efficiencyTable[1][i] = 1.0 - Math.pow(i, 1.4) * 0.04;
        }
    }

    private static enum RedstoneState {
        IGNORE(Items.field_151016_H),
        LOW(Blocks.field_150437_az),
        HI(Blocks.field_150429_aA);

        private final ItemStack iconItem;
        public static final RedstoneState[] list;

        private RedstoneState(Item i) {
            this(new ItemStack(i));
        }

        private RedstoneState(Block i) {
            this(new ItemStack(i));
        }

        private RedstoneState(ItemStack is) {
            this.iconItem = is.func_77946_l();
        }

        public ItemStack getDisplayIcon() {
            return this.iconItem.func_77946_l();
        }

        public RedstoneState next() {
            return this.ordinal() < list.length - 1 ? list[this.ordinal() + 1] : list[0];
        }

        static {
            list = RedstoneState.values();
        }
    }
}

