/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.Auxiliary.RecipeManagers;

import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.IO.CustomRecipeList;
import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.RotaryCraft.API.RecipeInterface;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.RecipeHandler;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class RecipesWetter
extends RecipeHandler
implements RecipeInterface.WetterManager {
    private static final RecipesWetter WetterBase = new RecipesWetter();
    private final ItemHashMap<HashMap<Fluid, WettingRecipe>> recipeList = new ItemHashMap();
    private final HashSet<String> fluids = new HashSet();

    public static final RecipesWetter getRecipes() {
        return WetterBase;
    }

    private RecipesWetter() {
        super(MachineRegistry.WETTER);
        RecipeInterface.wetter = this;
        this.addRecipe(new ItemStack((Block)Blocks.field_150354_m), "rc lubricant", 500, new ItemStack(Blocks.field_150425_aM), 200, RecipeHandler.RecipeLevel.PROTECTED);
        this.addRecipe(new ItemStack((Block)Blocks.field_150354_m), "oil", 125, new ItemStack(Blocks.field_150425_aM), 50, RecipeHandler.RecipeLevel.MODINTERACT);
        this.addRecipe(new ItemStack(Blocks.field_150347_e), "rc jet fuel", 20, new ItemStack(Blocks.field_150424_aL), 80, RecipeHandler.RecipeLevel.PERIPHERAL);
        this.addRecipe(new ItemStack(Blocks.field_150347_e), "ender", 50, new ItemStack(Blocks.field_150377_bs), 80, RecipeHandler.RecipeLevel.MODINTERACT);
    }

    @Override
    public void addAPIRecipe(ItemStack in, Fluid f, int amount, ItemStack out, int time) {
        this.addRecipe(in, f, amount, out, time, RecipeHandler.RecipeLevel.API);
    }

    private void addRecipe(ItemStack in, String s, int amount, ItemStack out, int time, RecipeHandler.RecipeLevel rl) {
        Fluid f = FluidRegistry.getFluid((String)s);
        if (f != null) {
            this.addRecipe(in, f, amount, out, time, rl);
        }
    }

    private void addRecipe(ItemStack in, Fluid f, int amount, ItemStack out, int time, RecipeHandler.RecipeLevel rl) {
        WettingRecipe wr = new WettingRecipe(in, new FluidStack(f, amount), out, time);
        HashMap<Fluid, WettingRecipe> map = (HashMap<Fluid, WettingRecipe>)this.recipeList.get(in);
        if (map == null) {
            map = new HashMap<Fluid, WettingRecipe>();
            this.recipeList.put(in, map);
        }
        map.put(f, wr);
        this.fluids.add(f.getName());
        this.onAddRecipe(wr, rl);
    }

    public WettingRecipe getRecipe(ItemStack is, FluidStack liquid) {
        HashMap map = (HashMap)this.recipeList.get(is);
        if (map == null) {
            return null;
        }
        Fluid f = liquid.getFluid();
        WettingRecipe wr = (WettingRecipe)map.get(f);
        return liquid.amount >= ((WettingRecipe)wr).fluid.amount ? wr : null;
    }

    public boolean isValidFluid(Fluid f) {
        return this.fluids.contains(f.getName());
    }

    public Collection<WettingRecipe> getAllRecipes() {
        ArrayList<WettingRecipe> c = new ArrayList<WettingRecipe>();
        for (ItemStack is : this.recipeList.keySet()) {
            HashMap map = (HashMap)this.recipeList.get(is);
            c.addAll(map.values());
        }
        return c;
    }

    public boolean isWettable(ItemStack is) {
        return this.recipeList.containsKey(is);
    }

    public boolean isWettableWith(ItemStack is, Fluid f) {
        HashMap c = (HashMap)this.recipeList.get(is);
        return c != null && c.containsKey(f);
    }

    public Collection<WettingRecipe> getRecipesByResult(ItemStack result) {
        ArrayList<WettingRecipe> c = new ArrayList<WettingRecipe>();
        for (WettingRecipe r : this.getAllRecipes()) {
            if (!ReikaItemHelper.matchStacks((ItemStack)r.output, (ItemStack)result)) continue;
            c.add(r);
        }
        return c;
    }

    public Collection<WettingRecipe> getRecipesByFluid(Fluid fluid) {
        ArrayList<WettingRecipe> c = new ArrayList<WettingRecipe>();
        for (WettingRecipe r : this.getAllRecipes()) {
            if (r.fluid.getFluid() != fluid) continue;
            c.add(r);
        }
        return c;
    }

    public Collection<WettingRecipe> getRecipesUsing(ItemStack ingredient) {
        HashMap map = (HashMap)this.recipeList.get(ingredient);
        return map != null ? Collections.unmodifiableCollection(map.values()) : null;
    }

    @Override
    public void addPostLoadRecipes() {
    }

    @Override
    protected boolean removeRecipe(RecipeHandler.MachineRecipe recipe) {
        WettingRecipe wr = (WettingRecipe)recipe;
        boolean flag = false;
        ArrayList<ItemStack> rem = new ArrayList<ItemStack>();
        for (ItemStack is : this.recipeList.keySet()) {
            HashMap map = (HashMap)this.recipeList.get(is);
            flag |= ReikaJavaLibrary.removeValuesFromMap((Map)map, (Object)wr);
            if (!map.isEmpty()) continue;
            rem.add(is);
        }
        for (ItemStack is : rem) {
            this.recipeList.remove(is);
        }
        return flag;
    }

    @Override
    protected boolean addCustomRecipe(LuaBlock lb, CustomRecipeList crl) throws Exception {
        ItemStack in = crl.parseItemString(lb.getString("input"), null, false);
        ItemStack out = crl.parseItemString(lb.getString("output"), lb.getChild("output_nbt"), false);
        this.verifyOutputItem(out);
        String fluid = lb.getString("input_fluid");
        Fluid f = FluidRegistry.getFluid((String)fluid);
        if (f == null) {
            throw new IllegalArgumentException("Fluid '" + fluid + "' does not exist!");
        }
        int amt = lb.getInt("input_amount");
        int time = lb.getInt("duration");
        this.addRecipe(in, f, amt, out, time, RecipeHandler.RecipeLevel.CUSTOM);
        return true;
    }

    public static class WettingRecipe
    implements RecipeHandler.MachineRecipe {
        public final int duration;
        private final FluidStack fluid;
        private final ItemStack input;
        private final ItemStack output;

        private WettingRecipe(ItemStack in, FluidStack fin, ItemStack out, int time) {
            this.input = in;
            this.output = out;
            this.fluid = fin;
            this.duration = time;
        }

        public FluidStack getFluid() {
            return this.fluid.copy();
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        @Override
        public String getUniqueID() {
            return this.fluid.getFluid().getName() + ":" + this.fluid.amount + "+" + RecipeHandler.fullID(this.input) + ">" + RecipeHandler.fullID(this.output) + "#" + this.duration;
        }

        @Override
        public String getAllInfo() {
            return "Mixing " + this.fluid.amount + " of " + this.fluid.getLocalizedName() + " into " + RecipeHandler.fullID(this.input) + " for " + RecipeHandler.fullID(this.output) + " over " + this.duration + " ticks";
        }

        @Override
        public Collection<ItemStack> getAllUsedItems() {
            return ReikaJavaLibrary.makeListFrom((Object[])new Object[]{this.input, this.output});
        }
    }
}

